/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.base;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.geo.NormalPlane;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Facing {
    DOWN(Axis.Y, false, new Vec3i(0, -1, 0)){

        @Override
        public Facing opposite() {
            return UP;
        }

        @Override
        public Direction toVanilla() {
            return Direction.DOWN;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82289_;
        }
    }
    ,
    UP(Axis.Y, true, new Vec3i(0, 1, 0)){

        @Override
        public Facing opposite() {
            return DOWN;
        }

        @Override
        public Direction toVanilla() {
            return Direction.UP;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82292_;
        }
    }
    ,
    NORTH(Axis.Z, false, new Vec3i(0, 0, -1)){

        @Override
        public Facing opposite() {
            return SOUTH;
        }

        @Override
        public Direction toVanilla() {
            return Direction.NORTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82290_;
        }
    }
    ,
    SOUTH(Axis.Z, true, new Vec3i(0, 0, 1)){

        @Override
        public Facing opposite() {
            return NORTH;
        }

        @Override
        public Direction toVanilla() {
            return Direction.SOUTH;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82293_;
        }
    }
    ,
    WEST(Axis.X, false, new Vec3i(-1, 0, 0)){

        @Override
        public Facing opposite() {
            return EAST;
        }

        @Override
        public Direction toVanilla() {
            return Direction.WEST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82288_;
        }
    }
    ,
    EAST(Axis.X, true, new Vec3i(1, 0, 0)){

        @Override
        public Facing opposite() {
            return WEST;
        }

        @Override
        public Direction toVanilla() {
            return Direction.EAST;
        }

        @Override
        public double get(AABB bb) {
            return bb.f_82291_;
        }
    };

    public static final String[] FACING_NAMES;
    public static final String[] HORIZONTAL_FACING_NAMES;
    public final String name = this.name().toLowerCase();
    public final Axis axis;
    public final boolean positive;
    public final Vec3i normal;
    public final NormalPlane plane;

    public static Facing get(int index) {
        switch (index) {
            case 0: {
                return DOWN;
            }
            case 1: {
                return UP;
            }
            case 2: {
                return NORTH;
            }
            case 3: {
                return SOUTH;
            }
            case 4: {
                return WEST;
            }
            case 5: {
                return EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Facing get(Direction direction) {
        switch (direction) {
            case DOWN: {
                return DOWN;
            }
            case UP: {
                return UP;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Facing get(Axis axis, boolean positive) {
        switch (axis) {
            case X: {
                return positive ? EAST : WEST;
            }
            case Y: {
                return positive ? UP : DOWN;
            }
            case Z: {
                return positive ? SOUTH : NORTH;
            }
        }
        throw new IllegalArgumentException();
    }

    private Facing(Axis axis, boolean positive, Vec3i normal) {
        this.axis = axis;
        this.positive = positive;
        this.normal = normal;
        this.plane = new NormalPlane(this);
    }

    public int offset() {
        return this.positive ? 1 : -1;
    }

    public abstract Facing opposite();

    public abstract Direction toVanilla();

    public Axis one() {
        return this.axis.one();
    }

    public Axis two() {
        return this.axis.two();
    }

    public Axis getUAxis() {
        switch (this.axis) {
            case X: {
                return Axis.Z;
            }
            case Y: {
                return Axis.X;
            }
            case Z: {
                return Axis.X;
            }
        }
        return null;
    }

    public Axis getVAxis() {
        switch (this.axis) {
            case X: {
                return Axis.Y;
            }
            case Y: {
                return Axis.Z;
            }
            case Z: {
                return Axis.Y;
            }
        }
        return null;
    }

    public float getU(float x, float y, float z) {
        switch (this.axis) {
            case X: {
                return z;
            }
            case Y: {
                return x;
            }
            case Z: {
                return x;
            }
        }
        return 0.0f;
    }

    public float getV(float x, float y, float z) {
        switch (this.axis) {
            case X: {
                return y;
            }
            case Y: {
                return z;
            }
            case Z: {
                return y;
            }
        }
        return 0.0f;
    }

    public abstract double get(AABB var1);

    static {
        FACING_NAMES = new String[]{"down", "up", "north", "south", "west", "east"};
        HORIZONTAL_FACING_NAMES = new String[]{"north", "south", "west", "east"};
    }
}

