/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.box;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public class CreativeAABB
extends AABB {
    public CreativeAABB(double x1, double y1, double z1, double x2, double y2, double z2) {
        super(x1, y1, z1, x2, y2, z2);
    }

    public CreativeAABB(BlockPos pos) {
        super(pos);
    }

    public CreativeAABB(BlockPos pos1, BlockPos pos2) {
        super(pos1, pos2);
    }

    public boolean contains(Vec3d vec) {
        if (vec.x > this.f_82288_ && vec.x < this.f_82291_) {
            if (vec.y > this.f_82289_ && vec.y < this.f_82292_) {
                return vec.z > this.f_82290_ && vec.z < this.f_82293_;
            }
            return false;
        }
        return false;
    }

    protected double get(Facing facing) {
        switch (facing) {
            case EAST: {
                return this.f_82291_;
            }
            case WEST: {
                return this.f_82288_;
            }
            case UP: {
                return this.f_82292_;
            }
            case DOWN: {
                return this.f_82289_;
            }
            case SOUTH: {
                return this.f_82293_;
            }
            case NORTH: {
                return this.f_82290_;
            }
        }
        return 0.0;
    }

    public Vec3d getCorner(BoxCorner corner) {
        return new Vec3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public double getCornerValue(BoxCorner corner, Axis axis) {
        return this.get(corner.getFacing(axis));
    }

    public double getCornerX(BoxCorner corner) {
        return this.get(corner.x);
    }

    public double getCornerY(BoxCorner corner) {
        return this.get(corner.y);
    }

    public double getCornerZ(BoxCorner corner) {
        return this.get(corner.z);
    }

    public Vec3d getSizeVec() {
        return new Vec3d(this.f_82291_ - this.f_82288_, this.f_82292_ - this.f_82289_, this.f_82293_ - this.f_82290_);
    }

    public double getVolume() {
        return (this.f_82291_ - this.f_82288_) * (this.f_82292_ - this.f_82289_) * (this.f_82293_ - this.f_82290_);
    }

    public double getIntersectionVolume(AABB other) {
        double d0 = Math.max(this.f_82288_, other.f_82288_);
        double d1 = Math.max(this.f_82289_, other.f_82289_);
        double d2 = Math.max(this.f_82290_, other.f_82290_);
        double d3 = Math.min(this.f_82291_, other.f_82291_);
        double d4 = Math.min(this.f_82292_, other.f_82292_);
        double d5 = Math.min(this.f_82293_, other.f_82293_);
        if (d0 < d3 && d1 < d4 && d2 < d5) {
            return Math.abs((d3 - d0) * (d4 - d1) * (d5 - d2));
        }
        return 0.0;
    }

    public double getSize(Axis axis) {
        switch (axis) {
            case X: {
                return this.f_82291_ - this.f_82288_;
            }
            case Y: {
                return this.f_82292_ - this.f_82289_;
            }
            case Z: {
                return this.f_82293_ - this.f_82290_;
            }
        }
        return 0.0;
    }

    public double getMin(Axis axis) {
        switch (axis) {
            case X: {
                return this.f_82288_;
            }
            case Y: {
                return this.f_82289_;
            }
            case Z: {
                return this.f_82290_;
            }
        }
        return 0.0;
    }

    public double getMax(Axis axis) {
        switch (axis) {
            case X: {
                return this.f_82291_;
            }
            case Y: {
                return this.f_82292_;
            }
            case Z: {
                return this.f_82293_;
            }
        }
        return 0.0;
    }

    public static double get(AABB bb, Facing facing) {
        switch (facing) {
            case EAST: {
                return bb.f_82291_;
            }
            case WEST: {
                return bb.f_82288_;
            }
            case UP: {
                return bb.f_82292_;
            }
            case DOWN: {
                return bb.f_82289_;
            }
            case SOUTH: {
                return bb.f_82293_;
            }
            case NORTH: {
                return bb.f_82290_;
            }
        }
        return 0.0;
    }

    public static double getMin(AABB bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.f_82288_;
            }
            case Y: {
                return bb.f_82289_;
            }
            case Z: {
                return bb.f_82290_;
            }
        }
        return 0.0;
    }

    public static double getMax(AABB bb, Axis axis) {
        switch (axis) {
            case X: {
                return bb.f_82291_;
            }
            case Y: {
                return bb.f_82292_;
            }
            case Z: {
                return bb.f_82293_;
            }
        }
        return 0.0;
    }

    public static Vec3d getCorner(AABB bb, BoxCorner corner) {
        return new Vec3d(CreativeAABB.getCornerX(bb, corner), CreativeAABB.getCornerY(bb, corner), CreativeAABB.getCornerZ(bb, corner));
    }

    public static double getCornerValue(AABB bb, BoxCorner corner, Axis axis) {
        return CreativeAABB.get(bb, corner.getFacing(axis));
    }

    public static double getCornerX(AABB bb, BoxCorner corner) {
        return CreativeAABB.get(bb, corner.x);
    }

    public static double getCornerY(AABB bb, BoxCorner corner) {
        return CreativeAABB.get(bb, corner.y);
    }

    public static double getCornerZ(AABB bb, BoxCorner corner) {
        return CreativeAABB.get(bb, corner.z);
    }
}

