/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3d;
import net.minecraft.core.Vec3i;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.ColorType;

public class Color {
    public static final Color WHITE = new Color(-1);
    public static final Color RED = new Color(-65536);
    public static final Color GREEN = new Color(-16711936);
    public static final Color BLUE = new Color(-16776961);
    public static final Color LIGHT_BLUE = new Color(-16740609);
    public static final Color ORANGE = new Color(-23296);
    public static final Color YELLOW = new Color(-256);
    public static final Color CYAN = new Color(0xFF0001);
    public static final Color MAGENTA = new Color(-65281);
    public static final Color BLACK = new Color(-16777216);
    protected byte red;
    protected byte green;
    protected byte blue;
    protected byte alpha;

    public Color() {
        this(-1, -1, -1, -1);
    }

    public Color(Color color) {
        this.set(color);
    }

    public Color(int color) {
        this.alpha = (byte)(color >> 24 & 0xFF);
        this.red = (byte)(color >> 16 & 0xFF);
        this.green = (byte)(color >> 8 & 0xFF);
        this.blue = (byte)(color & 0xFF);
    }

    public Color(float r, float g, float b) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), 255);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(byte r, byte g, byte b) {
        this(r, g, b, -1);
    }

    public Color(float r, float g, float b, float a) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public Color(int r, int g, int b, int a) {
        this.red = (byte)r;
        this.green = (byte)g;
        this.blue = (byte)b;
        this.alpha = (byte)a;
    }

    public Color(byte r, byte g, byte b, byte a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    public Color(Vec3i vec) {
        this.red = (byte)vec.m_123341_();
        this.green = (byte)vec.m_123342_();
        this.blue = (byte)vec.m_123343_();
        this.alpha = (byte)-1;
    }

    public Color(Vector3d vec) {
        this.red = (byte)(vec.f_86214_ * 255.0);
        this.green = (byte)(vec.f_86215_ * 255.0);
        this.blue = (byte)(vec.f_86216_ * 255.0);
        this.alpha = (byte)-1;
    }

    public void set(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.alpha = color.getAlpha();
    }

    public void set(ColorType type, int value) {
        this.set(type, (byte)value);
    }

    public void set(ColorType type, byte value) {
        switch (type) {
            case ALPHA: {
                this.alpha = value;
                break;
            }
            case RED: {
                this.red = value;
                break;
            }
            case GREEN: {
                this.green = value;
                break;
            }
            case BLUE: {
                this.blue = value;
            }
        }
    }

    public void setAlpha(int a) {
        this.alpha = (byte)a;
    }

    public void setAlpha(byte a) {
        this.alpha = a;
    }

    public void setRed(int r) {
        this.red = (byte)r;
    }

    public void setRed(byte r) {
        this.red = r;
    }

    public void setGreen(int g) {
        this.green = (byte)g;
    }

    public void setGreen(byte g) {
        this.green = g;
    }

    public void setBlue(int b) {
        this.blue = (byte)b;
    }

    public void setBlue(byte b) {
        this.blue = b;
    }

    public byte get(ColorType type) {
        switch (type) {
            case ALPHA: {
                return this.alpha;
            }
            case RED: {
                return this.red;
            }
            case GREEN: {
                return this.green;
            }
            case BLUE: {
                return this.blue;
            }
        }
        return 0;
    }

    public byte getAlpha() {
        return this.alpha;
    }

    public byte getRed() {
        return this.red;
    }

    public byte getGreen() {
        return this.green;
    }

    public byte getBlue() {
        return this.blue;
    }

    public float getDecimal(ColorType type) {
        switch (type) {
            case ALPHA: {
                return (float)this.alpha / 255.0f;
            }
            case RED: {
                return (float)this.red / 255.0f;
            }
            case GREEN: {
                return (float)this.green / 255.0f;
            }
            case BLUE: {
                return (float)this.blue / 255.0f;
            }
        }
        return 0.0f;
    }

    public float getAlphaDecimal() {
        return (float)this.alpha / 255.0f;
    }

    public float getRedDecimal() {
        return (float)this.red / 255.0f;
    }

    public float getGreenDecimal() {
        return (float)this.green / 255.0f;
    }

    public float getBlueDecimal() {
        return (float)this.blue / 255.0f;
    }

    public int toInt() {
        return (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public boolean isDefault() {
        return this.red == 255 && this.green == 255 && this.blue == 255 && this.alpha == 255;
    }

    public boolean isWhite() {
        return this.red == 255 && this.green == 255 && this.blue == 255;
    }

    public boolean isTransparent() {
        return this.alpha < 255;
    }

    public boolean isInvisible() {
        return this.alpha == 0;
    }

    public void blend(Color color) {
        this.blend(color, 0.5f);
    }

    public void blend(Color color, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        this.alpha = (byte)((float)this.alpha * iRatio + (float)color.alpha * ratio);
        this.red = (byte)((float)this.red * iRatio + (float)color.red * ratio);
        this.green = (byte)((float)this.green * iRatio + (float)color.green * ratio);
        this.blue = (byte)((float)this.blue * iRatio + (float)color.blue * ratio);
    }

    public void glColor() {
        RenderSystem.m_157429_((float)((float)this.red / 255.0f), (float)((float)this.green / 255.0f), (float)((float)this.blue / 255.0f), (float)((float)this.alpha / 255.0f));
    }

    public Vector3d toVec(ColorUtils.ColorPart part) {
        return new Vector3d((double)this.red / 255.0, (double)this.green / 255.0, (double)this.blue / 255.0);
    }

    public static boolean isWhite(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r == 255 && g == 255 && b == 255;
    }

    public static boolean isTransparent(int color) {
        int a = color >> 24 & 0xFF;
        return a < 255;
    }

    public static boolean isInvisible(int color) {
        int a = color >> 24 & 0xFF;
        return a == 0;
    }

    public static Color blend(Color color1, Color color2) {
        return Color.blend(color1, color2, 0.5f);
    }

    public static Color blend(Color color1, Color color2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        byte a = (byte)((float)color1.alpha * iRatio + (float)color2.alpha * ratio);
        byte r = (byte)((float)color1.red * iRatio + (float)color2.red * ratio);
        byte g = (byte)((float)color1.green * iRatio + (float)color2.green * ratio);
        byte b = (byte)((float)color1.blue * iRatio + (float)color2.blue * ratio);
        return new Color(r, g, b, a);
    }

    public static int blend(int i1, int i2) {
        return Color.blend(i1, i2, 0.5f);
    }

    public static int blend(int i1, int i2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

