/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.RenderHelper;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookIcon {
    private static final BookIcon EMPTY = new BookIcon(ItemStack.f_41583_);
    private final IconType type;
    private final ItemStack stack;
    private final ResourceLocation res;

    public static BookIcon from(String str) {
        if (str.endsWith(".png")) {
            return new BookIcon(new ResourceLocation(str));
        }
        try {
            ItemStack stack = ItemStackUtil.loadStackFromString(str);
            return new BookIcon(stack);
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.warn("Invalid icon item stack: {}", (Object)e.getMessage());
            return EMPTY;
        }
    }

    public BookIcon(ItemStack stack) {
        this.type = IconType.STACK;
        this.stack = stack;
        this.res = null;
    }

    public BookIcon(ResourceLocation res) {
        this.type = IconType.RESOURCE;
        this.stack = null;
        this.res = res;
    }

    public void render(PoseStack ms, int x, int y) {
        switch (this.type) {
            case STACK: {
                RenderHelper.renderItemStackInGui(ms, this.stack, x, y);
                break;
            }
            case RESOURCE: {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.res);
                GuiComponent.m_93133_((PoseStack)ms, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }
    }

    private static enum IconType {
        STACK,
        RESOURCE;

    }
}

