/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.TriPredicate;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.xplat.IXplatAbstractions;

public class StringStateMatcher {
    public static IStateMatcher fromString(String s) throws CommandSyntaxException {
        if ((s = s.trim()).equals("ANY")) {
            return StateMatcher.ANY;
        }
        if (s.equals("AIR")) {
            return StateMatcher.AIR;
        }
        BlockStateParser parser = new BlockStateParser(new StringReader(s), true).m_116806_(false);
        BlockState state = parser.m_116808_();
        if (state != null) {
            return new ExactMatcher(state, parser.m_116764_());
        }
        Tag.Named<Block> tag = IXplatAbstractions.INSTANCE.blockTag(parser.m_116822_());
        return new TagMatcher(tag, parser.m_116846_());
    }

    private static class ExactMatcher
    implements IStateMatcher {
        private final BlockState state;
        private final Map<Property<?>, Comparable<?>> props;

        private ExactMatcher(BlockState state, Map<Property<?>, Comparable<?>> props) {
            this.state = state;
            this.props = props;
        }

        @Override
        public BlockState getDisplayedState(int ticks) {
            return this.state;
        }

        @Override
        public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> this.state.m_60734_() == s.m_60734_() && this.checkProps((BlockState)s);
        }

        private boolean checkProps(BlockState state) {
            for (Map.Entry<Property<?>, Comparable<?>> e : this.props.entrySet()) {
                if (state.m_61143_(e.getKey()).equals(e.getValue())) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExactMatcher that = (ExactMatcher)o;
            return Objects.equals(this.state, that.state) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.props);
        }
    }

    private static class TagMatcher
    implements IStateMatcher {
        private final Tag.Named<Block> tag;
        private final Map<String, String> props;

        private TagMatcher(Tag.Named<Block> tag, Map<String, String> props) {
            this.tag = tag;
            this.props = props;
        }

        @Override
        public BlockState getDisplayedState(int ticks) {
            ArrayList all = new ArrayList(this.tag.m_6497_());
            if (all.isEmpty()) {
                return Blocks.f_50752_.m_49966_();
            }
            int idx = ticks / 20 % all.size();
            return ((Block)all.get(idx)).m_49966_();
        }

        @Override
        public TriPredicate<BlockGetter, BlockPos, BlockState> getStatePredicate() {
            return (w, p, s) -> this.tag.m_8110_((Object)s.m_60734_()) && this.checkProps((BlockState)s);
        }

        private boolean checkProps(BlockState state) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                Property prop = state.m_60734_().m_49965_().m_61081_(entry.getKey());
                if (prop == null) {
                    return false;
                }
                Comparable value = prop.m_6215_(entry.getValue()).orElse(null);
                if (value == null) {
                    return false;
                }
                if (state.m_61143_(prop).equals(value)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagMatcher that = (TagMatcher)o;
            return Objects.equals(this.tag.m_6979_(), that.tag.m_6979_()) && Objects.equals(this.props, that.props);
        }

        public int hashCode() {
            return Objects.hash(this.tag.m_6979_(), this.props);
        }
    }
}

