/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiouselytra.common;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CurioElytra
implements ICurio {
    public static final AttributeModifier ELYTRA_CURIO_MODIFIER = new AttributeModifier(UUID.fromString("c754faef-9926-4a77-abbe-e34ef0d735aa"), "Elytra curio modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private final ItemStack stack;

    public CurioElytra(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void curioTick(SlotContext slotContext) {
        LivingEntity livingEntity = slotContext.entity();
        int ticks = livingEntity.m_21256_();
        if (ticks > 0 && livingEntity.m_21255_()) {
            this.stack.elytraFlightTick(livingEntity, ticks);
        }
    }

    public boolean canEquip(SlotContext slotContext) {
        LivingEntity livingEntity = slotContext.entity();
        ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
        return !(livingEntity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem) && curiosHelper.findEquippedCurio(stack -> curiosHelper.getCurio(stack).map(curio -> curio instanceof CurioElytra).orElse(false), livingEntity).isEmpty();
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }
}

