/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.network;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannel {
    private final SimpleChannel channel;
    private int index = 0;
    private final HashMap<Class<? extends BasePacket>, Integer> packet_to_index = new HashMap();
    private final IntObjectHashMap<Supplier<? extends BasePacket>> index_to_packet = new IntObjectHashMap();
    private final HashMap<Class<? extends BasePacket>, Boolean> packet_to_queued = new HashMap();

    public static PacketChannel create(String modid, String registryName) {
        if (modid == null || modid.isEmpty()) {
            throw new IllegalArgumentException("Modid must not be null!");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Registry name must not be null!");
        }
        return new PacketChannel(modid, registryName);
    }

    public static PacketChannel create(String modid) {
        return PacketChannel.create(modid, "main");
    }

    @Deprecated
    public static PacketChannel create() {
        return PacketChannel.create(ModLoadingContext.get().getActiveNamespace(), "main");
    }

    private PacketChannel(String modid, String name) {
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(modid, name), () -> "1", "1"::equals, "1"::equals);
        this.channel.registerMessage(0, InternalPacket.class, (message, buffer) -> InternalPacket.write(this, message, buffer), buffer -> InternalPacket.read(this, buffer), (message, context) -> InternalPacket.handle(this, message, context));
    }

    public <T extends BasePacket> void registerMessage(Class<T> packetClass, Supplier<T> packetSupplier, boolean shouldBeQueued) {
        if (this.packet_to_index.containsKey(packetClass)) {
            throw new IllegalArgumentException("Class '" + packetClass + "' has already been registered!");
        }
        int index = this.index++;
        this.packet_to_index.put(packetClass, index);
        this.index_to_packet.put(index, packetSupplier);
        this.packet_to_queued.put(packetClass, shouldBeQueued);
    }

    public void sendToServer(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.sendToServer((Object)new InternalPacket().setPacket(packet));
    }

    public void sendToPlayer(Player player, BasePacket packet) {
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToAllPlayers(BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.ALL.noArg(), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToDimension(ResourceKey<Level> dimension, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToDimension(Level world, BasePacket packet) {
        if (world.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToDimension((ResourceKey<Level>)world.m_46472_(), packet);
    }

    public void sendToAllTrackingEntity(Entity entity, BasePacket packet) {
        if (entity.f_19853_.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToAllNear(ResourceKey<Level> world, double x, double y, double z, double radius, BasePacket packet) {
        this.checkRegistration(packet);
        this.channel.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, radius, world)), (Object)new InternalPacket().setPacket(packet));
    }

    public void sendToAllNear(ResourceKey<Level> world, BlockPos pos, double radius, BasePacket packet) {
        this.sendToAllNear(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, radius, packet);
    }

    public void sendToAllNear(Level world, double x, double y, double z, double radius, BasePacket packet) {
        if (world.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((ResourceKey<Level>)world.m_46472_(), x, y, z, radius, packet);
    }

    public void sendToAllNear(Level world, BlockPos pos, double radius, BasePacket packet) {
        if (world.f_46443_) {
            throw new IllegalStateException("This must only be called server-side!");
        }
        this.sendToAllNear((ResourceKey<Level>)world.m_46472_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, radius, packet);
    }

    private void checkRegistration(BasePacket packet) {
        if (!this.packet_to_index.containsKey(packet.getClass())) {
            throw new IllegalArgumentException("Tried to send unregistered packet '" + packet.getClass() + "'!");
        }
    }

    private void write(BasePacket packet, FriendlyByteBuf buffer) {
        int index = this.packet_to_index.get(packet.getClass());
        buffer.writeInt(index);
        packet.write(buffer);
    }

    private BasePacket read(FriendlyByteBuf buffer) {
        int index = buffer.readInt();
        if (!this.index_to_packet.containsKey(index)) {
            throw new IllegalStateException("Received an unregistered packet with index '" + index + "'!");
        }
        BasePacket packet = (BasePacket)((Supplier)this.index_to_packet.get(index)).get();
        packet.read(buffer);
        return packet;
    }

    private void handle(BasePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().setPacketHandled(true);
        PacketContext context = new PacketContext(contextSupplier.get());
        if (packet.verify(context)) {
            if (this.packet_to_queued.get(packet.getClass()).booleanValue()) {
                context.queueTask(() -> packet.handle(context));
            } else {
                packet.handle(context);
            }
        }
    }

    private static class InternalPacket {
        private BasePacket packet;

        private InternalPacket() {
        }

        public static InternalPacket read(PacketChannel channel, FriendlyByteBuf buffer) {
            return new InternalPacket().setPacket(channel.read(buffer));
        }

        public static void write(PacketChannel channel, InternalPacket packet, FriendlyByteBuf buffer) {
            channel.write(packet.packet, buffer);
        }

        public static void handle(PacketChannel channel, InternalPacket packet, Supplier<NetworkEvent.Context> context) {
            channel.handle(packet.packet, context);
        }

        public InternalPacket setPacket(BasePacket packet) {
            this.packet = packet;
            return this;
        }
    }
}

