/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary;

import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientTextureStitchEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.ftb.mods.ftblibrary.FTBLibraryCommon;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ImageConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.AtlasSpriteIcon;
import dev.ftb.mods.ftblibrary.icon.IconPresets;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonManager;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class FTBLibraryClient
extends FTBLibraryCommon {
    public static int showButtons = 1;
    public CursorType lastCursorType = null;

    @Override
    public void init() {
        if (Platform.isModLoaded((String)"roughlyenoughitems")) {
            showButtons = 3;
        }
        if (Minecraft.m_91087_() == null) {
            return;
        }
        ClientTextureStitchEvent.PRE.register(this::textureStitch);
        ClientGuiEvent.INIT_POST.register(this::guiInit);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)SidebarButtonManager.INSTANCE);
    }

    private void textureStitch(TextureAtlas atlas, Consumer<ResourceLocation> addSprite) {
        if (!atlas.m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        try {
            for (Field field : Icons.class.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(null);
                if (!(o instanceof AtlasSpriteIcon)) continue;
                AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                addSprite.accept(a.id);
                IconPresets.MAP.put(a.id.toString(), a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void guiInit(Screen screen, ScreenAccess access) {
        if (FTBLibraryClient.areButtonsVisible(screen)) {
            SidebarGroupGuiButton group = new SidebarGroupGuiButton((AbstractContainerScreen)screen);
            access.addRenderableWidget((AbstractWidget)group);
        }
    }

    private void clientTick(Minecraft client) {
        CursorType t;
        CursorType cursorType = t = client.f_91080_ instanceof IScreenWrapper ? ((IScreenWrapper)client.f_91080_).getGui().getCursor() : null;
        if (this.lastCursorType != t) {
            this.lastCursorType = t;
            CursorType.set(t);
        }
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable Screen gui) {
        if (showButtons == 0 || showButtons == 2 && !(gui instanceof EffectRenderingInventoryScreen) || showButtons == 3) {
            return false;
        }
        return gui instanceof AbstractContainerScreen && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }

    @Override
    public void testScreen() {
        ConfigGroup group = new ConfigGroup("test");
        group.add("image", new ImageConfig(), "", v -> {}, "");
        group.addItemStack("item", ItemStack.f_41583_, v -> {}, ItemStack.f_41583_, false, true);
        new EditConfigScreen(group).openGuiLater();
    }
}

