/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import lilypuree.decorative_blocks.core.DBTags;
import lilypuree.decorative_blocks.fluid.ThatchFluid;
import net.minecraft.client.Camera;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FogHelper {
    public static Info onColorFog(Camera camera) {
        Level world;
        FluidState state;
        Fluid fluid;
        Entity entity = camera.m_90592_();
        if (entity.m_19941_(DBTags.Fluids.THATCH) && (fluid = (state = (world = entity.m_20193_()).m_6425_(entity.m_146901_())).m_76152_()) instanceof ThatchFluid) {
            ThatchFluid thatchFluid = (ThatchFluid)fluid;
            int color = thatchFluid.getReferenceHolder().getColor();
            float fogRed = (float)(color >> 16 & 0xFF) / 255.0f;
            float fogGreen = (float)(color >> 8 & 0xFF) / 255.0f;
            float fogBlue = (float)(color & 0xFF) / 255.0f;
            long biomeChangedTime = -1L;
            return new Info(fogRed, fogGreen, fogBlue, biomeChangedTime);
        }
        return null;
    }

    public static void onFogSetup(Camera camera, float farPlaneDist) {
        Entity entity = camera.m_90592_();
        if (entity.m_19941_(DBTags.Fluids.THATCH)) {
            float end;
            float start;
            if (entity.m_5833_()) {
                start = -8.0f;
                end = farPlaneDist * 0.5f;
            } else {
                start = 0.25f;
                end = 1.0f;
            }
            RenderSystem.m_157445_((float)start);
            RenderSystem.m_157443_((float)end);
        }
    }

    public record Info(float fogRed, float fogGreen, float fogBlue, long time) {
    }
}

