/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.init;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.yungsbridges.YungsBridges;
import com.yungnickyoung.minecraft.yungsbridges.config.YBConfig;
import java.util.ArrayList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class YBModConfig {
    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)YBConfig.SPEC, "yungsbridges-forge-1_18.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(YBModConfig::configChanged);
    }

    public static void configChanged(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == YBConfig.SPEC) {
            String rawStringList = (String)YBConfig.blacklistedBiomes.get();
            int strLen = rawStringList.length();
            if (strLen < 2 || rawStringList.charAt(0) != '[' || rawStringList.charAt(strLen - 1) != ']') {
                YungsBridges.LOGGER.error("INVALID VALUE FOR SETTING 'Blacklisted Biomes'. Using default instead...");
                YungsBridges.blacklistedBiomes = new ArrayList<String>();
                return;
            }
            YungsBridges.blacklistedBiomes = Lists.newArrayList((Object[])rawStringList.substring(1, strLen - 1).split(",\\s*"));
        }
    }
}

