/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsbridges.init;

import com.yungnickyoung.minecraft.yungsbridges.config.YBConfig;
import com.yungnickyoung.minecraft.yungsbridges.init.YBModFeatures;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.BridgeFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.feature.MultipleAttemptSingleRandomFeatureConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacement;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.BridgePlacementConfig;
import com.yungnickyoung.minecraft.yungsbridges.world.placement.RngInitializerPlacement;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class YBModConfiguredFeatures {
    private static final List<Supplier<PlacedFeature>> PLACED_BRIDGES = new ArrayList<Supplier<PlacedFeature>>();
    public static final ConfiguredFeature<?, ?> BRIDGE_LIST_FEATURE_CONFIGURED;
    public static final PlacedFeature BRIDGE_LIST_FEATURE_PLACED;

    public static void registerConfiguredFeatures() {
        YBModConfiguredFeatures.registerConfiguredFeature(BRIDGE_LIST_FEATURE_CONFIGURED, "bridge_list");
    }

    public static void registerPlacedFeatures() {
        YBModConfiguredFeatures.registerPlacedFeature(BRIDGE_LIST_FEATURE_PLACED, "bridge_list");
    }

    private static void registerConfiguredFeature(ConfiguredFeature<?, ?> feature, String id) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation("yungsbridges", id), feature);
    }

    private static void registerPlacedFeature(PlacedFeature feature, String id) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("yungsbridges", id), (Object)feature);
    }

    private static void addLargeBridge(String id, BridgePlacementConfig placementConfig) {
        YBModConfiguredFeatures.addBridge(id, placementConfig, (Integer)YBConfig.spawnRates.largeBridges.get());
    }

    private static void addMediumBridge(String id, BridgePlacementConfig placementConfig) {
        YBModConfiguredFeatures.addBridge(id, placementConfig, (Integer)YBConfig.spawnRates.mediumBridges.get());
    }

    private static void addSmallBridge(String id, BridgePlacementConfig placementConfig) {
        YBModConfiguredFeatures.addBridge(id, placementConfig, (Integer)YBConfig.spawnRates.smallBridges.get());
    }

    private static void addBridge(String id, BridgePlacementConfig placementConfig, int chance) {
        BridgeFeatureConfig featureConfig = new BridgeFeatureConfig(id);
        ConfiguredFeature configuredFeature = ((Feature)YBModFeatures.BRIDGE.get()).m_65815_((FeatureConfiguration)featureConfig);
        PlacedFeature placedFeature = configuredFeature.m_190823_(new PlacementModifier[]{BridgePlacement.of(placementConfig), RarityFilter.m_191900_((int)chance), RngInitializerPlacement.randomized()});
        ConfiguredFeature rotatedConfiguredFeature = ((Feature)YBModFeatures.BRIDGE.get()).m_65815_((FeatureConfiguration)featureConfig.rotatedCopy());
        PlacedFeature placedRotatedFeature = rotatedConfiguredFeature.m_190823_(new PlacementModifier[]{BridgePlacement.of(placementConfig.rotatedCopy()), RarityFilter.m_191900_((int)chance), RngInitializerPlacement.randomized()});
        PLACED_BRIDGES.add(() -> placedFeature);
        PLACED_BRIDGES.add(() -> placedRotatedFeature);
    }

    static {
        YBModConfiguredFeatures.addLargeBridge("bridge/stone/31_0", new BridgePlacementConfig(31, 5, 4, 28).widthOffset(2).solidBlocks(3));
        YBModConfiguredFeatures.addLargeBridge("bridge/wood/27_0", new BridgePlacementConfig(27, 5, 2, 26).solidBlocks(2));
        YBModConfiguredFeatures.addMediumBridge("bridge/stone/24_0", new BridgePlacementConfig(24, 5, 2, 23).solidBlocks(2));
        YBModConfiguredFeatures.addMediumBridge("bridge/stone/24_0_broken", new BridgePlacementConfig(24, 5, 2, 23).solidBlocks(2));
        YBModConfiguredFeatures.addMediumBridge("bridge/stone/22_0", new BridgePlacementConfig(22, 5, 2, 21).solidBlocks(2));
        YBModConfiguredFeatures.addMediumBridge("bridge/stone/22_0_broken", new BridgePlacementConfig(22, 5, 2, 21).solidBlocks(2));
        YBModConfiguredFeatures.addSmallBridge("bridge/wood/17_0", new BridgePlacementConfig(17, 4, 2, 16).solidBlocks(2));
        YBModConfiguredFeatures.addSmallBridge("bridge/wood/17_0_broken", new BridgePlacementConfig(17, 4, 2, 16).solidBlocks(2));
        YBModConfiguredFeatures.addSmallBridge("bridge/stone/16_0", new BridgePlacementConfig(16, 5, 2, 15).solidBlocks(2));
        YBModConfiguredFeatures.addSmallBridge("bridge/stone/16_0_broken", new BridgePlacementConfig(16, 5, 2, 15).solidBlocks(2));
        YBModConfiguredFeatures.addSmallBridge("bridge/stone/15_1", new BridgePlacementConfig(15, 5, 2, 14).widthOffset(1).solidBlocks(2));
        BRIDGE_LIST_FEATURE_CONFIGURED = ((Feature)YBModFeatures.MULTIPLE_ATTEMPT_SINGLE_RANDOM.get()).m_65815_((FeatureConfiguration)new MultipleAttemptSingleRandomFeatureConfig(PLACED_BRIDGES));
        BRIDGE_LIST_FEATURE_PLACED = BRIDGE_LIST_FEATURE_CONFIGURED.m_190823_(new PlacementModifier[]{BiomeFilter.m_191561_()});
    }
}

