/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.CompareBlockFunctions;
import com.natamus.collective.functions.ToolFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import com.natamus.treeharvester.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TreeEvent {
    private static HashMap<Level, CopyOnWriteArrayList<List<BlockPos>>> processleaves = new HashMap();

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        Level world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getWorld());
        if (world == null) {
            return;
        }
        processleaves.put(world, new CopyOnWriteArrayList());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        Level world = e.world;
        if (world.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (processleaves.get(world).size() == 0) {
            return;
        }
        block0: for (List<BlockPos> leaves : processleaves.get(world)) {
            BlockPos lasttr = null;
            int size = leaves.size();
            if (size > 0) {
                BlockPos tr = leaves.get(0);
                BlockFunctions.dropBlock((Level)world, (BlockPos)tr);
                leaves.remove(0);
                if (leaves.size() > 0) {
                    tr = leaves.get(0);
                    BlockFunctions.dropBlock((Level)world, (BlockPos)tr);
                    leaves.remove(0);
                }
                lasttr = tr.m_7949_();
            }
            if (leaves.size() != 0) continue;
            processleaves.get(world).remove(leaves);
            if (lasttr == null || !((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue() || Util.lowerlogs.size() <= 0) continue;
            BlockPos lowerlasttrpos = new BlockPos(lasttr.m_123341_(), 1, lasttr.m_123343_());
            for (Pair<BlockPos, CopyOnWriteArrayList<BlockPos>> pair : Util.lowerlogs) {
                BlockPos breakpos = (BlockPos)pair.getFirst();
                if (!BlockPosFunctions.withinDistance((BlockPos)lowerlasttrpos, (BlockPos)new BlockPos(breakpos.m_123341_(), 1, breakpos.m_123343_()), (int)5).booleanValue()) continue;
                Util.replaceSapling(world, breakpos, (CopyOnWriteArrayList)pair.getSecond(), 1);
                Util.lowerlogs.remove(pair);
                continue block0;
            }
        }
    }

    @SubscribeEvent
    public void onTreeHarvest(BlockEvent.BreakEvent e) {
        int logcount;
        Level world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getWorld());
        if (world == null) {
            return;
        }
        BlockPos bpos = e.getPos();
        Block block = world.m_8055_(bpos).m_60734_();
        if (!CompareBlockFunctions.isTreeLog((Block)block)) {
            return;
        }
        Player player = e.getPlayer();
        if ((Boolean)ConfigHandler.GENERAL.treeHarvestWithoutSneak.get() != false ? player.m_6144_() : !player.m_6144_()) {
            return;
        }
        ItemStack hand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (((Boolean)ConfigHandler.GENERAL.mustHoldAxeForTreeHarvest.get()).booleanValue() && !ToolFunctions.isAxe((ItemStack)hand).booleanValue()) {
            return;
        }
        if (hand == null) {
            return;
        }
        if (((Boolean)ConfigHandler.GENERAL.automaticallyFindBottomBlock.get()).booleanValue()) {
            BlockPos temppos = bpos.m_7949_();
            while (world.m_8055_(temppos.m_7495_()).m_60734_().equals(block)) {
                temppos = temppos.m_7495_().m_7949_();
            }
            bpos = temppos.m_7949_();
        }
        if ((logcount = Util.isTreeAndReturnLogAmount(world, bpos)) < 0) {
            return;
        }
        Item handitem = hand.m_41720_();
        int durabilitylosecount = (int)Math.ceil(1.0 / (Double)ConfigHandler.GENERAL.loseDurabilityModifier.get());
        int durabilitystartcount = -1;
        List<BlockPos> logstobreak = Util.getAllLogsToBreak(world, bpos, logcount, block);
        for (BlockPos logpos : logstobreak) {
            BlockState logstate = world.m_8055_(logpos);
            Block log = logstate.m_60734_();
            if (!log.canHarvestBlock(logstate, (BlockGetter)world, logpos, player)) continue;
            world.m_46961_(logpos, false);
            log.m_6240_(world, player, logpos, logstate, null, hand);
            if (player.m_7500_()) continue;
            if (((Boolean)ConfigHandler.GENERAL.loseDurabilityPerHarvestedLog.get()).booleanValue()) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    handitem.m_6813_(hand, world, logstate, logpos, (LivingEntity)player);
                } else if (--durabilitylosecount == 0) {
                    handitem.m_6813_(hand, world, logstate, logpos, (LivingEntity)player);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!((Boolean)ConfigHandler.GENERAL.increaseExhaustionPerHarvestedLog.get()).booleanValue()) continue;
            player.m_36399_(0.025f * ((Double)ConfigHandler.GENERAL.increaseExhaustionModifier.get()).floatValue());
        }
        if (logstobreak.size() == 0) {
            return;
        }
        e.setCanceled(true);
        if (((Boolean)ConfigHandler.GENERAL.enableFastLeafDecay.get()).booleanValue() && !((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) {
            ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
            ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
            for (BlockPos next : BlockPos.m_121976_((int)(bpos.m_123341_() - 8), (int)bpos.m_123342_(), (int)(bpos.m_123343_() - 8), (int)(bpos.m_123341_() + 8), (int)Util.highestleaf.get(bpos), (int)(bpos.m_123343_() + 8))) {
                if (!CompareBlockFunctions.isTreeLog((Block)world.m_8055_(next).m_60734_())) continue;
                logs.add(next.m_7949_());
            }
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(logcount);
            int h = (Integer)hv.getFirst();
            for (BlockPos next : BlockPos.m_121976_((int)(bpos.m_123341_() - h), (int)bpos.m_123342_(), (int)(bpos.m_123343_() - h), (int)(bpos.m_123341_() + h), (int)Util.highestleaf.get(bpos), (int)(bpos.m_123343_() + h))) {
                if (!CompareBlockFunctions.isTreeLeaf((Block)world.m_8055_(next).m_60734_(), (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get()))) continue;
                boolean logclose = false;
                for (BlockPos log : logs) {
                    double distance = log.m_123331_((Vec3i)next);
                    if (!(distance < 7.0)) continue;
                    logclose = true;
                    break;
                }
                if (logclose) continue;
                leaves.add(next.m_7949_());
            }
            Collections.shuffle(leaves);
            processleaves.get(world).add(leaves);
            Util.highestleaf.remove(bpos);
        }
    }
}

