/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective.functions.CompareBlockFunctions;
import com.natamus.collective.functions.CompareItemFunctions;
import com.natamus.treeharvester.config.ConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class Util {
    public static HashMap<BlockPos, Integer> highestleaf = new HashMap();
    public static CopyOnWriteArrayList<Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>> lowerlogs = new CopyOnWriteArrayList();

    public static int isTreeAndReturnLogAmount(Level world, BlockPos pos) {
        highestleaf.put(pos, 0);
        int leafcount = 10;
        int logcount = 0;
        int prevleafcount = -1;
        int prevlogcount = -1;
        int highesty = 0;
        for (int y = 1; y <= 30 && (prevleafcount != leafcount || prevlogcount != logcount); ++y) {
            prevleafcount = leafcount;
            prevlogcount = logcount;
            Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() - 2), (int)(pos.m_123341_() + 2), (int)(pos.m_123342_() + (y - 1)), (int)(pos.m_123343_() + 2)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block nblock = world.m_8055_(npos).m_60734_();
                if (CompareBlockFunctions.isTreeLeaf((Block)nblock, (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get()))) {
                    --leafcount;
                    if (npos.m_123342_() <= highesty) continue;
                    highesty = npos.m_123342_();
                    continue;
                }
                if (!CompareBlockFunctions.isTreeLog((Block)nblock)) continue;
                ++logcount;
            }
        }
        highestleaf.put(pos.m_7949_(), highesty);
        if (leafcount < 0) {
            return logcount;
        }
        return -1;
    }

    public static List<BlockPos> getAllLogsToBreak(Level world, BlockPos pos, int logcount, Block logtype) {
        Block blockbelow;
        CopyOnWriteArrayList<BlockPos> bottomlogs = new CopyOnWriteArrayList<BlockPos>();
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue() && CompareBlockFunctions.isDirtBlock((Block)(blockbelow = world.m_8055_(pos.m_7495_()).m_60734_()))) {
            Iterator it = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)pos.m_123342_(), (int)(pos.m_123343_() + 1)).iterator();
            while (it.hasNext()) {
                BlockPos npos = (BlockPos)it.next();
                Block block = world.m_8055_(npos).m_60734_();
                if (!block.equals(logtype)) continue;
                bottomlogs.add(npos.m_7949_());
            }
        }
        if (((Boolean)ConfigHandler.GENERAL.replaceSaplingIfBottomLogIsBroken.get()).booleanValue()) {
            if (((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) {
                Util.replaceSapling(world, pos, bottomlogs, 1);
            } else if (((Boolean)ConfigHandler.GENERAL.enableFastLeafDecay.get()).booleanValue()) {
                lowerlogs.add((Pair<BlockPos, CopyOnWriteArrayList<BlockPos>>)new Pair((Object)pos.m_7949_(), bottomlogs));
            }
        }
        return Util.getLogsToBreak(world, pos, new ArrayList<BlockPos>(), logcount, logtype);
    }

    public static void replaceSapling(Level world, BlockPos pos, CopyOnWriteArrayList<BlockPos> bottomlogs, int radius) {
        int reducecount;
        int rc = reducecount = bottomlogs.size();
        ItemStack sapling = null;
        for (Entity ea : world.m_45933_(null, new AABB((double)(pos.m_123341_() - radius), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - radius), (double)(pos.m_123341_() + radius), (double)(pos.m_123342_() + 30), (double)(pos.m_123343_() + radius)))) {
            int count;
            ItemEntity eia;
            ItemStack eisa;
            if (!(ea instanceof ItemEntity) || !CompareItemFunctions.isSapling((ItemStack)(eisa = (eia = (ItemEntity)ea).m_32055_()))) continue;
            if (sapling == null) {
                sapling = eisa.m_41777_();
            }
            if ((count = eisa.m_41613_()) > 1) {
                for (int n = 0; n < count; ++n) {
                    eisa.m_41774_(1);
                    if (--rc == 0) break;
                }
                eia.m_32045_(eisa);
            } else {
                --rc;
                eia.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (rc != 0) continue;
            break;
        }
        int setsaplings = bottomlogs.size() - rc;
        for (BlockPos bottompos : bottomlogs) {
            if (setsaplings == 0) break;
            world.m_46597_(bottompos, Block.m_49814_((Item)sapling.m_41720_()).m_49966_());
            --setsaplings;
            bottomlogs.remove(bottompos);
        }
        if (bottomlogs.size() > 0) {
            if (radius >= 5) {
                return;
            }
            Util.replaceSapling(world, pos, bottomlogs, radius + 2);
        }
    }

    private static List<BlockPos> getLogsToBreak(Level world, BlockPos pos, List<BlockPos> logstobreak, int logcount, Block logtype) {
        ArrayList<Object> checkaround = new ArrayList<Object>();
        Iterator aroundlogs = BlockPos.m_121886_((int)(pos.m_123341_() - 1), (int)pos.m_123342_(), (int)(pos.m_123343_() - 1), (int)(pos.m_123341_() + 1), (int)(pos.m_123342_() + 1), (int)(pos.m_123343_() + 1)).iterator();
        while (aroundlogs.hasNext()) {
            BlockState blockState;
            Block logblock;
            BlockPos nalogpos = ((BlockPos)aroundlogs.next()).m_7949_();
            if (logstobreak.contains(nalogpos) || !(logblock = (blockState = world.m_8055_(nalogpos)).m_60734_()).equals(logtype)) continue;
            checkaround.add(nalogpos);
            logstobreak.add(nalogpos);
            Pair<Integer, Integer> hv = Util.getHorizontalAndVerticalValue(logcount);
            int h = (Integer)hv.getFirst();
            int v = (Integer)hv.getSecond();
            Iterator aroundleaves = BlockPos.m_121886_((int)(pos.m_123341_() - h), (int)pos.m_123342_(), (int)(pos.m_123343_() - h), (int)(pos.m_123341_() + h), (int)(pos.m_123342_() + v), (int)(pos.m_123343_() + h)).iterator();
            while (aroundleaves.hasNext()) {
                BlockPos naleafpos = (BlockPos)aroundleaves.next();
                Block leafblock = world.m_8055_(naleafpos).m_60734_();
                if (!CompareBlockFunctions.isTreeLeaf((Block)leafblock, (boolean)((Boolean)ConfigHandler.GENERAL.enableNetherTrees.get())) || !((Boolean)ConfigHandler.GENERAL.instantBreakLeavesAround.get()).booleanValue()) continue;
                world.m_46961_(naleafpos, true);
            }
        }
        if (checkaround.size() == 0) {
            return logstobreak;
        }
        for (BlockPos blockPos : checkaround) {
            for (BlockPos logpos : Util.getLogsToBreak(world, blockPos, logstobreak, logcount, logtype)) {
                if (logstobreak.contains(logpos)) continue;
                logstobreak.add(logpos.m_7949_());
            }
        }
        BlockPos up = pos.m_6630_(2);
        return Util.getLogsToBreak(world, up.m_7949_(), logstobreak, logcount, logtype);
    }

    public static Pair<Integer, Integer> getHorizontalAndVerticalValue(int logcount) {
        int h = 3;
        int v = 4;
        if (logcount >= 20) {
            h = 5;
            v = 5;
        } else if (logcount >= 10) {
            h = 4;
            v = 5;
        }
        return new Pair((Object)h, (Object)v);
    }
}

