/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.world.item;

import fuzs.easyshulkerboxes.world.inventory.SimpleContainerWithSlots;
import fuzs.easyshulkerboxes.world.inventory.tooltip.ContainerItemTooltip;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ContainerItemHelper {
    public static SimpleContainer loadItemContainer(@Nullable CompoundTag compoundtag, Supplier<CompoundTag> tagSupplier, int containerRows) {
        SimpleContainerWithSlots bagOfHoldingContainer = new SimpleContainerWithSlots(containerRows);
        if (compoundtag != null && compoundtag.m_128441_("Items")) {
            bagOfHoldingContainer.m_7797_(compoundtag.m_128437_("Items", 10));
        }
        bagOfHoldingContainer.m_19164_(container -> ContainerItemHelper.saveItemContainer((CompoundTag)tagSupplier.get(), (SimpleContainer)container));
        return bagOfHoldingContainer;
    }

    private static void saveItemContainer(CompoundTag compoundtag, SimpleContainer container) {
        ListTag tag = container.m_7927_();
        compoundtag.m_128365_("Items", (Tag)tag);
    }

    public static boolean overrideStackedOnOther(@Nullable CompoundTag compoundtag, Supplier<CompoundTag> tagSupplier, int containerRows, Slot slot, ClickAction clickAction, Player player, Predicate<ItemStack> itemFilter, SoundEvent insertSound, SoundEvent removeSound) {
        if (clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack hoveredStack = slot.m_7993_();
        if (hoveredStack.m_41619_()) {
            ContainerItemHelper.removeLastStack(compoundtag, tagSupplier, containerRows).ifPresent(stack -> {
                player.m_5496_(removeSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                ContainerItemHelper.addStack(compoundtag, tagSupplier, containerRows, slot.m_150659_(stack), itemFilter);
            });
        } else {
            hoveredStack = slot.m_150647_(hoveredStack.m_41613_(), hoveredStack.m_41613_(), player);
            int transferredCount = ContainerItemHelper.addStack(compoundtag, tagSupplier, containerRows, hoveredStack, itemFilter);
            hoveredStack.m_41774_(transferredCount);
            if (!hoveredStack.m_41619_()) {
                slot.m_150659_(hoveredStack);
            }
            if (transferredCount > 0) {
                player.m_5496_(insertSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
            }
        }
        return true;
    }

    public static boolean overrideOtherStackedOnMe(@Nullable CompoundTag compoundtag, Supplier<CompoundTag> tagSupplier, int containerRows, ItemStack stackOnMe, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess, Predicate<ItemStack> itemFilter, SoundEvent insertSound, SoundEvent removeSound) {
        if (clickAction != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (stackOnMe.m_41619_()) {
            ContainerItemHelper.removeLastStack(compoundtag, tagSupplier, containerRows).ifPresent(p_186347_ -> {
                player.m_5496_(removeSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                slotAccess.m_142104_(p_186347_);
            });
        } else {
            int transferredCount = ContainerItemHelper.addStack(compoundtag, tagSupplier, containerRows, stackOnMe, itemFilter);
            if (transferredCount > 0) {
                player.m_5496_(insertSound, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                stackOnMe.m_41774_(transferredCount);
            }
        }
        return true;
    }

    private static int addStack(@Nullable CompoundTag compoundtag, Supplier<CompoundTag> tagSupplier, int containerRows, ItemStack newStack, Predicate<ItemStack> itemFilter) {
        if (newStack.m_41619_() || !itemFilter.test(newStack)) {
            return 0;
        }
        SimpleContainer container = ContainerItemHelper.loadItemContainer(compoundtag, tagSupplier, containerRows);
        ItemStack remainingStack = container.m_19173_(newStack);
        return newStack.m_41613_() - remainingStack.m_41613_();
    }

    private static Optional<ItemStack> removeLastStack(@Nullable CompoundTag compoundtag, Supplier<CompoundTag> tagSupplier, int containerRows) {
        SimpleContainer container = ContainerItemHelper.loadItemContainer(compoundtag, tagSupplier, containerRows);
        for (int i = container.m_6643_() - 1; i >= 0; --i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            return Optional.of(container.m_7407_(i, stack.m_41613_()));
        }
        return Optional.empty();
    }

    public static Optional<TooltipComponent> getTooltipImage(@Nullable CompoundTag compoundtag, Supplier<CompoundTag> tagSupplier, int containerRows, @Nullable DyeColor backgroundColor) {
        if (compoundtag == null || !compoundtag.m_128441_("Items")) {
            return Optional.empty();
        }
        NonNullList items = NonNullList.m_122779_();
        SimpleContainer container = ContainerItemHelper.loadItemContainer(compoundtag, tagSupplier, containerRows);
        for (int i = 0; i < container.m_6643_(); ++i) {
            items.add((Object)container.m_8020_(i));
        }
        return Optional.of(new ContainerItemTooltip((NonNullList<ItemStack>)items, containerRows, backgroundColor));
    }
}

