/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.anthonyhilyard.advancementplaques.AdvancementPlaque;
import com.anthonyhilyard.advancementplaques.AdvancementPlaquesConfig;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementPlaquesToastGui
extends ToastComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AdvancementPlaque[] plaques = new AdvancementPlaque[1];
    private final Deque<AdvancementToast> advancementToastsQueue = Queues.newArrayDeque();
    private final Minecraft mc;
    private final CustomItemRenderer itemRenderer;

    public AdvancementPlaquesToastGui(Minecraft mcIn) {
        super(mcIn);
        this.mc = mcIn;
        this.itemRenderer = new CustomItemRenderer(this.mc.m_91097_(), this.mc.m_91304_(), this.mc.getItemColors(), this.mc.m_91291_().getBlockEntityRenderer(), this.mc);
    }

    public void m_94922_(Toast toastIn) {
        if (toastIn instanceof AdvancementToast) {
            AdvancementToast advancementToast = (AdvancementToast)toastIn;
            DisplayInfo displayInfo = advancementToast.f_94795_.m_138320_();
            if (displayInfo.m_14992_() == FrameType.TASK && (Boolean)AdvancementPlaquesConfig.INSTANCE.tasks.get() != false || displayInfo.m_14992_() == FrameType.GOAL && (Boolean)AdvancementPlaquesConfig.INSTANCE.goals.get() != false || displayInfo.m_14992_() == FrameType.CHALLENGE && (Boolean)AdvancementPlaquesConfig.INSTANCE.challenges.get() != false || ((List)AdvancementPlaquesConfig.INSTANCE.whitelist.get()).contains(advancementToast.f_94795_.m_138327_().toString())) {
                this.advancementToastsQueue.add((AdvancementToast)toastIn);
                return;
            }
        }
        super.m_94922_(toastIn);
    }

    public void m_94920_(PoseStack stack) {
        if (!this.mc.f_91066_.f_92062_) {
            super.m_94920_(stack);
            try {
                if (((Boolean)AdvancementPlaquesConfig.INSTANCE.hideWaila.get()).booleanValue() && ModList.get().isLoaded("waila")) {
                    boolean anyPlaques = false;
                    for (int i = 0; i < this.plaques.length; ++i) {
                        if (this.plaques[i] == null) continue;
                        anyPlaques = true;
                        break;
                    }
                    if (anyPlaques) {
                        Class.forName("com.anthonyhilyard.advancementplaques.WailaHandler").getMethod("disableWaila", new Class[0]).invoke(null, new Object[0]);
                    } else {
                        Class.forName("com.anthonyhilyard.advancementplaques.WailaHandler").getMethod("enableWaila", new Class[0]).invoke(null, new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            for (int i = 0; i < this.plaques.length; ++i) {
                AdvancementPlaque toastinstance = this.plaques[i];
                if (toastinstance != null && toastinstance.render(this.mc.m_91268_().m_85445_(), i, stack)) {
                    this.plaques[i] = null;
                }
                if (this.plaques[i] != null || this.advancementToastsQueue.isEmpty()) continue;
                this.plaques[i] = new AdvancementPlaque(this.advancementToastsQueue.removeFirst(), this.mc, this.itemRenderer);
            }
        }
    }

    public void m_94919_() {
        super.m_94919_();
        Arrays.fill(this.plaques, null);
        this.advancementToastsQueue.clear();
    }
}

