/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.client.GuiImageButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public abstract class GuiTweakButton
extends GuiImageButton
implements ITooltipProvider {
    private final AbstractContainerScreen<?> screen;
    private final CraftingGrid grid;
    private final TweakType tweak;
    private int lastGuiLeft;
    private int lastGuiTop;

    public GuiTweakButton(@Nullable AbstractContainerScreen<?> screen, int x, int y, int textureX, int textureY, CraftingGrid grid, TweakType tweak) {
        super(x, y, textureX, textureY);
        this.screen = screen;
        if (screen != null) {
            this.lastGuiLeft = ((AbstractContainerScreenAccessor)screen).getLeftPos();
            this.lastGuiTop = ((AbstractContainerScreenAccessor)screen).getTopPos();
        }
        this.grid = grid;
        this.tweak = tweak;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            this.onTweakButtonClicked((Player)player, this.screen != null ? this.screen.m_6262_() : player.f_36096_, this.grid);
        }
    }

    protected abstract void onTweakButtonClicked(Player var1, AbstractContainerMenu var2, CraftingGrid var3);

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.screen != null) {
            int guiLeft = ((AbstractContainerScreenAccessor)this.screen).getLeftPos();
            int guiTop = ((AbstractContainerScreenAccessor)this.screen).getTopPos();
            if (guiLeft != this.lastGuiLeft || guiTop != this.lastGuiTop) {
                this.f_93620_ += guiLeft - this.lastGuiLeft;
                this.f_93621_ += guiTop - this.lastGuiTop;
            }
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }
        int oldTexCoordX = this.texCoordX;
        if (Screen.m_96638_()) {
            this.texCoordX += 48;
        }
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.texCoordX = oldTexCoordX;
    }

    @Override
    public List<Component> getTooltip() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        switch (this.tweak) {
            case Rotate: {
                tooltip.add((Component)new TranslatableComponent("tooltip.craftingtweaks.rotate"));
                break;
            }
            case Clear: {
                if (Screen.m_96638_()) {
                    tooltip.add((Component)new TranslatableComponent("tooltip.craftingtweaks.forceClear"));
                    TranslatableComponent forceClearInfoText = new TranslatableComponent("tooltip.craftingtweaks.forceClear");
                    forceClearInfoText.m_130940_(ChatFormatting.GRAY);
                    tooltip.add((Component)forceClearInfoText);
                    break;
                }
                tooltip.add((Component)new TranslatableComponent("tooltip.craftingtweaks.clear"));
                break;
            }
            case Balance: {
                if (Screen.m_96638_()) {
                    tooltip.add((Component)new TranslatableComponent("tooltip.craftingtweaks.spread"));
                    break;
                }
                tooltip.add((Component)new TranslatableComponent("tooltip.craftingtweaks.balance"));
            }
        }
        return tooltip;
    }
}

