/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.init;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.init.BMModConfiguredStructureFeatures;
import com.yungnickyoung.minecraft.bettermineshafts.mixin.ChunkGeneratorAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.mixin.StructureSettingsAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructureFeature;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BMModStructureFeatures {
    public static final DeferredRegister<StructureFeature<?>> DEFERRED_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"bettermineshafts");
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> BETTER_MINESHAFT = BMModStructureFeatures.register("mineshaft", BetterMineshaftStructureFeature::new);
    public static StructureFeatureConfiguration BETTER_MINESHAFT_CONFIG = new StructureFeatureConfiguration(1, 0, 593751784);

    private static <T extends FeatureConfiguration> RegistryObject<StructureFeature<T>> register(String id, Supplier<StructureFeature<T>> structureFeatureSupplier) {
        return DEFERRED_REGISTRY.register(id, structureFeatureSupplier);
    }

    public static void init() {
        DEFERRED_REGISTRY.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BMModStructureFeatures::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(BMModStructureFeatures::addStructuresToBiomesAndDimensions);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BMModStructureFeatures.addStructure((StructureFeature)BETTER_MINESHAFT.get(), BETTER_MINESHAFT_CONFIG);
            Registry registry = BuiltinRegistries.f_123862_;
            Registry.m_122965_((Registry)registry, (ResourceLocation)new ResourceLocation("bettermineshafts", "mineshaft"), BMModConfiguredStructureFeatures.CONFIGURED_MINESHAFT);
        });
    }

    private static void addStructure(StructureFeature<?> structureFeature, StructureFeatureConfiguration structureFeatureConfig) {
        StructureFeature.f_67012_.put((Object)structureFeature.getRegistryName().toString(), structureFeature);
        StructureSettingsAccessor.setDEFAULTS(ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structureFeature, (Object)structureFeatureConfig).build());
        BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
            Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
            if (structureMap instanceof ImmutableMap) {
                HashMap tempMap = new HashMap(structureMap);
                tempMap.put(structureFeature, structureFeatureConfig);
                ((StructureSettingsAccessor)((NoiseGeneratorSettings)settings.getValue()).m_64457_()).setStructureConfig(tempMap);
            } else {
                structureMap.put(structureFeature, structureFeatureConfig);
            }
        });
    }

    private static void addStructuresToBiomesAndDimensions(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            BMModStructureFeatures.addStructureToBiomes(serverLevel);
            BMModStructureFeatures.addStructureToDimensions(serverLevel);
        }
    }

    private static void addStructureToBiomes(ServerLevel serverLevel) {
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        StructureSettings worldStructureSettings = chunkGenerator.m_62205_();
        ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
        ((StructureSettingsAccessor)worldStructureSettings).getConfiguredStructures().entrySet().stream().filter(entry -> entry.getKey() != BETTER_MINESHAFT.get() && entry.getKey() != StructureFeature.f_67014_).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
        ImmutableMultimap.Builder structureBiomeMap = ImmutableMultimap.builder();
        for (Map.Entry biomeEntry : ((WritableRegistry)serverLevel.m_5962_().m_142664_(Registry.f_122885_).get()).m_6579_()) {
            String biomeName = ((ResourceKey)biomeEntry.getKey()).m_135782_().toString();
            if (BetterMineshafts.blacklistedBiomes.contains(biomeName)) continue;
            structureBiomeMap.put(BMModConfiguredStructureFeatures.CONFIGURED_MINESHAFT, (Object)((ResourceKey)biomeEntry.getKey()));
        }
        tempStructureToMultiMap.put((Object)((StructureFeature)BETTER_MINESHAFT.get()), (Object)structureBiomeMap.build());
        ((StructureSettingsAccessor)worldStructureSettings).setConfiguredStructures(tempStructureToMultiMap.build());
    }

    private static void addStructureToDimensions(ServerLevel serverLevel) {
        ResourceLocation chunkGenResourceLocation = Registry.f_122890_.m_7981_(((ChunkGeneratorAccessor)serverLevel.m_7726_().m_8481_()).invokeCodec());
        if (chunkGenResourceLocation != null && chunkGenResourceLocation.m_135827_().equals("terraforged")) {
            return;
        }
        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
        StructureSettings structureSettings = chunkGenerator.m_62205_();
        HashMap tempMap = new HashMap(structureSettings.m_64590_());
        if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
            tempMap.keySet().remove(BETTER_MINESHAFT.get());
            return;
        }
        if (BetterMineshafts.whitelistedDimensions.contains(serverLevel.m_46472_().m_135782_().toString())) {
            tempMap.putIfAbsent((StructureFeature)BETTER_MINESHAFT.get(), BETTER_MINESHAFT_CONFIG);
        } else {
            tempMap.remove(BETTER_MINESHAFT.get());
        }
        ((StructureSettingsAccessor)structureSettings).setStructureConfig(tempMap);
    }
}

