/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.VerticalEntrance;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariants;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraftforge.common.BiomeDictionary;
import org.jetbrains.annotations.NotNull;

public class BetterMineshaftStructureFeature
extends StructureFeature<NoneFeatureConfiguration> {
    public BetterMineshaftStructureFeature() {
        super(NoneFeatureConfiguration.f_67815_, context -> {
            if (!BetterMineshaftStructureFeature.checkLocation((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context)) {
                return Optional.empty();
            }
            return Optional.of(BetterMineshaftStructureFeature::generatePieces);
        });
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenRandom.m_190068_(context.f_197354_(), context.f_197355_().f_45578_, context.f_197355_().f_45579_);
        return worldgenRandom.nextDouble() < (Double)BMConfig.mineshaftSpawnRate.get() && context.f_197358_().test(context.f_197352_().m_7158_(QuartPos.m_175400_((int)context.f_197355_().m_151390_()), QuartPos.m_175400_((int)50), QuartPos.m_175400_((int)context.f_197355_().m_151393_())));
    }

    private static void generatePieces(StructurePiecesBuilder structurePiecesBuilder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        Direction direction = Direction.NORTH;
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        rand.m_190068_(context.f_192709_(), context.f_192705_().f_45578_, context.f_192705_().f_45579_);
        int r = rand.nextInt(4);
        switch (r) {
            case 0: {
                direction = Direction.NORTH;
                break;
            }
            case 1: {
                direction = Direction.SOUTH;
                break;
            }
            case 2: {
                direction = Direction.EAST;
                break;
            }
            case 3: {
                direction = Direction.WEST;
            }
        }
        int x = context.f_192705_().m_151390_();
        int z = context.f_192705_().m_151393_();
        int y = context.f_192708_().nextInt((Integer)BMConfig.maxY.get() - (Integer)BMConfig.minY.get() + 1) + (Integer)BMConfig.minY.get();
        BlockPos.MutableBlockPos startingPos = new BlockPos.MutableBlockPos(context.f_192705_().m_151382_(3), y, context.f_192705_().m_151391_(3));
        Biome biome = context.f_192703_().m_7158_(QuartPos.m_175400_((int)x), QuartPos.m_175400_((int)y), QuartPos.m_175400_((int)z));
        MineshaftVariantSettings settings = BetterMineshaftStructureFeature.getSettingsForBiome(biome);
        VerticalEntrance entryPoint = new VerticalEntrance(-1, (Random)context.f_192708_(), startingPos, direction, settings);
        structurePiecesBuilder.m_142679_((StructurePiece)entryPoint);
        ((MineshaftPiece)entryPoint).m_142537_(entryPoint, (StructurePieceAccessor)structurePiecesBuilder, (Random)context.f_192708_());
    }

    private static MineshaftVariantSettings getSettingsForBiome(Biome biome) {
        if (biome.getRegistryName() == null) {
            BetterMineshafts.LOGGER.error("Found null registry name for biome {}. This shouldn't happen!", (Object)biome);
            return MineshaftVariants.get().getDefault();
        }
        ResourceKey registryKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biome.getRegistryName());
        for (MineshaftVariantSettings variant : MineshaftVariants.get().getVariants()) {
            for (List<BiomeDictionary.Type> tagList : variant.biomeTags) {
                boolean found = true;
                for (BiomeDictionary.Type tag : tagList) {
                    if (BiomeDictionary.hasType((ResourceKey)registryKey, (BiomeDictionary.Type)tag)) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return variant;
            }
        }
        return MineshaftVariants.get().getDefault();
    }
}

