/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

@ParametersAreNonnullByDefault
public class BigTunnel
extends MineshaftPiece {
    private final List<BlockPos> smallShaftLeftEntrances = Lists.newLinkedList();
    private final List<BlockPos> smallShaftRightEntrances = Lists.newLinkedList();
    private final List<BoundingBox> sideRoomEntrances = Lists.newLinkedList();
    private final List<Integer> bigSupports = Lists.newLinkedList();
    private final List<Integer> smallSupports = Lists.newLinkedList();
    private final List<Pair<Integer, Integer>> gravelDeposits = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 8;
    private static final int MAIN_AXIS_LEN = 24;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 7;
    private static final int LOCAL_Z_END = 23;

    public BigTunnel(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.BIG_TUNNEL, compoundTag);
        int i;
        ListTag listTag1 = compoundTag.m_128437_("SmallShaftLeftEntrances", 11);
        ListTag listTag2 = compoundTag.m_128437_("SmallShaftRightEntrances", 11);
        ListTag listTag3 = compoundTag.m_128437_("SideRoomEntrances", 11);
        ListTag listTag4 = compoundTag.m_128437_("BigSupports", 3);
        ListTag listTag5 = compoundTag.m_128437_("SmallSupports", 3);
        ListTag listTag6 = compoundTag.m_128437_("GravelDeposits", 11);
        for (i = 0; i < listTag1.size(); ++i) {
            this.smallShaftLeftEntrances.add(new BlockPos(listTag1.m_128767_(i)[0], listTag1.m_128767_(i)[1], listTag1.m_128767_(i)[2]));
        }
        for (i = 0; i < listTag2.size(); ++i) {
            this.smallShaftRightEntrances.add(new BlockPos(listTag2.m_128767_(i)[0], listTag2.m_128767_(i)[1], listTag2.m_128767_(i)[2]));
        }
        for (i = 0; i < listTag3.size(); ++i) {
            this.sideRoomEntrances.add(new BoundingBox(listTag3.m_128767_(i)[0], listTag3.m_128767_(i)[1], listTag3.m_128767_(i)[2], listTag3.m_128767_(i)[3], listTag3.m_128767_(i)[4], listTag3.m_128767_(i)[5]));
        }
        for (i = 0; i < listTag4.size(); ++i) {
            this.bigSupports.add(listTag4.m_128763_(i));
        }
        for (i = 0; i < listTag5.size(); ++i) {
            this.smallSupports.add(listTag5.m_128763_(i));
        }
        for (i = 0; i < listTag6.size(); ++i) {
            this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)listTag6.m_128767_(i)[0], (Object)listTag6.m_128767_(i)[1]));
        }
    }

    public BigTunnel(int chainLength, Random random, BoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.BIG_TUNNEL, chainLength, settings, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        ListTag listTag1 = new ListTag();
        ListTag listTag2 = new ListTag();
        ListTag listTag3 = new ListTag();
        ListTag listTag4 = new ListTag();
        ListTag listTag5 = new ListTag();
        ListTag listTag6 = new ListTag();
        this.smallShaftLeftEntrances.forEach(pos -> listTag1.add((Object)new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()})));
        this.smallShaftRightEntrances.forEach(pos -> listTag2.add((Object)new IntArrayTag(new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()})));
        this.sideRoomEntrances.forEach(blockBox -> listTag3.add((Object)new IntArrayTag(new int[]{blockBox.m_162395_(), blockBox.m_162396_(), blockBox.m_162398_(), blockBox.m_162399_(), blockBox.m_162400_(), blockBox.m_162401_()})));
        this.bigSupports.forEach(z -> listTag4.add((Object)IntTag.m_128679_((int)z)));
        this.smallSupports.forEach(z -> listTag5.add((Object)IntTag.m_128679_((int)z)));
        this.gravelDeposits.forEach(pair -> listTag6.add((Object)new IntArrayTag(new int[]{(Integer)pair.getFirst(), (Integer)pair.getSecond()})));
        compoundTag.m_128365_("SmallShaftLeftEntrances", (Tag)listTag1);
        compoundTag.m_128365_("SmallShaftRightEntrances", (Tag)listTag2);
        compoundTag.m_128365_("SideRoomEntrances", (Tag)listTag3);
        compoundTag.m_128365_("BigSupports", (Tag)listTag4);
        compoundTag.m_128365_("SmallSupports", (Tag)listTag5);
        compoundTag.m_128365_("GravelDeposits", (Tag)listTag6);
    }

    public static BoundingBox determineBoxPosition(int x, int y, int z, Direction direction) {
        return BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)9, (int)8, (int)24, (Direction)direction);
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, direction, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, direction, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_(), direction, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), direction, this.f_73384_);
            }
        }
        int pieceLen = this.m_73549_().m_122434_() == Direction.Axis.Z ? this.f_73383_.m_71058_() : this.f_73383_.m_71056_();
        this.buildSideRoomsLeft(structurePiece, structurePieceAccessor, random, direction, pieceLen);
        this.buildSideRoomsRight(structurePiece, structurePieceAccessor, random, direction, pieceLen);
        this.buildSmallShaftsLeft(structurePiece, structurePieceAccessor, random, direction, pieceLen);
        this.buildSmallShaftsRight(structurePiece, structurePieceAccessor, random, direction, pieceLen);
        this.buildSupports(random);
        this.buildGravelDeposits(random);
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 8, 7, 23, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 8, 0, 23, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 7, 4, 23, AIR);
        this.fill(world, box, 2, 4, 0, 6, 5, 23, AIR);
        this.fill(world, box, 3, 6, 0, 5, 6, 23, AIR);
        this.replaceAirOrChains(world, box, 1, 0, 0, 7, 0, 23, this.getMainBlock());
        this.generateSmallShaftEntrances(world, box, random);
        this.generateSideRoomOpenings(world, box, random);
        this.generateLegs(world, box, random);
        this.generateBigSupports(world, box, random);
        this.generateSmallSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateChestCarts(world, box, random);
        this.generateTntCarts(world, box, random);
        this.generateGravelDeposits(world, box, random);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 8, 6, 23);
        this.addVines(world, box, random, this.settings.vineChance, 1, 0, 1, 7, 7, 22);
        this.generateLanterns(world, box, random);
    }

    private void generateSmallShaftEntrances(WorldGenLevel world, BoundingBox box, Random random) {
        BlockState blockState;
        int j;
        int i;
        int numCovered;
        int z;
        int y;
        int x;
        for (BlockPos entrancePos : this.smallShaftLeftEntrances) {
            x = entrancePos.m_123341_();
            y = entrancePos.m_123342_();
            z = entrancePos.m_123343_();
            numCovered = 0;
            for (i = z; i <= z + 2; ++i) {
                for (j = x; j <= x + 1; ++j) {
                    blockState = this.m_73398_((BlockGetter)world, j, y + 3, i, box);
                    if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50184_)) continue;
                    ++numCovered;
                }
            }
            this.fill(world, box, x, y, z, x + 1, y + 2, z + 2, AIR);
            this.replaceAirOrChains(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
            if (numCovered < 2) continue;
            this.m_73434_(world, this.getSupportBlock(), x, y + 1, z, box);
            this.m_73434_(world, this.getSupportBlock(), x, y + 1, z + 2, box);
            this.fill(world, box, x + 1, y, z, x + 1, y + 1, z, this.getSupportBlock());
            this.fill(world, box, x + 1, y, z + 2, x + 1, y + 1, z + 2, this.getSupportBlock());
            this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, AIR);
        }
        for (BlockPos entrancePos : this.smallShaftRightEntrances) {
            x = entrancePos.m_123341_();
            y = entrancePos.m_123342_();
            z = entrancePos.m_123343_();
            numCovered = 0;
            for (i = z; i <= z + 2; ++i) {
                for (j = x; j <= x + 1; ++j) {
                    blockState = this.m_73398_((BlockGetter)world, j, y + 3, i, box);
                    if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50184_)) continue;
                    ++numCovered;
                }
            }
            this.fill(world, box, x, y, z, x + 1, y + 2, z + 2, AIR);
            this.replaceAirOrChains(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
            if (numCovered < 2) continue;
            this.m_73434_(world, this.getSupportBlock(), x + 1, y + 1, z, box);
            this.m_73434_(world, this.getSupportBlock(), x + 1, y + 1, z + 2, box);
            this.fill(world, box, x, y, z, x, y + 1, z, this.getSupportBlock());
            this.fill(world, box, x, y, z + 2, x, y + 1, z + 2, this.getSupportBlock());
            this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, AIR);
        }
    }

    private void generateLegs(WorldGenLevel world, BoundingBox box, Random random) {
        if (this.settings.legVariant == 1) {
            this.generateLegsVariant1(world, box, random);
        } else {
            this.generateLegsVariant2(world, box, random);
        }
    }

    private void generateLegsVariant1(WorldGenLevel world, BoundingBox box, Random random) {
        BlockSetSelector legSelector;
        boolean generatedLeg;
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.m_61147_().contains(BlockStateProperties.f_61379_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61380_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61379_, (Comparable)WallSide.TALL)).m_61124_((Property)BlockStateProperties.f_61380_, (Comparable)WallSide.TALL);
        } else if (supportBlock.m_61147_().contains(BlockStateProperties.f_61368_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61370_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true));
        }
        if (supportBlock.m_61147_().contains(BlockStateProperties.f_61366_)) {
            supportBlock = (BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(false));
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 1, 0, legSelector = this.getLegSelector())) {
            this.replaceAirOrChains(world, box, 1, -1, 1, 1, -1, 5, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 1, 1, -2, 3, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 1, 1, -3, 2, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 1, 1, -4, 1, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 1, 11, legSelector)) {
            this.replaceAirOrChains(world, box, 1, -1, 6, 1, -1, 10, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 8, 1, -2, 10, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 9, 1, -3, 10, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 10, 1, -4, 10, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 1, 12, legSelector)) {
            this.replaceAirOrChains(world, box, 1, -1, 13, 1, -1, 17, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 13, 1, -2, 15, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 13, 1, -3, 14, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 13, 1, -4, 13, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 1, 23, legSelector)) {
            this.replaceAirOrChains(world, box, 1, -1, 18, 1, -1, 22, supportBlock);
            this.replaceAirOrChains(world, box, 1, -2, 20, 1, -2, 22, supportBlock);
            this.replaceAirOrChains(world, box, 1, -3, 21, 1, -3, 22, supportBlock);
            this.replaceAirOrChains(world, box, 1, -5, 22, 1, -4, 22, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 7, 0, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 1, 7, -1, 5, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 1, 7, -2, 3, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 1, 7, -3, 2, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 1, 7, -4, 1, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 7, 11, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 6, 7, -1, 10, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 8, 7, -2, 10, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 9, 7, -3, 10, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 10, 7, -4, 10, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 7, 12, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 13, 7, -1, 17, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 13, 7, -2, 15, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 13, 7, -3, 14, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 13, 7, -4, 13, supportBlock);
        }
        if (generatedLeg = this.generateLegOrChain(world, random, box, 7, 23, legSelector)) {
            this.replaceAirOrChains(world, box, 7, -1, 18, 7, -1, 22, supportBlock);
            this.replaceAirOrChains(world, box, 7, -2, 20, 7, -2, 22, supportBlock);
            this.replaceAirOrChains(world, box, 7, -3, 21, 7, -3, 22, supportBlock);
            this.replaceAirOrChains(world, box, 7, -5, 22, 7, -4, 22, supportBlock);
        }
    }

    private void generateLegsVariant2(WorldGenLevel world, BoundingBox box, Random random) {
        BlockSetSelector legSelector = this.getLegSelector();
        for (int z = 0; z <= 23; z += 7) {
            this.generateLeg(world, random, box, 2, z + 1, legSelector);
            this.generateLeg(world, random, box, 6, z + 1, legSelector);
            this.replaceAirOrChains(world, box, random, 1, -1, z, 7, -1, z + 2, legSelector);
            this.replaceAirOrChains(world, box, random, 2, -1, z + 3, 2, -1, z + 3, legSelector);
            this.replaceAirOrChains(world, box, random, 6, -1, z + 3, 6, -1, z + 3, legSelector);
            this.replaceAirOrChains(world, box, random, 3, -1, z + 3, 5, -1, z + 6, legSelector);
            this.replaceAirOrChains(world, box, random, 2, -1, z + 6, 2, -1, z + 6, legSelector);
            this.replaceAirOrChains(world, box, random, 6, -1, z + 6, 6, -1, z + 6, legSelector);
            this.replaceAirOrChains(world, box, random, 2, -2, z, 2, -2, z, legSelector);
            this.replaceAirOrChains(world, box, random, 6, -2, z, 6, -2, z, legSelector);
            this.replaceAirOrChains(world, box, random, 2, -2, z + 2, 2, -2, z + 2, legSelector);
            this.replaceAirOrChains(world, box, random, 6, -2, z + 2, 6, -2, z + 2, legSelector);
            this.replaceAirOrChains(world, box, random, 1, -2, z + 1, 1, -2, z + 1, legSelector);
            this.replaceAirOrChains(world, box, random, 7, -2, z + 1, 7, -2, z + 1, legSelector);
            this.replaceAirOrChains(world, box, random, 3, -2, z + 1, 3, -2, z + 1, legSelector);
            this.replaceAirOrChains(world, box, random, 5, -2, z + 1, 5, -2, z + 1, legSelector);
        }
    }

    private void generateGravelDeposits(WorldGenLevel world, BoundingBox box, Random random) {
        this.gravelDeposits.forEach(pair -> {
            int z = (Integer)pair.getFirst();
            int side = (Integer)pair.getSecond();
            switch (side) {
                default: {
                    this.replaceAirOrChains(world, box, 1, 1, z, 1, 2, z + 2, this.getGravel());
                    this.replaceAirOrChains(world, box, 1, 3, z + 1, 1, 3 + random.nextInt(2), z + 1, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 1, 3, z, 1, 3, z + 2, this.getGravel());
                    this.replaceAirOrChains(world, box, 2, 1, z + 1, 2, 2 + random.nextInt(2), z + 1, this.getGravel());
                    this.replaceAirOrChains(world, box, 2, 1, z, 2, 1 + random.nextInt(2), z + 2, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 3, 1, z, 3, 1, z + 2, this.getGravel());
                    break;
                }
                case 1: {
                    this.replaceAirOrChains(world, box, 7, 1, z, 7, 2, z + 2, this.getGravel());
                    this.replaceAirOrChains(world, box, 7, 3, z + 1, 7, 3 + random.nextInt(2), z + 1, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 7, 3, z, 7, 3, z + 2, this.getGravel());
                    this.replaceAirOrChains(world, box, 6, 1, z + 1, 6, 2 + random.nextInt(2), z + 1, this.getGravel());
                    this.replaceAirOrChains(world, box, 6, 1, z, 6, 1 + random.nextInt(2), z + 2, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 5, 1, z, 5, 1, z + 2, this.getGravel());
                }
            }
        });
    }

    private void generateChestCarts(WorldGenLevel world, BoundingBox box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            BlockPos.MutableBlockPos blockPos;
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.mainShaftChestMinecartSpawnRate.get()) || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(4, 1, z))) || world.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
            MinecartChest chestMinecartEntity = new MinecartChest((Level)world.m_6018_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
            chestMinecartEntity.m_38236_(BuiltInLootTables.f_78759_, random.nextLong());
            world.m_7967_((Entity)chestMinecartEntity);
        }
    }

    private void generateTntCarts(WorldGenLevel world, BoundingBox box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            BlockPos.MutableBlockPos blockPos;
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.mainShaftTntMinecartSpawnRate.get()) || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(4, 1, z))) || world.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
            MinecartTNT tntMinecartEntity = new MinecartTNT((Level)world.m_6018_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
            world.m_7967_((Entity)tntMinecartEntity);
        }
    }

    private void generateBigSupports(WorldGenLevel world, BoundingBox box, Random random) {
        float cobwebChance = ((Double)BMConfig.spawnRates.cobwebSpawnRate.get()).floatValue();
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.m_61147_().contains(BlockStateProperties.f_61378_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61381_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.TALL)).m_61124_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.TALL);
        } else if (supportBlock.m_61147_().contains(BlockStateProperties.f_61369_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61371_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.bigSupports) {
            int numCovered = 0;
            for (int x = 2; x <= 6; ++x) {
                BlockState blockState = this.m_73398_((BlockGetter)world, x, 7, z, box);
                if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50184_)) continue;
                ++numCovered;
            }
            if (numCovered < 2) continue;
            this.chanceFill(world, box, random, 0.6f, 1, 1, z, 2, 1, z + 2, this.getMainSlab());
            this.chanceFill(world, box, random, 0.6f, 6, 1, z, 7, 1, z + 2, this.getMainSlab());
            this.m_73434_(world, this.getMainBlock(), 1, 1, z + 1, box);
            this.m_73434_(world, this.getMainBlock(), 7, 1, z + 1, box);
            this.m_73434_(world, this.getMainBlock(), 1, 4, z + 1, box);
            this.m_73434_(world, this.getMainBlock(), 7, 4, z + 1, box);
            this.fill(world, box, 2, 5, z + 1, 6, 5, z + 1, this.getMainBlock());
            this.fill(world, box, 1, 2, z + 1, 1, 3, z + 1, this.getSupportBlock());
            this.fill(world, box, 7, 2, z + 1, 7, 3, z + 1, this.getSupportBlock());
            this.chanceReplaceNonAir(world, box, random, 0.4f, 2, 5, z + 1, 6, 5, z + 1, supportBlock);
            this.chanceReplaceAir(world, box, random, cobwebChance, 1, 1, z, 1, 4, z + 2, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, random, cobwebChance, 7, 1, z, 7, 4, z + 2, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, random, cobwebChance, 2, 5, z, 6, 5, z + 2, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, random, cobwebChance, 2, 4, z + 1, 6, 4, z + 1, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, random, cobwebChance, 3, 6, z + 1, 5, 6, z + 1, Blocks.f_50033_.m_49966_());
        }
    }

    private void generateSmallSupports(WorldGenLevel world, BoundingBox box, Random random) {
        float cobwebChance = ((Double)BMConfig.spawnRates.cobwebSpawnRate.get()).floatValue();
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.m_61147_().contains(BlockStateProperties.f_61378_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61381_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.TALL)).m_61124_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.TALL);
        } else if (supportBlock.m_61147_().contains(BlockStateProperties.f_61369_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61371_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.smallSupports) {
            int numCovered = 0;
            for (int x = 2; x <= 6; ++x) {
                BlockState blockState = this.m_73398_((BlockGetter)world, x, 7, z, box);
                if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50184_)) continue;
                ++numCovered;
            }
            if (numCovered < 2) continue;
            this.m_73434_(world, this.getMainBlock(), 2, 1, z, box);
            this.m_73434_(world, this.getMainBlock(), 6, 1, z, box);
            this.m_73434_(world, this.getSupportBlock(), 2, 2, z, box);
            this.m_73434_(world, this.getSupportBlock(), 6, 2, z, box);
            this.m_73434_(world, this.getMainBlock(), 2, 3, z, box);
            this.m_73434_(world, this.getMainBlock(), 6, 3, z, box);
            this.fill(world, box, 3, 4, z, 5, 4, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.5f, 3, 4, z, 5, 4, z, supportBlock);
            this.chanceFill(world, box, random, 0.4f, 2, 3, z, 6, 3, z, supportBlock);
            this.m_73434_(world, supportBlock, 3, 3, z, box);
            this.m_73434_(world, supportBlock, 5, 3, z, box);
            this.chanceReplaceAir(world, box, random, cobwebChance, 2, 3, z - 1, 6, 4, z + 1, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, random, cobwebChance, 3, 5, z, 5, 5, z, Blocks.f_50033_.m_49966_());
        }
    }

    private void generateLanterns(WorldGenLevel world, BoundingBox box, Random random) {
        BlockState LANTERN = (BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true));
        for (int z = 0; z <= 23; ++z) {
            for (int x = 3; x <= 5; ++x) {
                if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.lanternSpawnRate.get()) || this.m_73398_((BlockGetter)world, x, 7, z, box).m_60795_()) continue;
                this.m_73434_(world, LANTERN, x, 6, z, box);
                z += 20;
            }
        }
    }

    private void generateRails(WorldGenLevel world, BoundingBox box, Random random) {
        this.chanceFill(world, box, random, 0.5f, 4, 1, 0, 4, 1, 23, Blocks.f_50156_.m_49966_());
        int blocksSinceLastRail = 0;
        for (int n = 0; n <= 23; ++n) {
            if (random.nextInt(20) != 0 && ++blocksSinceLastRail <= 25) continue;
            this.m_73434_(world, (BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)), 4, 1, n, box);
            blocksSinceLastRail = 0;
        }
    }

    private void generateSideRoomOpenings(WorldGenLevel world, BoundingBox chunkBox, Random random) {
        this.sideRoomEntrances.forEach(entranceBox -> {
            this.replaceAirOrChains(world, chunkBox, random, entranceBox.m_162395_(), 0, entranceBox.m_162398_(), entranceBox.m_162399_(), 0, entranceBox.m_162401_(), this.getBrickSelector());
            switch (random.nextInt(3)) {
                case 0: {
                    this.fill(world, chunkBox, entranceBox.m_162395_(), entranceBox.m_162396_(), entranceBox.m_162398_() + 2, entranceBox.m_162399_(), entranceBox.m_162400_(), entranceBox.m_162401_() - 2, AIR);
                    return;
                }
                case 1: {
                    this.fill(world, chunkBox, entranceBox.m_162395_(), entranceBox.m_162396_(), entranceBox.m_162398_() + 2, entranceBox.m_162399_(), entranceBox.m_162400_() - 1, entranceBox.m_162398_() + 2, AIR);
                    this.fill(world, chunkBox, entranceBox.m_162395_(), entranceBox.m_162396_(), entranceBox.m_162398_() + 4, entranceBox.m_162399_(), entranceBox.m_162400_() - 1, entranceBox.m_162398_() + 5, AIR);
                    this.fill(world, chunkBox, entranceBox.m_162395_(), entranceBox.m_162396_(), entranceBox.m_162398_() + 7, entranceBox.m_162399_(), entranceBox.m_162400_() - 1, entranceBox.m_162398_() + 7, AIR);
                    return;
                }
            }
        });
    }

    private void buildGravelDeposits(Random random) {
        for (int z = 0; z <= 21; ++z) {
            int r = random.nextInt(20);
            int currPos = z;
            if (r == 0) {
                this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)currPos, (Object)0));
                z += 5;
                continue;
            }
            if (r != 1) continue;
            this.gravelDeposits.add((Pair<Integer, Integer>)new Pair((Object)currPos, (Object)1));
            z += 5;
        }
    }

    private void buildSupports(Random random) {
        int counter = 0;
        int MAX_COUNT = 10;
        for (int z = 0; z <= 21; ++z) {
            ++counter;
            boolean blockingEntrance = false;
            for (BlockPos entrancePos : this.smallShaftLeftEntrances) {
                if (entrancePos.m_123343_() > z + 2 || z > entrancePos.m_123343_() + 2) continue;
                blockingEntrance = true;
                break;
            }
            for (BlockPos entrancePos : this.smallShaftRightEntrances) {
                if (entrancePos.m_123343_() > z + 2 || z > entrancePos.m_123343_() + 2) continue;
                blockingEntrance = true;
                break;
            }
            if (blockingEntrance) continue;
            int r = random.nextInt(8);
            if (r == 0 || counter >= 10) {
                this.bigSupports.add(z);
                counter = 0;
                z += 3;
                continue;
            }
            if (r != 1) continue;
            this.smallSupports.add(z);
            counter = 0;
            z += 3;
        }
    }

    private void buildSideRoomsLeft(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random, Direction direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.workstationSpawnRate.get())) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 5, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - n - 9, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 5, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + n + 9, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - n - 9, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 5, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + n + 9, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 5, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(0, 1, n, 0, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSideRoomsRight(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random, Direction direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.workstationSpawnRate.get())) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 5, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - n, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 5, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + n, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - n, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 5, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + n, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 5, nextPieceDirection, this.f_73384_);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new BoundingBox(8, 1, n, 8, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSmallShaftsLeft(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random, Direction direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 4; ++n) {
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.smallShaftSpawnRate.get())) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n + 1));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n + 1));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - n, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n + 1));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + n, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n + 1));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }

    private void buildSmallShaftsRight(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random, Direction direction, int pieceLen) {
        for (int n = 5; n < pieceLen; ++n) {
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.smallShaftSpawnRate.get())) continue;
            switch (direction) {
                default: {
                    Direction nextPieceDirection = Direction.EAST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() - n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n - 3));
                    break;
                }
                case SOUTH: {
                    Direction nextPieceDirection = Direction.WEST;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() + n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n - 3));
                    break;
                }
                case WEST: {
                    Direction nextPieceDirection = Direction.NORTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() - n, this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new BlockPos(0, 1, n - 3));
                    break;
                }
                case EAST: {
                    Direction nextPieceDirection = Direction.SOUTH;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() + n, this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new BlockPos(7, 1, n - 3));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }
}

