/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariants;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.Random;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public abstract class MineshaftPiece
extends StructurePiece {
    public MineshaftVariantSettings settings;
    protected static final BlockState AIR = Blocks.f_50016_.m_49966_();
    private static final Set<Material> NON_SOLID_MATERIALS = Set.of(Material.f_76296_, Material.f_76305_, Material.f_76307_, Material.f_76301_);

    public MineshaftPiece(StructurePieceType structurePieceType, int chainLength, MineshaftVariantSettings settings, BoundingBox boundingBox) {
        super(structurePieceType, chainLength, boundingBox);
        this.settings = settings;
    }

    public MineshaftPiece(StructurePieceType structurePieceType, CompoundTag compoundTag) {
        super(structurePieceType, compoundTag);
        int index = compoundTag.m_128451_("MST");
        this.settings = index < MineshaftVariants.get().getVariants().size() && index >= 0 ? MineshaftVariants.get().getVariants().get(index) : MineshaftVariants.get().getDefault();
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        int index = MineshaftVariants.get().getVariants().indexOf(this.settings);
        compoundTag.m_128405_("MST", index);
    }

    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
    }

    protected BlockSetSelector getMainSelector() {
        return this.settings.mainSelector;
    }

    protected BlockSetSelector getFloorSelector() {
        return this.settings.floorSelector;
    }

    protected BlockSetSelector getBrickSelector() {
        return this.settings.brickSelector;
    }

    protected BlockSetSelector getLegSelector() {
        return this.settings.legSelector;
    }

    protected BlockState getMainBlock() {
        return this.settings.mainBlock;
    }

    protected BlockState getSupportBlock() {
        return this.settings.supportBlock;
    }

    protected BlockState getMainSlab() {
        return this.settings.slabBlock;
    }

    protected BlockState getGravel() {
        return this.settings.gravelBlock;
    }

    protected BlockState getMainDoorwayWall() {
        return this.settings.stoneWallBlock;
    }

    protected BlockState getMainDoorwaySlab() {
        return this.settings.stoneSlabBlock;
    }

    protected BlockState getTrapdoor() {
        return this.settings.trapdoorBlock;
    }

    protected BlockState getSmallLegBlock() {
        return this.settings.smallLegBlock;
    }

    protected boolean addBarrel(WorldGenLevel world, BoundingBox boundingBox, Random random, BlockPos pos, ResourceLocation lootTableId) {
        if (boundingBox.m_71051_((Vec3i)pos) && world.m_8055_(pos).m_60734_() != Blocks.f_50618_) {
            world.m_7731_(pos, (BlockState)Blocks.f_50618_.m_49966_().m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP), 2);
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)world, (Random)random, (BlockPos)pos, (ResourceLocation)lootTableId);
            return true;
        }
        return false;
    }

    protected boolean addBarrel(WorldGenLevel world, BoundingBox boundingBox, Random random, int x, int y, int z, ResourceLocation lootTableId) {
        return this.addBarrel(world, boundingBox, random, (BlockPos)this.m_163582_(x, y, z), lootTableId);
    }

    protected void addVines(WorldGenLevel world, BoundingBox boundingBox, Direction facing, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    mutable.m_122178_(this.m_73392_(x, z), this.m_73544_(y), this.m_73525_(x, z)).m_122173_(facing);
                    BlockState nextBlock = this.m_73398_((BlockGetter)world, x + facing.m_122429_(), y + facing.m_122430_(), z + facing.m_122431_(), boundingBox);
                    if (!this.m_73398_((BlockGetter)world, x, y, z, boundingBox).m_60795_() || !Block.m_49918_((VoxelShape)nextBlock.m_60812_((BlockGetter)world, (BlockPos)mutable), (Direction)facing.m_122424_()) || nextBlock.m_60734_().m_49966_() == Blocks.f_50155_.m_49966_() || !(random.nextFloat() < chance)) continue;
                    this.m_73434_(world, (BlockState)Blocks.f_50191_.m_49966_().m_61124_((Property)VineBlock.m_57883_((Direction)(facing.m_122434_() == Direction.Axis.X ? facing : facing.m_122424_())), (Comparable)Boolean.valueOf(true)), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void addVines(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.addVines(world, boundingBox, Direction.EAST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.WEST, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.NORTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
        this.addVines(world, boundingBox, Direction.SOUTH, random, chance, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void addBiomeDecorations(WorldGenLevel world, BoundingBox box, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos.MutableBlockPos blockPos = this.m_163582_(x, y, z);
                    BlockState state = this.m_73398_((BlockGetter)world, x, y, z, box);
                    BlockState stateBelow = this.m_73398_((BlockGetter)world, x, y - 1, z, box);
                    if (this.settings.snowChance > 0.0f && random.nextFloat() < this.settings.snowChance && state.m_60795_() && Blocks.f_50125_.m_7898_(AIR, (LevelReader)world, (BlockPos)blockPos)) {
                        this.m_73434_(world, (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(random.nextInt(2) + 1)), x, y, z, box);
                    }
                    if (this.settings.lushDecorations) {
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.005f) {
                            CaveFeatures.f_194950_.m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.005f) {
                            CaveFeatures.f_194955_.m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (box.m_71051_((Vec3i)blockPos) && random.nextFloat() < 0.005f) {
                            CaveFeatures.f_194956_.m_65385_(world, world.m_6018_().m_7726_().m_8481_(), random, (BlockPos)blockPos);
                        }
                        if (stateBelow.m_60713_(this.getMainBlock().m_60734_()) && state.m_60795_() && stateBelow.m_60783_((BlockGetter)world, blockPos.m_7495_(), Direction.UP)) {
                            this.m_73434_(world, Blocks.f_152543_.m_49966_(), x, y, z, box);
                        }
                    }
                    if (this.settings.cactusChance > 0.0f && random.nextFloat() < this.settings.cactusChance && state.m_60795_() && Blocks.f_50128_.m_7898_(AIR, (LevelReader)world, (BlockPos)blockPos)) {
                        this.m_73434_(world, (BlockState)Blocks.f_50128_.m_49966_().m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0)), x, y, z, box);
                        if (random.nextFloat() < 0.5f && this.m_73398_((BlockGetter)world, x, y + 1, z, box).m_60713_(Blocks.f_50016_)) {
                            this.m_73434_(world, (BlockState)Blocks.f_50128_.m_49966_().m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0)), x, y + 1, z, box);
                        }
                    }
                    if (this.settings.deadBushChance > 0.0f && random.nextFloat() < this.settings.deadBushChance && state.m_60795_() && (stateBelow.m_60713_(Blocks.f_49992_) || stateBelow.m_60713_(Blocks.f_49993_) || stateBelow.m_60713_(Blocks.f_50352_) || stateBelow.m_60713_(Blocks.f_50287_) || stateBelow.m_60713_(Blocks.f_50288_) || stateBelow.m_60713_(Blocks.f_50291_) || stateBelow.m_60713_(Blocks.f_50299_) || stateBelow.m_60713_(Blocks.f_50493_))) {
                        this.m_73434_(world, Blocks.f_50036_.m_49966_(), x, y, z, box);
                    }
                    if (!(this.settings.mushroomChance > 0.0f) || !state.m_60795_() || !Blocks.f_50073_.m_7898_(AIR, (LevelReader)world, (BlockPos)blockPos)) continue;
                    float r = random.nextFloat();
                    if (r < this.settings.mushroomChance / 2.0f) {
                        this.m_73434_(world, Blocks.f_50073_.m_49966_(), x, y, z, box);
                        continue;
                    }
                    if (!(r < this.settings.mushroomChance)) continue;
                    this.m_73434_(world, Blocks.f_50072_.m_49966_(), x, y, z, box);
                }
            }
        }
    }

    protected void generateLeg(WorldGenLevel world, Random random, BoundingBox box, int x, int z, BlockSetSelector selector) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, -1, z);
        BlockState state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        while (this.m_73544_(mutable.m_123342_()) > world.m_141937_() + 1 && this.m_163572_(state)) {
            this.m_73434_(world, selector.get(random), x, mutable.m_123342_(), z, box);
            mutable.m_122173_(Direction.DOWN);
            state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        }
    }

    protected boolean generateLegOrChain(WorldGenLevel world, Random random, BoundingBox box, int x, int z, BlockSetSelector selector) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, -1, z);
        BlockState state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        boolean lavaBelow = false;
        while (this.m_73544_(mutable.m_123342_()) > world.m_141937_() + 1 && this.m_163572_(state)) {
            if (state.m_60713_(Blocks.f_49991_)) {
                lavaBelow = true;
                break;
            }
            mutable.m_122173_(Direction.DOWN);
            state = this.m_73398_((BlockGetter)world, mutable.m_123341_(), mutable.m_123342_(), mutable.m_123343_(), box);
        }
        if (lavaBelow) {
            mutable = this.m_163582_(x, 0, z);
            if (!this.f_73383_.m_71051_((Vec3i)mutable)) {
                return false;
            }
            int realChainY = this.m_73544_(0);
            int length = 1;
            boolean canGenerateChain = true;
            while (canGenerateChain) {
                if (canGenerateChain) {
                    mutable.m_142448_(realChainY + length);
                    BlockState currBlock = world.m_8055_((BlockPos)mutable);
                    boolean currBlockCanBeReplaced = this.m_163572_(currBlock);
                    if (!currBlockCanBeReplaced && this.canHangChainBelow((LevelReader)world, (BlockPos)mutable, currBlock)) {
                        world.m_7731_((BlockPos)mutable.m_142448_(realChainY + 1), this.getSupportBlock(), 2);
                        MineshaftPiece.fillColumnBetween(world, Blocks.f_50184_.m_49966_(), mutable, realChainY + 2, realChainY + length);
                        return false;
                    }
                    canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.m_123342_() < world.m_151558_() - 1;
                }
                ++length;
            }
        } else {
            this.generateLeg(world, random, box, x, z, selector);
            return true;
        }
        return false;
    }

    protected void generatePillarDownOrChainUp(WorldGenLevel world, Random random, BoundingBox boundingBox, int x, int z, int pillarStartY, int chainStartY, BlockState chainBlock) {
        BlockPos.MutableBlockPos mutable = this.m_163582_(x, pillarStartY, z);
        if (!boundingBox.m_71051_((Vec3i)mutable)) {
            return;
        }
        int realPillarY = this.m_73544_(pillarStartY);
        int realChainY = this.m_73544_(chainStartY);
        int length = 1;
        boolean canGenerateLeg = true;
        boolean canGenerateChain = true;
        while (canGenerateLeg || canGenerateChain) {
            boolean currBlockCanBeReplaced;
            BlockState currBlock;
            if (canGenerateLeg) {
                mutable.m_142448_(realPillarY - length);
                currBlock = world.m_8055_((BlockPos)mutable);
                boolean bl = currBlockCanBeReplaced = this.m_163572_(currBlock) && !currBlock.m_60713_(Blocks.f_49991_);
                if (!currBlockCanBeReplaced && this.canPlaceColumnOnTopOf(currBlock)) {
                    MineshaftPiece.fillColumnBetween(world, this.getSmallLegBlock(), mutable, realPillarY - length + 1, realPillarY);
                    return;
                }
                boolean bl2 = canGenerateLeg = length <= 20 && currBlockCanBeReplaced && mutable.m_123342_() > world.m_141937_() + 1;
            }
            if (canGenerateChain) {
                mutable.m_142448_(realChainY + length);
                currBlock = world.m_8055_((BlockPos)mutable);
                currBlockCanBeReplaced = this.m_163572_(currBlock);
                if (!currBlockCanBeReplaced && this.canHangChainBelow((LevelReader)world, (BlockPos)mutable, currBlock)) {
                    world.m_7731_((BlockPos)mutable.m_142448_(realChainY + 1), chainBlock, 2);
                    MineshaftPiece.fillColumnBetween(world, Blocks.f_50184_.m_49966_(), mutable, realChainY + 2, realChainY + length);
                    return;
                }
                canGenerateChain = length <= 50 && currBlockCanBeReplaced && mutable.m_123342_() < world.m_151558_() - 1;
            }
            ++length;
        }
    }

    protected void generatePillarDownOrChainUp(WorldGenLevel world, Random random, BoundingBox boundingBox, int x, int y, int z) {
        this.generatePillarDownOrChainUp(world, random, boundingBox, x, z, y, y, this.getSupportBlock());
    }

    private boolean canPlaceColumnOnTopOf(BlockState blockState) {
        return !blockState.m_60713_(Blocks.f_50156_) && !blockState.m_60713_(Blocks.f_49991_);
    }

    private boolean canHangChainBelow(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return Block.m_49863_((LevelReader)levelReader, (BlockPos)blockPos, (Direction)Direction.DOWN) && !(blockState.m_60734_() instanceof FallingBlock);
    }

    protected boolean m_163572_(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60767_().m_76332_() || blockState.m_60713_(Blocks.f_152475_) || blockState.m_60713_(Blocks.f_50037_) || blockState.m_60713_(Blocks.f_50038_) || blockState.m_60713_(Blocks.f_152588_) || blockState.m_60713_(Blocks.f_152538_) || blockState.m_60713_(Blocks.f_152539_) || blockState.m_60713_(Blocks.f_152543_) || blockState.m_60713_(Blocks.f_50125_);
    }

    protected void fill(WorldGenLevel world, BoundingBox boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.m_73398_((BlockGetter)world, x, y, z, boundingBox) == Blocks.f_50184_.m_49966_()) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void fill(WorldGenLevel world, BoundingBox boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.m_73398_((BlockGetter)world, x, y, z, boundingBox) == Blocks.f_50184_.m_49966_()) continue;
                    this.m_73434_(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(WorldGenLevel world, BoundingBox boundingBox, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || !currState.m_60795_() && currState != Blocks.f_50184_.m_49966_()) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void replaceAirOrChains(WorldGenLevel world, BoundingBox boundingBox, Random random, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || !currState.m_60795_() && currState != Blocks.f_50184_.m_49966_()) continue;
                    this.m_73434_(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected static void fillColumnBetween(WorldGenLevel worldGenLevel, BlockState blockState, BlockPos.MutableBlockPos mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.m_7731_((BlockPos)mutableBlockPos.m_142448_(y), blockState, 2);
        }
    }

    protected static void fillColumnBetween(WorldGenLevel worldGenLevel, Random random, BlockSetSelector selector, BlockPos.MutableBlockPos mutableBlockPos, int minY, int maxY) {
        for (int y = minY; y < maxY; ++y) {
            worldGenLevel.m_7731_((BlockPos)mutableBlockPos.m_142448_(y), selector.get(random), 2);
        }
    }

    protected void chanceFill(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceFill(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!(random.nextFloat() < chance)) continue;
                    this.m_73434_(world, selector.get(random), x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceAir(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox)) == null || !currState.m_60795_()) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || currState == Blocks.f_50184_.m_49966_() || currState.m_60767_() != Material.f_76305_ && currState.m_60767_() != Material.f_76307_ && (!(random.nextFloat() < chance) || currState.m_60795_())) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceNonAir(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockSetSelector selector) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox);
                    if (currState == null || currState == Blocks.f_50184_.m_49966_() || currState.m_60767_() != Material.f_76305_ && currState.m_60767_() != Material.f_76307_ && (!(random.nextFloat() < chance) || currState.m_60795_())) continue;
                    BlockState blockState = selector.get(random);
                    if (currState.m_60767_() == Material.f_76305_ || currState.m_60767_() == Material.f_76307_) {
                        for (int numAttempts = 0; (blockState == Blocks.f_50016_.m_49966_() || blockState == Blocks.f_50627_.m_49966_()) && numAttempts < 10; ++numAttempts) {
                            blockState = selector.get(random);
                        }
                    }
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceReplaceSolid(WorldGenLevel world, BoundingBox boundingBox, Random random, float chance, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, BlockState blockState) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockState currState;
                    if (!(random.nextFloat() < chance) || (currState = this.getBlockAtFixed((BlockGetter)world, x, y, z, boundingBox)) == null || currState == Blocks.f_50184_.m_49966_() || NON_SOLID_MATERIALS.contains(currState.m_60767_())) continue;
                    this.m_73434_(world, blockState, x, y, z, boundingBox);
                }
            }
        }
    }

    protected void chanceAddBlock(WorldGenLevel world, Random random, float chance, BlockState block, int x, int y, int z, BoundingBox boundingBox) {
        if (random.nextFloat() < chance) {
            this.m_73434_(world, block, x, y, z, boundingBox);
        }
    }

    protected BlockState getBlockAtFixed(BlockGetter blockGetter, int x, int y, int z, BoundingBox boundingBox) {
        BlockPos.MutableBlockPos blockPos = this.m_163582_(x, y, z);
        return !boundingBox.m_71051_((Vec3i)blockPos) ? null : blockGetter.m_8055_((BlockPos)blockPos);
    }
}

