/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

@ParametersAreNonnullByDefault
public class OreDeposit
extends MineshaftPiece {
    private OreType oreType;
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 4;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 3;

    public OreDeposit(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.ORE_DEPOSIT, compoundTag);
        this.oreType = OreType.valueOf(compoundTag.m_128451_("OreType"));
    }

    public OreDeposit(int chunkPieceLen, Random random, BoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.ORE_DEPOSIT, chunkPieceLen, settings, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        compoundTag.m_128405_("OreType", this.oreType.value);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)4, (Direction)direction);
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        int r = random.nextInt(100);
        for (OreType oreType : OreType.values()) {
            if (r >= oreType.threshold) continue;
            this.oreType = oreType;
            break;
        }
        if (OreType.DIAMOND.threshold != 100) {
            BetterMineshafts.LOGGER.error("Your ore spawn chances don't add up to 100! Ores won't spawn as you intend!");
        }
        if (this.oreType == null) {
            this.oreType = OreType.COBBLE;
        }
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockState COBBLE = Blocks.f_50652_.m_49966_();
        BlockState ORE_BLOCK = this.oreType.getBlock();
        this.chanceReplaceSolid(world, box, random, 0.9f, 0, 0, 0, 4, 4, 3, COBBLE);
        this.chanceReplaceSolid(world, box, random, 0.65f, 1, 1, 1, 3, 3, 2, ORE_BLOCK);
        this.chanceReplaceSolid(world, box, random, 0.15f, 0, 0, 0, 4, 4, 3, ORE_BLOCK);
    }

    public static enum OreType {
        COBBLE(0, Blocks.f_50652_.m_49966_(), (Integer)BMConfig.ores.cobble.get()),
        COAL(1, Blocks.f_49997_.m_49966_(), (Integer)BMConfig.ores.coal.get() + OreType.COBBLE.threshold),
        IRON(2, Blocks.f_49996_.m_49966_(), (Integer)BMConfig.ores.iron.get() + OreType.COAL.threshold),
        REDSTONE(3, Blocks.f_50173_.m_49966_(), (Integer)BMConfig.ores.redstone.get() + OreType.IRON.threshold),
        GOLD(4, Blocks.f_49995_.m_49966_(), (Integer)BMConfig.ores.gold.get() + OreType.REDSTONE.threshold),
        LAPIS(5, Blocks.f_50059_.m_49966_(), (Integer)BMConfig.ores.lapis.get() + OreType.GOLD.threshold),
        EMERALD(6, Blocks.f_50264_.m_49966_(), (Integer)BMConfig.ores.emerald.get() + OreType.LAPIS.threshold),
        DIAMOND(7, Blocks.f_50089_.m_49966_(), (Integer)BMConfig.ores.diamond.get() + OreType.EMERALD.threshold);

        private final int value;
        private final BlockState block;
        private final int threshold;

        private OreType(int value, BlockState block, int threshold) {
            this.value = value;
            this.block = block;
            this.threshold = threshold;
        }

        public static OreType valueOf(int value) {
            return Arrays.stream(OreType.values()).filter(oreType -> oreType.value == value).findFirst().get();
        }

        public BlockState getBlock() {
            return this.block;
        }
    }
}

