/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.mixin.BoundingBoxAccessor;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariantSettings;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

@ParametersAreNonnullByDefault
public class SideRoomDungeon
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 4;
    private static final int MAIN_AXIS_LEN = 9;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 3;
    private static final int LOCAL_Z_END = 8;

    public SideRoomDungeon(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM_DUNGEON, compoundTag);
    }

    public SideRoomDungeon(int pieceChainLen, Random random, BoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.SIDE_ROOM_DUNGEON, pieceChainLen, settings, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = new BoundingBox(x, y, z, x, y + 4 - 1, z);
        switch (direction) {
            default: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 4);
                ((BoundingBoxAccessor)blockBox).setMinX(x - 4);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 8);
                break;
            }
            case SOUTH: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 4);
                ((BoundingBoxAccessor)blockBox).setMinX(x - 4);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 8);
                break;
            }
            case WEST: {
                ((BoundingBoxAccessor)blockBox).setMinX(x - 8);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 4);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 4);
                break;
            }
            case EAST: {
                ((BoundingBoxAccessor)blockBox).setMaxX(x + 8);
                ((BoundingBoxAccessor)blockBox).setMaxZ(z + 4);
                ((BoundingBoxAccessor)blockBox).setMinZ(z - 4);
            }
        }
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.fill(world, box, random, 0, 0, 0, 8, 3, 8, this.getBrickSelector());
        this.fill(world, box, 1, 1, 1, 7, 2, 7, AIR);
        this.generateLegs(world, random, box);
        BlockState LADDER = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.NORTH);
        this.fill(world, box, 4, 1, 1, 4, 3, 1, LADDER);
        BlockPos.MutableBlockPos spawnerPos = this.m_163582_(4, 1, 5);
        world.m_7731_((BlockPos)spawnerPos, Blocks.f_50085_.m_49966_(), 2);
        BlockEntity blockEntity = world.m_7702_((BlockPos)spawnerPos);
        if (blockEntity instanceof SpawnerBlockEntity) {
            ((SpawnerBlockEntity)blockEntity).m_59801_().m_45462_(EntityType.f_20554_);
        }
        this.chanceReplaceAir(world, box, random, 0.9f, 3, 1, 4, 5, 2, 6, Blocks.f_50033_.m_49966_());
        this.chanceReplaceAir(world, box, random, 0.1f, 1, 1, 1, 7, 2, 8, Blocks.f_50033_.m_49966_());
        this.m_5606_(world, box, random, 1, 1, 7, BuiltInLootTables.f_78759_);
        if (random.nextInt(2) == 0) {
            this.m_5606_(world, box, random, 7, 1, 7, BuiltInLootTables.f_78759_);
        }
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 8, 2, 8);
    }

    private void generateLegs(WorldGenLevel world, Random random, BoundingBox box) {
        this.generateLeg(world, random, box, 1, 1, this.getBrickSelector());
        this.generateLeg(world, random, box, 1, 7, this.getBrickSelector());
        this.generateLeg(world, random, box, 7, 1, this.getBrickSelector());
        this.generateLeg(world, random, box, 7, 7, this.getBrickSelector());
    }
}

