/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.config.BMConfig;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.bettermineshafts.world.variant.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

@ParametersAreNonnullByDefault
public class SmallTunnel
extends MineshaftPiece {
    private final List<Integer> supports = new ArrayList<Integer>();
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 8;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 7;

    public SmallTunnel(CompoundTag compoundTag) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL, compoundTag);
        ListTag listTag1 = compoundTag.m_128437_("Supports", 3);
        for (int i = 0; i < listTag1.size(); ++i) {
            this.supports.add(listTag1.m_128763_(i));
        }
    }

    public SmallTunnel(int chunkPieceLen, Random random, BoundingBox blockBox, Direction direction, MineshaftVariantSettings settings) {
        super(BetterMineshaftStructurePieceType.SMALL_TUNNEL, chunkPieceLen, settings, blockBox);
        this.m_73519_(direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        super.m_183620_(structurePieceSerializationContext, compoundTag);
        ListTag listTag1 = new ListTag();
        this.supports.forEach(z -> listTag1.add((Object)IntTag.m_128679_((int)z)));
        compoundTag.m_128365_("Supports", (Tag)listTag1);
    }

    public static BoundingBox determineBoxPosition(StructurePieceAccessor structurePieceAccessor, Random random, int x, int y, int z, Direction direction) {
        BoundingBox blockBox = BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)5, (int)5, (int)8, (Direction)direction);
        StructurePiece intersectingPiece = structurePieceAccessor.m_141921_(blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void m_142537_(StructurePiece structurePiece, StructurePieceAccessor structurePieceAccessor, Random random) {
        Direction direction = this.m_73549_();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_() - 1, direction, this.f_73384_);
                break;
            }
            case SOUTH: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_(), this.f_73383_.m_162396_(), this.f_73383_.m_162401_() + 1, direction, this.f_73384_);
                break;
            }
            case WEST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162395_() - 1, this.f_73383_.m_162396_(), this.f_73383_.m_162401_(), direction, this.f_73384_);
                break;
            }
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, structurePieceAccessor, random, this.f_73383_.m_162399_() + 1, this.f_73383_.m_162396_(), this.f_73383_.m_162398_(), direction, this.f_73384_);
            }
        }
        this.buildSupports(random);
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager structureFeatureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 4, 4, 7, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 7, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 3, 3, 7, AIR);
        this.replaceAirOrChains(world, box, 1, 0, 0, 3, 0, 7, this.getMainBlock());
        this.generateSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateChestCarts(world, box, random);
        this.generateTntCarts(world, box, random);
        this.addVines(world, box, random, this.settings.vineChance, 1, 0, 1, 3, 4, 6);
        this.addBiomeDecorations(world, box, random, 1, 0, 0, 3, 3, 6);
        this.generateTorches(world, box, random);
        this.generatePillarsOrChains(world, box, random);
        this.replaceExistingChainsWithChainBlock(world, box);
    }

    private void generateChestCarts(WorldGenLevel world, BoundingBox box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos.MutableBlockPos blockPos;
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.smallShaftChestMinecartSpawnRate.get()) || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(2, 1, z))) || world.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
            MinecartChest chestMinecartEntity = new MinecartChest((Level)world.m_6018_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
            chestMinecartEntity.m_38236_(BuiltInLootTables.f_78759_, random.nextLong());
            world.m_7967_((Entity)chestMinecartEntity);
        }
    }

    private void generateSupports(WorldGenLevel world, BoundingBox box, Random random) {
        float cobwebChance = ((Double)BMConfig.spawnRates.cobwebSpawnRate.get()).floatValue();
        BlockState supportBlock = this.getSupportBlock();
        if (supportBlock.m_61147_().contains(BlockStateProperties.f_61378_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61381_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.TALL)).m_61124_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.TALL);
        } else if (supportBlock.m_61147_().contains(BlockStateProperties.f_61369_) && supportBlock.m_61147_().contains(BlockStateProperties.f_61371_)) {
            supportBlock = (BlockState)((BlockState)supportBlock.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.supports) {
            int numCovered = 0;
            for (int x = 1; x <= 3; ++x) {
                BlockState blockState = this.m_73398_((BlockGetter)world, x, 4, z, box);
                if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50184_)) continue;
                ++numCovered;
            }
            if (numCovered < 2) continue;
            this.fill(world, box, 1, 1, z, 1, 2, z, this.getSupportBlock());
            this.fill(world, box, 3, 1, z, 3, 2, z, this.getSupportBlock());
            this.fill(world, box, 1, 3, z, 3, 3, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.25f, 1, 3, z, 3, 3, z, supportBlock);
            this.chanceReplaceAir(world, box, random, cobwebChance, 1, 3, z - 1, 1, 3, z + 1, Blocks.f_50033_.m_49966_());
            this.chanceReplaceAir(world, box, random, cobwebChance, 3, 3, z - 1, 3, 3, z + 1, Blocks.f_50033_.m_49966_());
        }
    }

    private void generateRails(WorldGenLevel world, BoundingBox box, Random random) {
        this.chanceFill(world, box, random, 0.5f, 2, 1, 0, 2, 1, 7, Blocks.f_50156_.m_49966_());
        for (int n = 0; n <= 7; ++n) {
            this.chanceAddBlock(world, random, 0.07f, (BlockState)Blocks.f_50030_.m_49966_().m_61124_((Property)PoweredRailBlock.f_55215_, (Comparable)Boolean.valueOf(true)), 2, 1, n, box);
        }
    }

    private void generateTntCarts(WorldGenLevel world, BoundingBox box, Random random) {
        for (int z = 0; z <= 7; ++z) {
            BlockPos.MutableBlockPos blockPos;
            if (!((double)random.nextFloat() < (Double)BMConfig.spawnRates.smallShaftTntMinecartSpawnRate.get()) || !box.m_71051_((Vec3i)(blockPos = this.m_163582_(2, 1, z))) || world.m_8055_(blockPos.m_7495_()).m_60795_()) continue;
            MinecartTNT tntMinecartEntity = new MinecartTNT((Level)world.m_6018_(), (double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
            world.m_7967_((Entity)tntMinecartEntity);
        }
    }

    private void generateTorches(WorldGenLevel world, BoundingBox box, Random random) {
        BlockState torchBlock = Blocks.f_50082_.m_49966_();
        for (int z = 0; z <= 7; ++z) {
            boolean canPlace;
            BlockPos.MutableBlockPos adjPos;
            BlockPos.MutableBlockPos pos;
            if (this.supports.contains(z)) continue;
            float r = random.nextFloat();
            if ((double)r < (Double)BMConfig.spawnRates.torchSpawnRate.get() / 2.0) {
                pos = this.m_163582_(1, 2, z);
                adjPos = this.m_163582_(0, 2, z);
                boolean bl = canPlace = world.m_8055_((BlockPos)pos).m_60795_() && world.m_8055_((BlockPos)adjPos) != AIR;
                if (!canPlace) continue;
                this.replaceAirOrChains(world, box, 1, 2, z, 1, 2, z, (BlockState)torchBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.EAST));
                continue;
            }
            if (!((double)r < (Double)BMConfig.spawnRates.torchSpawnRate.get())) continue;
            pos = this.m_163582_(3, 2, z);
            adjPos = this.m_163582_(4, 2, z);
            boolean bl = canPlace = world.m_8055_((BlockPos)pos).m_60795_() && world.m_8055_((BlockPos)adjPos) != AIR;
            if (!canPlace) continue;
            this.replaceAirOrChains(world, box, 3, 2, z, 3, 2, z, (BlockState)torchBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.WEST));
        }
    }

    private void generatePillarsOrChains(WorldGenLevel world, BoundingBox box, Random random) {
        this.generatePillarDownOrChainUp(world, random, box, 1, 0, 1);
        this.generatePillarDownOrChainUp(world, random, box, 3, 0, 1);
        this.generatePillarDownOrChainUp(world, random, box, 1, 0, 6);
        this.generatePillarDownOrChainUp(world, random, box, 3, 0, 6);
    }

    private void replaceExistingChainsWithChainBlock(WorldGenLevel world, BoundingBox box) {
        for (int x = 0; x <= 4; ++x) {
            for (int z = 0; z <= 7; ++z) {
                if (!this.m_73398_((BlockGetter)world, x, 1, z, box).m_60713_(Blocks.f_50184_)) continue;
                this.m_73434_(world, this.getSupportBlock(), x, 1, z, box);
            }
        }
    }

    private void buildSupports(Random random) {
        for (int z = 0; z <= 7; ++z) {
            int r = random.nextInt(7);
            if (r != 0) continue;
            this.supports.add(z);
            z += 5;
        }
    }
}

