/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import mcp.mobius.waila.addons.core.CorePlugin;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.config.WailaConfig;
import mcp.mobius.waila.impl.ui.ArmorElement;
import mcp.mobius.waila.impl.ui.HealthElement;
import mcp.mobius.waila.overlay.DisplayHelper;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BaseEntityProvider
implements IEntityComponentProvider {
    static final IEntityComponentProvider INSTANCE = new BaseEntityProvider();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        TooltipPosition position = accessor.getTooltipPosition();
        if (position == TooltipPosition.HEAD) {
            this.appendHead(tooltip, accessor, config);
        } else if (position == TooltipPosition.BODY) {
            this.appendBody(tooltip, accessor, config);
        } else if (position == TooltipPosition.TAIL) {
            this.appendTail(tooltip, accessor, config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHead(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        String name = BaseEntityProvider.getEntityName(accessor.getEntity());
        WailaConfig wailaConfig = config.getWailaConfig();
        tooltip.add((Component)new TextComponent(String.format(wailaConfig.getFormatting().getEntityName(), name)).m_130948_(wailaConfig.getOverlay().getColor().getTitle()), CorePlugin.TAG_OBJECT_NAME);
        if (config.get(CorePlugin.CONFIG_REGISTRY_NAME)) {
            tooltip.add((Component)new TextComponent(accessor.getEntity().m_6095_().getRegistryName().toString()).m_130940_(ChatFormatting.GRAY), CorePlugin.TAG_REGISTRY_NAME);
        }
    }

    public static String getEntityName(Entity entity) {
        if (!entity.m_8077_()) {
            if (entity instanceof Villager) {
                return entity.m_6095_().m_20676_().getString();
            }
            if (entity instanceof ItemEntity) {
                return ((ItemEntity)entity).m_32055_().m_41786_().getString();
            }
        }
        return entity.m_7755_().getString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendBody(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!(accessor.getEntity() instanceof LivingEntity)) {
            return;
        }
        WailaConfig wailaConfig = config.getWailaConfig();
        if (config.get(CorePlugin.CONFIG_ENTITY_ARMOR)) {
            this.appendArmor((LivingEntity)accessor.getEntity(), tooltip, wailaConfig);
        }
        if (config.get(CorePlugin.CONFIG_ENTITY_HEALTH)) {
            this.appendHealth((LivingEntity)accessor.getEntity(), tooltip, wailaConfig);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendTail(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!config.get(CorePlugin.CONFIG_MOD_NAME)) {
            return;
        }
        tooltip.add((Component)new TextComponent(String.format(config.getWailaConfig().getFormatting().getModName(), ModIdentification.getModName(accessor.getEntity()))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void appendHealth(LivingEntity living, ITooltip tooltip, WailaConfig config) {
        float health = living.m_21223_();
        float maxHealth = living.m_21233_();
        if (living.m_21233_() > (float)config.getGeneral().getMaxHealthForRender()) {
            HealthElement icon = new HealthElement(1.0f, 1.0f);
            TextComponent text = new TextComponent(String.format("  %s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth)));
            tooltip.add(0, icon);
            tooltip.append(0, tooltip.getElementHelper().text((Component)text));
        } else {
            tooltip.add(0, new HealthElement(maxHealth * 0.5f, health * 0.5f));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void appendArmor(LivingEntity living, ITooltip tooltip, WailaConfig config) {
        float armor = living.m_21230_();
        if (armor == 0.0f) {
            return;
        }
        if (armor > (float)config.getGeneral().getMaxHealthForRender()) {
            ArmorElement icon = new ArmorElement(-1.0f);
            TextComponent text = new TextComponent(DisplayHelper.dfCommas.format(armor));
            tooltip.add(0, icon);
            tooltip.append(0, tooltip.getElementHelper().text((Component)text));
        } else {
            tooltip.add(0, new ArmorElement(armor * 0.5f));
        }
    }
}

