/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.impl.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.ui.Element;
import mcp.mobius.waila.impl.Tooltip;
import mcp.mobius.waila.impl.ui.BorderStyle;
import mcp.mobius.waila.overlay.DisplayHelper;
import mcp.mobius.waila.overlay.TooltipRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BoxElement
extends Element {
    private final TooltipRenderer tooltip;
    @Nullable
    private final BorderStyle border;

    public BoxElement(Tooltip tooltip, BorderStyle border) {
        this.tooltip = new TooltipRenderer(tooltip, false);
        this.border = border;
    }

    @Override
    public Vec2 getSize() {
        if (this.tooltip.getTooltip().isEmpty()) {
            return Vec2.f_82462_;
        }
        Vec2 size = this.tooltip.getSize();
        return new Vec2(size.f_82470_ + 2.0f, size.f_82471_ + 4.0f);
    }

    @Override
    public void render(PoseStack matrixStack, float x, float y, float maxX, float maxY) {
        if (this.tooltip.getTooltip().isEmpty()) {
            return;
        }
        Rect2i rect = this.tooltip.getPosition();
        RenderSystem.m_69478_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)x, (double)y, 0.0);
        if (this.border != null) {
            DisplayHelper.INSTANCE.drawBorder(matrixStack, 0.0f, 0.0f, rect.m_110090_(), rect.m_110091_(), this.border);
        }
        this.tooltip.draw(matrixStack);
        matrixStack.m_85849_();
    }
}

