/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class DatapackBlockManager {
    private static final Set<BlockPos> itemFrames = Sets.newConcurrentHashSet();

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_() == EntityType.f_20462_ || entity.m_6095_() == EntityType.f_147033_) {
            itemFrames.add(entity.m_142538_());
        }
    }

    @SubscribeEvent
    public static void onEntityLeave(EntityLeaveWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.m_6095_() == EntityType.f_20462_ || entity.m_6095_() == EntityType.f_147033_) {
            BlockPos pos = entity.m_142538_();
            DatapackBlockManager.getFakeBlock(event.getWorld(), pos);
        } else if (entity == Minecraft.m_91087_().f_91074_) {
            itemFrames.clear();
        }
    }

    public static ItemStack getFakeBlock(Level level, BlockPos pos) {
        if (itemFrames.contains(pos)) {
            List entities = level.m_6443_(ItemFrame.class, new AABB(pos), $ -> $.m_20145_() && $.m_6084_());
            if (entities.isEmpty()) {
                itemFrames.remove(pos);
            } else {
                ItemStack stack = ((ItemFrame)entities.get(0)).m_31822_();
                if (stack.m_41782_() && stack.m_41783_().m_128441_("storedItem")) {
                    stack = ItemStack.m_41712_((CompoundTag)stack.m_41737_("storedItem"));
                }
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }
}

