/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.ClientEventHandler;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.capability.ChampionCapability;

public class HUDHelper {
    private static final ResourceLocation GUI_BAR_TEXTURES = new ResourceLocation("textures/gui/bars.png");
    private static final ResourceLocation GUI_STAR = new ResourceLocation("champions", "textures/gui/staricon.png");

    public static boolean renderHealthBar(PoseStack matrixStack, LivingEntity livingEntity) {
        return ChampionCapability.getCapability(livingEntity).map(champion -> {
            IChampion.Client clientChampion = champion.getClient();
            return clientChampion.getRank().map(rank -> {
                int num = (Integer)rank.m_14418_();
                Set affixSet = clientChampion.getAffixes().stream().map(IAffix::getIdentifier).collect(Collectors.toSet());
                if (num > 0 || affixSet.size() > 0) {
                    Object name;
                    Minecraft client = Minecraft.m_91087_();
                    int i = client.m_91268_().m_85445_();
                    int k = i / 2 - 91;
                    int j = 21;
                    int xOffset = ClientChampionsConfig.hudXOffset;
                    int yOffset = ClientChampionsConfig.hudYOffset;
                    int color = (Integer)rank.m_14419_();
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    RenderSystem.m_69453_();
                    RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
                    RenderSystem.m_69478_();
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_BAR_TEXTURES);
                    ClientEventHandler.startX = xOffset + k;
                    ClientEventHandler.startY = yOffset + 1;
                    GuiComponent.m_93133_((PoseStack)matrixStack, (int)(xOffset + k), (int)(yOffset + j), (float)0.0f, (float)60.0f, (int)182, (int)5, (int)256, (int)256);
                    int healthOffset = (int)(livingEntity.m_21223_() / livingEntity.m_21233_() * 183.0f);
                    if (healthOffset > 0) {
                        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(xOffset + k), (int)(yOffset + j), (float)0.0f, (float)65.0f, (int)healthOffset, (int)5, (int)256, (int)256);
                    }
                    RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_STAR);
                    if (num <= 18) {
                        startStarsX = xOffset + i / 2 - 5 - 5 * (num - 1);
                        for (int tier = 0; tier < num; ++tier) {
                            GuiComponent.m_93133_((PoseStack)matrixStack, (int)startStarsX, (int)(yOffset + 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                            startStarsX += 10;
                        }
                    } else {
                        startStarsX = xOffset + i / 2 - 5;
                        String count = "x" + num;
                        GuiComponent.m_93133_((PoseStack)matrixStack, (int)(startStarsX - client.f_91062_.m_92895_(count) / 2), (int)(yOffset + 1), (float)0.0f, (float)0.0f, (int)9, (int)9, (int)9, (int)9);
                        client.f_91062_.m_92750_(matrixStack, count, (float)(startStarsX + 10) - (float)client.f_91062_.m_92895_(count) / 2.0f, (float)(yOffset + 2), 0xFFFFFF);
                    }
                    Component customName = livingEntity.m_7770_();
                    if (customName == null) {
                        name = new TranslatableComponent("rank.champions.title." + num).getString();
                        name = (String)name + " " + livingEntity.m_7755_().getString();
                    } else {
                        name = customName.getString();
                    }
                    client.f_91062_.m_92750_(matrixStack, (String)name, (float)xOffset + (float)(i / 2 - client.f_91062_.m_92895_((String)name) / 2), (float)yOffset + (float)(j - 9), color);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    StringBuilder builder = new StringBuilder();
                    for (String affix : affixSet) {
                        builder.append(new TranslatableComponent("affix.champions." + affix).getString());
                        builder.append(" ");
                    }
                    String affixes = builder.toString().trim();
                    client.f_91062_.m_92750_(matrixStack, affixes, (float)xOffset + (float)(i / 2 - client.f_91062_.m_92895_(affixes) / 2), (float)yOffset + (float)(j + 6), 0xFFFFFF);
                    RenderSystem.m_69461_();
                    return true;
                }
                return false;
            }).orElse(false);
        }).orElse(false);
    }
}

