/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.arguments.selector.options.EntitySelectorOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.rank.Rank;

public class ChampionSelectorOptions {
    public static void setup() {
        EntitySelectorOptions.m_121453_((String)"champions", ChampionSelectorOptions::championsArgument, entitySelectorParser -> true, (Component)new TranslatableComponent("argument.entity.options.champions.description"));
    }

    private static void championsArgument(EntitySelectorParser parser) throws CommandSyntaxException {
        StringReader reader = parser.m_121346_();
        boolean invert = parser.m_121330_();
        CompoundTag compoundtag = new TagParser(reader).m_129373_();
        HashSet<String> affixes = new HashSet<String>();
        MinMaxBounds.Ints matches = MinMaxBounds.Ints.m_55386_((int)1);
        MinMaxBounds.Ints count = MinMaxBounds.Ints.f_55364_;
        if (compoundtag.m_128425_("affixes", 9)) {
            ListTag listTag = compoundtag.m_128437_("affixes", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                affixes.add(listTag.m_128778_(i));
            }
        } else if (compoundtag.m_128425_("affixes", 10)) {
            CompoundTag tag = compoundtag.m_128469_("affixes");
            ListTag listTag = tag.m_128437_("values", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                affixes.add(listTag.m_128778_(i));
            }
            count = ChampionSelectorOptions.fromTag(tag, "count", count);
            matches = ChampionSelectorOptions.fromTag(tag, "matches", matches);
        }
        MinMaxBounds.Ints tier = ChampionSelectorOptions.fromTag(compoundtag, "tier", MinMaxBounds.Ints.f_55364_);
        MinMaxBounds.Ints finalCount = count;
        MinMaxBounds.Ints finalMatches = matches;
        parser.m_121272_(entity -> {
            boolean flag = ChampionSelectorOptions.matches(entity, affixes, tier, finalCount, finalMatches);
            return invert != flag;
        });
    }

    private static MinMaxBounds.Ints fromTag(CompoundTag origin, String key, MinMaxBounds.Ints defaultValue) {
        if (origin.m_128425_(key, 3)) {
            int tier = origin.m_128451_(key);
            return MinMaxBounds.Ints.m_55371_((int)tier);
        }
        if (origin.m_128425_(key, 10)) {
            CompoundTag tag = origin.m_128469_(key);
            Integer min = null;
            Integer max = null;
            if (tag.m_128425_("min", 3)) {
                min = tag.m_128451_("min");
            }
            if (tag.m_128425_("max", 3)) {
                max = tag.m_128451_("max");
            }
            if (min == null && max == null) {
                return MinMaxBounds.Ints.f_55364_;
            }
            if (min != null && max == null) {
                return MinMaxBounds.Ints.m_55386_((int)min);
            }
            if (min == null) {
                return MinMaxBounds.Ints.m_154819_((int)max);
            }
            return MinMaxBounds.Ints.m_154814_((int)min, (int)max);
        }
        return defaultValue;
    }

    private static boolean matches(Entity entity, Set<String> affixes, MinMaxBounds.Ints tier, MinMaxBounds.Ints count, MinMaxBounds.Ints matches) {
        return ChampionCapability.getCapability(entity).map(champion -> {
            IChampion.Server server = champion.getServer();
            int championTier = server.getRank().map(Rank::getTier).orElse(0);
            if (championTier <= 0 || !tier.m_55390_(championTier)) {
                return false;
            }
            List<IAffix> championAffixes = server.getAffixes();
            if (affixes.isEmpty()) {
                return count.m_55390_(championAffixes.size());
            }
            Set ids = championAffixes.stream().map(IAffix::getIdentifier).collect(Collectors.toSet());
            int found = 0;
            for (String affix : affixes) {
                if (!ids.contains(affix)) continue;
                ++found;
            }
            return matches.m_55390_(found) && count.m_55390_(championAffixes.size());
        }).orElse(false);
    }
}

