/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.container;

import ironfurnaces.container.SlotIronFurnace;
import ironfurnaces.container.SlotIronFurnaceAugment;
import ironfurnaces.container.SlotIronFurnaceFuel;
import ironfurnaces.tileentity.BlockIronFurnaceTileBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class BlockIronFurnaceContainerBase
extends AbstractContainerMenu {
    protected BlockIronFurnaceTileBase te;
    protected ContainerData fields;
    protected Player playerEntity;
    protected IItemHandler playerInventory;
    protected final Level world;
    private RecipeType<? extends AbstractCookingRecipe> recipeType;

    public BlockIronFurnaceContainerBase(MenuType<?> containerType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        this(containerType, windowId, world, pos, playerInventory, player, (ContainerData)new SimpleContainerData(5));
    }

    public BlockIronFurnaceContainerBase(MenuType<?> containerType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player, ContainerData fields) {
        super(containerType, windowId);
        this.te = (BlockIronFurnaceTileBase)world.m_7702_(pos);
        this.recipeType = this.te.recipeType;
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.world = playerInventory.f_35978_.f_19853_;
        this.fields = fields;
        this.m_38884_(this.fields);
        this.m_38897_(new Slot((Container)this.te, 0, 56, 17));
        this.m_38897_(new SlotIronFurnaceFuel(this.te, 1, 56, 53));
        this.m_38897_(new SlotIronFurnace(this.playerEntity, this.te, 2, 116, 35));
        this.m_38897_(new SlotIronFurnaceAugment(this.te, 3, 26, 35));
        this.layoutPlayerInventorySlots(8, 84);
        BlockIronFurnaceContainerBase.m_38869_((Container)this.te, (int)4);
        BlockIronFurnaceContainerBase.m_38886_((ContainerData)this.fields, (int)5);
    }

    public boolean m_6875_(Player player) {
        return this.te.m_6542_(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean showInventoryButtons() {
        return this.te.fields.m_6413_(4) == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getRedstoneMode() {
        return this.te.getRedstoneSetting();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getComSub() {
        return this.te.getRedstoneComSub();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getAutoInput() {
        return this.te.getAutoInput() == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean getAutoOutput() {
        return this.te.getAutoOutput() == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getTooltip(int index) {
        switch (this.te.furnaceSettings.get(index)) {
            case 1: {
                return new TranslatableComponent("tooltip.ironfurnaces.gui_input");
            }
            case 2: {
                return new TranslatableComponent("tooltip.ironfurnaces.gui_output");
            }
            case 3: {
                return new TranslatableComponent("tooltip.ironfurnaces.gui_input_output");
            }
            case 4: {
                return new TranslatableComponent("tooltip.ironfurnaces.gui_fuel");
            }
        }
        return new TranslatableComponent("tooltip.ironfurnaces.gui_none");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingTop() {
        return this.te.getSettingTop();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingBottom() {
        return this.te.getSettingBottom();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingFront() {
        return this.te.getSettingFront();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingBack() {
        return this.te.getSettingBack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingLeft() {
        return this.te.getSettingLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSettingRight() {
        return this.te.getSettingRight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexFront() {
        return this.te.getIndexFront();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexBack() {
        return this.te.getIndexBack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexLeft() {
        return this.te.getIndexLeft();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIndexRight() {
        return this.te.getIndexRight();
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos getPos() {
        return this.te.m_58899_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.te.isBurning();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookScaled(int pixels) {
        int i = this.fields.m_6413_(2);
        int j = this.fields.m_6413_(3);
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled(int pixels) {
        int i = this.fields.m_6413_(1);
        if (i == 0) {
            i = 200;
        }
        return this.fields.m_6413_(0) * pixels / i;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(itemstack1, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index != 1 && index != 0 && index != 3 ? (this.te.hasRecipe(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : (BlockIronFurnaceTileBase.isItemFuel(itemstack1) ? !this.m_38903_(itemstack1, 1, 2, false) : (BlockIronFurnaceTileBase.isItemAugment(itemstack1) ? !this.m_38903_(itemstack1, 3, 4, false) : (index >= 4 && index < 31 ? !this.m_38903_(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.m_38903_(itemstack1, 4, 31, false))))) : !this.m_38903_(itemstack1, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }
}

