/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.tileentity;

import com.google.common.collect.Lists;
import com.mojang.math.Vector3d;
import harmonised.pmmo.events.FurnaceHandler;
import ironfurnaces.Config;
import ironfurnaces.blocks.BlockIronFurnaceBase;
import ironfurnaces.init.Registration;
import ironfurnaces.items.ItemAugment;
import ironfurnaces.items.ItemAugmentBlasting;
import ironfurnaces.items.ItemAugmentFuel;
import ironfurnaces.items.ItemAugmentSmoking;
import ironfurnaces.items.ItemAugmentSpeed;
import ironfurnaces.items.ItemHeater;
import ironfurnaces.tileentity.BlockWirelessEnergyHeaterTile;
import ironfurnaces.tileentity.FurnaceSettings;
import ironfurnaces.tileentity.LRUCache;
import ironfurnaces.tileentity.TileEntityInventory;
import ironfurnaces.util.DirectionUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class BlockIronFurnaceTileBase
extends TileEntityInventory
implements RecipeHolder,
StackedContentsCompatible {
    public final int[] provides = new int[Direction.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    public static final int INPUT = 0;
    public static final int FUEL = 1;
    public static final int OUTPUT = 2;
    protected AbstractCookingRecipe curRecipe;
    private Random rand = new Random();
    public int show_inventory_settings;
    private int jovial;
    protected int timer;
    private int currentAugment;
    private int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime = this.getCookTime();
    private int recipesUsed;
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    public RecipeType<? extends AbstractCookingRecipe> recipeType;
    public FurnaceSettings furnaceSettings;
    private LRUCache<Item, Optional<AbstractCookingRecipe>> cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    private LRUCache<Item, Optional<AbstractCookingRecipe>> blasting_cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    private LRUCache<Item, Optional<AbstractCookingRecipe>> smoking_cache = LRUCache.newInstance((Integer)Config.cache_capacity.get());
    public final ContainerData fields = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return BlockIronFurnaceTileBase.this.furnaceBurnTime;
                }
                case 1: {
                    return BlockIronFurnaceTileBase.this.recipesUsed;
                }
                case 2: {
                    return BlockIronFurnaceTileBase.this.cookTime;
                }
                case 3: {
                    return BlockIronFurnaceTileBase.this.totalCookTime;
                }
                case 4: {
                    return BlockIronFurnaceTileBase.this.show_inventory_settings;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BlockIronFurnaceTileBase.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    BlockIronFurnaceTileBase.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    BlockIronFurnaceTileBase.this.cookTime = value;
                    break;
                }
                case 3: {
                    BlockIronFurnaceTileBase.this.totalCookTime = value;
                    break;
                }
                case 4: {
                    BlockIronFurnaceTileBase.this.show_inventory_settings = value;
                }
            }
        }

        public int m_6499_() {
            return 5;
        }
    };
    LazyOptional<? extends IItemHandler>[] invHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST});

    public BlockIronFurnaceTileBase(BlockEntityType<?> tileentitytypeIn, BlockPos pos, BlockState state) {
        super(tileentitytypeIn, pos, state, 4);
        this.recipeType = RecipeType.f_44108_;
        this.furnaceSettings = new FurnaceSettings(){

            @Override
            public void onChanged() {
                BlockIronFurnaceTileBase.this.m_6596_();
            }
        };
    }

    public boolean hasRecipe(ItemStack stack) {
        return this.grabRecipe(stack).isPresent();
    }

    private Optional<AbstractCookingRecipe> getRecipe(Item item) {
        return item instanceof AirItem ? Optional.empty() : Optional.ofNullable(this.f_58857_.m_7465_().m_44015_(this.recipeType, (Container)this, this.f_58857_).orElse(null));
    }

    private Optional<AbstractCookingRecipe> grabRecipe() {
        Item item = this.m_8020_(0).m_41720_();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional recipe = (Optional)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.f_58857_.m_7465_().m_44015_(this.recipeType, (Container)this, this.f_58857_);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    private Optional<AbstractCookingRecipe> grabRecipe(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof AirItem) {
            return Optional.empty();
        }
        Optional recipe = (Optional)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.f_58857_.m_7465_().m_44015_(this.recipeType, (Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    private LRUCache<Item, Optional<AbstractCookingRecipe>> getCache() {
        ItemStack stack = this.m_8020_(3);
        if (stack.m_41720_() instanceof ItemAugmentBlasting && this.recipeType != RecipeType.f_44109_) {
            this.recipeType = RecipeType.f_44109_;
        }
        if (stack.m_41720_() instanceof ItemAugmentSmoking && this.recipeType != RecipeType.f_44110_) {
            this.recipeType = RecipeType.f_44110_;
        }
        if (!(stack.m_41720_() instanceof ItemAugmentSmoking) && !(stack.m_41720_() instanceof ItemAugmentBlasting) && this.recipeType != RecipeType.f_44108_) {
            this.recipeType = RecipeType.f_44108_;
        }
        if (this.recipeType == RecipeType.f_44109_) {
            return this.blasting_cache;
        }
        if (this.recipeType == RecipeType.f_44110_) {
            return this.smoking_cache;
        }
        return this.cache;
    }

    protected int getCookTime() {
        ItemStack stack = this.m_8020_(3);
        if (this.m_8020_(0).m_41720_() == Items.f_41852_) {
            return this.totalCookTime;
        }
        int speed = this.getSpeed();
        if (speed == -1) {
            return -1;
        }
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof ItemAugmentSpeed || stack.m_41720_() instanceof ItemAugmentBlasting || stack.m_41720_() instanceof ItemAugmentSmoking) {
                speed = Math.max(1, speed / 2);
            }
            if (stack.m_41720_() instanceof ItemAugmentFuel) {
                speed = Math.max(1, (int)Math.ceil((double)speed * 1.25));
            }
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int i = (Integer)this.getCookTimeConfig().get();
        int j = this.getCache().computeIfAbsent(this.m_8020_(0).m_41720_(), this::getRecipe).map(AbstractCookingRecipe::m_43753_).orElse(0);
        if (j == 0) {
            Optional<AbstractCookingRecipe> recipe = this.grabRecipe();
            j = !recipe.isPresent() ? -1 : ((AbstractCookingRecipe)recipe.orElse(null)).m_43753_();
            this.getCache().put(this.m_8020_(0).m_41720_(), recipe);
            if (j == -1) {
                return -1;
            }
        }
        if (j < i) {
            int k = j - (200 - i);
            return k;
        }
        return i;
    }

    public ForgeConfigSpec.IntValue getCookTimeConfig() {
        return null;
    }

    private int getAugment(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemAugmentBlasting) {
            return 1;
        }
        if (stack.m_41720_() instanceof ItemAugmentSmoking) {
            return 2;
        }
        if (stack.m_41720_() instanceof ItemAugmentSpeed) {
            return 3;
        }
        if (stack.m_41720_() instanceof ItemAugmentFuel) {
            return 4;
        }
        return 0;
    }

    public void forceUpdateAllStates() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() != this.isBurning()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
        if (((Integer)state.m_61143_((Property)BlockIronFurnaceBase.TYPE)).intValue() != this.getStateType()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(this.getStateType())), 3);
        }
        if ((Integer)state.m_61143_((Property)BlockIronFurnaceBase.JOVIAL) != this.jovial) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(this.jovial)), 3);
        }
    }

    public static void tick(Level level, BlockPos worldPosition, BlockState blockState, final BlockIronFurnaceTileBase e) {
        ItemStack stack;
        if (e.furnaceSettings.size() <= 0) {
            e.furnaceSettings = new FurnaceSettings(){

                @Override
                public void onChanged() {
                    e.m_6596_();
                }
            };
        }
        boolean wasBurning = e.isBurning();
        boolean flag1 = false;
        boolean flag2 = false;
        if (e.currentAugment != e.getAugment(e.m_8020_(3))) {
            e.currentAugment = e.getAugment(e.m_8020_(3));
            e.furnaceBurnTime = 0;
        }
        if (e.isBurning()) {
            --e.furnaceBurnTime;
        }
        if ((stack = e.m_8020_(3)).m_41720_() instanceof ItemAugmentBlasting && e.recipeType != RecipeType.f_44109_) {
            e.recipeType = RecipeType.f_44109_;
        }
        if (stack.m_41720_() instanceof ItemAugmentSmoking && e.recipeType != RecipeType.f_44110_) {
            e.recipeType = RecipeType.f_44110_;
        }
        if (!(stack.m_41720_() instanceof ItemAugmentSmoking) && !(stack.m_41720_() instanceof ItemAugmentBlasting) && e.recipeType != RecipeType.f_44108_) {
            e.recipeType = RecipeType.f_44108_;
        }
        if (!e.f_58857_.f_46443_) {
            int mode;
            ++e.timer;
            if (e.totalCookTime != e.getCookTime()) {
                e.totalCookTime = e.getCookTime();
            }
            if ((mode = e.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    i = 0;
                    for (Direction side : Direction.values()) {
                        if (level.m_46681_(worldPosition.m_141952_(side.m_122436_()), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        e.cookTime = 0;
                        e.furnaceBurnTime = 0;
                        e.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (Direction side : Direction.values()) {
                        if (level.m_46681_(worldPosition.m_141952_(side.m_122436_()), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        e.cookTime = 0;
                        e.furnaceBurnTime = 0;
                        e.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < Direction.values().length; ++i) {
                    e.provides[i] = e.m_58900_().m_60775_((BlockGetter)e.f_58857_, worldPosition, DirectionUtil.fromId(i));
                }
            } else {
                for (i = 0; i < Direction.values().length; ++i) {
                    e.provides[i] = 0;
                }
            }
            if (e.doesNeedUpdateSend()) {
                e.onUpdateSent();
            }
            ItemStack itemstack = e.m_8020_(1);
            if (e.isBurning() || !itemstack.m_41619_() && !e.m_8020_(0).m_41619_()) {
                Optional<Object> irecipe = Optional.empty();
                if (!e.m_8020_(0).m_41619_()) {
                    irecipe = e.grabRecipe();
                }
                boolean valid = e.canSmelt(irecipe.orElse(null));
                if (!e.isBurning() && valid) {
                    if (itemstack.m_41720_() instanceof ItemHeater) {
                        int energy;
                        int z;
                        int y;
                        int x;
                        BlockEntity te;
                        if (itemstack.m_41782_() && (te = level.m_7702_(new BlockPos(x = itemstack.m_41783_().m_128451_("X"), y = itemstack.m_41783_().m_128451_("Y"), z = itemstack.m_41783_().m_128451_("Z")))) instanceof BlockWirelessEnergyHeaterTile && (energy = ((BlockWirelessEnergyHeaterTile)te).getEnergy()) >= 2000) {
                            if (!e.m_8020_(3).m_41619_() && e.m_8020_(3).m_41720_() instanceof ItemAugmentFuel) {
                                e.furnaceBurnTime = 400 * e.getCookTime() / 200;
                            } else if (!e.m_8020_(3).m_41619_() && e.m_8020_(3).m_41720_() instanceof ItemAugmentSpeed) {
                                if (energy >= 4000) {
                                    ((BlockWirelessEnergyHeaterTile)te).removeEnergy(2000);
                                    e.furnaceBurnTime = 200 * e.getCookTime() / 200;
                                }
                            } else {
                                e.furnaceBurnTime = 200 * e.getCookTime() / 200;
                            }
                            if (e.furnaceBurnTime > 0) {
                                ((BlockWirelessEnergyHeaterTile)te).removeEnergy(2000);
                            }
                            e.recipesUsed = e.furnaceBurnTime;
                        }
                    } else {
                        e.furnaceBurnTime = !e.m_8020_(3).m_41619_() && e.m_8020_(3).m_41720_() instanceof ItemAugmentFuel ? 2 * BlockIronFurnaceTileBase.getBurnTime(itemstack) * e.getCookTime() / 200 : (!e.m_8020_(3).m_41619_() && e.m_8020_(3).m_41720_() instanceof ItemAugmentSpeed ? BlockIronFurnaceTileBase.getBurnTime(itemstack) / 2 * e.getCookTime() / 200 : BlockIronFurnaceTileBase.getBurnTime(itemstack) * e.getCookTime() / 200);
                        e.recipesUsed = e.furnaceBurnTime;
                    }
                    if (e.isBurning()) {
                        flag1 = true;
                        if (!(itemstack.m_41720_() instanceof ItemHeater)) {
                            if (itemstack.hasContainerItem()) {
                                e.m_6836_(1, itemstack.getContainerItem());
                            } else if (!itemstack.m_41619_()) {
                                itemstack.m_41774_(1);
                                if (itemstack.m_41619_()) {
                                    e.m_6836_(1, itemstack.getContainerItem());
                                }
                            }
                        }
                    }
                }
                if (e.isBurning() && valid) {
                    ++e.cookTime;
                    if (e.cookTime >= e.totalCookTime) {
                        e.cookTime = 0;
                        e.totalCookTime = e.getCookTime();
                        e.smeltItem(irecipe.orElse(null));
                        e.autoIO();
                        flag1 = true;
                    }
                } else {
                    e.cookTime = 0;
                }
            } else if (!e.isBurning() && e.cookTime > 0) {
                e.cookTime = BlockIronFurnaceTileBase.clamp(e.cookTime - 2, 0, e.totalCookTime);
            }
            if (wasBurning != e.isBurning()) {
                flag1 = true;
                e.f_58857_.m_7731_(e.f_58858_, (BlockState)e.f_58857_.m_8055_(e.f_58858_).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(e.isBurning())), 3);
            }
            if (e.timer % 24 == 0) {
                BlockState state;
                if (e.cookTime <= 0) {
                    if (e.m_8020_(0).m_41619_()) {
                        e.autoIO();
                        flag1 = true;
                    } else if (e.m_8020_(0).m_41613_() < e.m_8020_(0).m_41741_()) {
                        e.autoIO();
                        flag1 = true;
                    }
                    if (e.m_8020_(1).m_41619_()) {
                        e.autoIO();
                        flag1 = true;
                    } else if (e.m_8020_(1).m_41613_() < e.m_8020_(1).m_41741_()) {
                        e.autoIO();
                        flag1 = true;
                    }
                }
                if (((Integer)(state = level.m_8055_(worldPosition)).m_61143_((Property)BlockIronFurnaceBase.TYPE)).intValue() != e.getStateType()) {
                    level.m_7731_(worldPosition, (BlockState)state.m_61124_((Property)BlockIronFurnaceBase.TYPE, (Comparable)Integer.valueOf(e.getStateType())), 3);
                }
                if ((Integer)state.m_61143_((Property)BlockIronFurnaceBase.JOVIAL) != e.jovial) {
                    level.m_7731_(worldPosition, (BlockState)state.m_61124_((Property)BlockIronFurnaceBase.JOVIAL, (Comparable)Integer.valueOf(e.jovial)), 3);
                }
            }
        }
        if (flag1) {
            e.m_6596_();
        }
    }

    public static int clamp(int p_76125_0_, int p_76125_1_, int p_76125_2_) {
        if (p_76125_0_ < p_76125_1_) {
            return p_76125_1_;
        }
        return p_76125_0_ > p_76125_2_ ? p_76125_2_ : p_76125_0_;
    }

    private void autoIO() {
        for (Direction dir : Direction.values()) {
            IItemHandler other;
            BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_141952_(dir.m_122436_()));
            if (tile == null || this.furnaceSettings.get(dir.ordinal()) != 1 && this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 && this.furnaceSettings.get(dir.ordinal()) != 4 || tile == null || (other = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.m_122424_()).map(other1 -> other1).orElse(null)) == null || other == null || this.getAutoInput() == 0 && this.getAutoOutput() == 0) continue;
            if (this.getAutoInput() == 1) {
                ItemStack stack;
                int i;
                if (this.furnaceSettings.get(dir.ordinal()) == 1 || this.furnaceSettings.get(dir.ordinal()) == 3) {
                    if (this.m_8020_(0).m_41613_() >= this.m_8020_(0).m_41741_()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).m_41619_() || (!this.hasRecipe(stack = other.extractItem(i, other.getStackInSlot(i).m_41741_(), true)) || !this.m_8020_(0).m_41619_()) && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.m_8020_(0), (ItemStack)stack)) continue;
                        this.insertItemInternal(0, other.extractItem(i, other.getStackInSlot(i).m_41741_() - this.m_8020_(0).m_41613_(), false), false);
                    }
                }
                if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                    if (this.m_8020_(1).m_41613_() >= this.m_8020_(1).m_41741_()) continue;
                    for (i = 0; i < other.getSlots(); ++i) {
                        if (other.getStackInSlot(i).m_41619_() || (!BlockIronFurnaceTileBase.isItemFuel(stack = other.extractItem(i, other.getStackInSlot(i).m_41741_(), true)) || !this.m_8020_(1).m_41619_()) && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.m_8020_(1), (ItemStack)stack)) continue;
                        this.insertItemInternal(1, other.extractItem(i, other.getStackInSlot(i).m_41741_() - this.m_8020_(1).m_41613_(), false), false);
                    }
                }
            }
            if (this.getAutoOutput() != 1) continue;
            if (this.furnaceSettings.get(dir.ordinal()) == 4) {
                ItemStack stack;
                if (this.m_8020_(1).m_41619_() || (stack = this.extractItemInternal(1, 1, true)).m_41720_() != Items.f_42446_) continue;
                for (int i = 0; i < other.getSlots(); ++i) {
                    if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).m_41619_() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).m_41613_() + stack.m_41613_() > other.getSlotLimit(i))) continue;
                    other.insertItem(i, this.extractItemInternal(1, stack.m_41613_(), false), false);
                }
            }
            if (this.furnaceSettings.get(dir.ordinal()) != 2 && this.furnaceSettings.get(dir.ordinal()) != 3 || this.m_8020_(2).m_41619_() || tile.m_58900_().m_60734_().getRegistryName().toString().contains("storagedrawers:")) continue;
            for (int i = 0; i < other.getSlots(); ++i) {
                ItemStack stack = this.extractItemInternal(2, this.m_8020_(2).m_41741_() - other.getStackInSlot(i).m_41613_(), true);
                if (!other.isItemValid(i, stack) || !other.getStackInSlot(i).m_41619_() && (!ItemHandlerHelper.canItemStacksStack((ItemStack)other.getStackInSlot(i), (ItemStack)stack) || other.getStackInSlot(i).m_41613_() + stack.m_41613_() > other.getSlotLimit(i))) continue;
                other.insertItem(i, this.extractItemInternal(2, stack.m_41613_(), false), false);
            }
        }
    }

    @Nonnull
    public ItemStack insertItemInternal(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.m_7155_(slot, stack, null)) {
            return stack;
        }
        ItemStack existing = this.m_8020_(slot);
        int limit = stack.m_41741_();
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.m_6836_(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.m_6596_();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @Nonnull
    private ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.m_8020_(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.m_6836_(slot, ItemStack.f_41583_);
                this.m_6596_();
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.m_6836_(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.m_6596_();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSettingBottom() {
        return this.furnaceSettings.get(0);
    }

    public int getSettingTop() {
        return this.furnaceSettings.get(1);
    }

    public int getSettingFront() {
        int i = DirectionUtil.getId((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_));
        return this.furnaceSettings.get(i);
    }

    public int getSettingBack() {
        int i = DirectionUtil.getId(((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
        return this.furnaceSettings.get(i);
    }

    public int getSettingLeft() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing == Direction.NORTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.EAST));
        }
        if (facing == Direction.WEST) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.NORTH));
        }
        if (facing == Direction.SOUTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.WEST));
        }
        return this.furnaceSettings.get(DirectionUtil.getId(Direction.SOUTH));
    }

    public int getSettingRight() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing == Direction.NORTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.WEST));
        }
        if (facing == Direction.WEST) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.SOUTH));
        }
        if (facing == Direction.SOUTH) {
            return this.furnaceSettings.get(DirectionUtil.getId(Direction.EAST));
        }
        return this.furnaceSettings.get(DirectionUtil.getId(Direction.NORTH));
    }

    public int getIndexFront() {
        int i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).ordinal();
        return i;
    }

    public int getIndexBack() {
        int i = ((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_().ordinal();
        return i;
    }

    public int getIndexLeft() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing == Direction.NORTH) {
            return Direction.EAST.ordinal();
        }
        if (facing == Direction.WEST) {
            return Direction.NORTH.ordinal();
        }
        if (facing == Direction.SOUTH) {
            return Direction.WEST.ordinal();
        }
        return Direction.SOUTH.ordinal();
    }

    public int getIndexRight() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        if (facing == Direction.NORTH) {
            return Direction.WEST.ordinal();
        }
        if (facing == Direction.WEST) {
            return Direction.SOUTH.ordinal();
        }
        if (facing == Direction.SOUTH) {
            return Direction.EAST.ordinal();
        }
        return Direction.NORTH.ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.get(6);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.get(7);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.get(8);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.get(9);
    }

    private int getStateType() {
        if (this.m_8020_(3).m_41720_() == Registration.SMOKING_AUGMENT.get()) {
            return 1;
        }
        if (this.m_8020_(3).m_41720_() == Registration.BLASTING_AUGMENT.get()) {
            return 2;
        }
        return 0;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    protected boolean canSmelt(@Nullable Recipe<?> recipe) {
        ItemStack recipeOutput;
        if (!this.m_8020_(0).m_41619_() && recipe != null && !(recipeOutput = recipe.m_8043_()).m_41619_()) {
            ItemStack output = this.m_8020_(2);
            if (output.m_41619_()) {
                return true;
            }
            if (!output.m_41656_(recipeOutput)) {
                return false;
            }
            return output.m_41613_() + recipeOutput.m_41613_() <= output.m_41741_();
        }
        return false;
    }

    protected void smeltItem(@Nullable Recipe<?> recipe) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = this.m_8020_(0);
            ItemStack itemstack1 = recipe.m_8043_();
            ItemStack itemstack2 = this.m_8020_(2);
            if (itemstack2.m_41619_()) {
                this.m_6836_(2, itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            this.checkXP(recipe);
            if (!this.f_58857_.f_46443_) {
                this.m_6029_(recipe);
            }
            if (itemstack.m_41720_() == Blocks.f_50057_.m_5456_() && !this.m_8020_(1).m_41619_() && this.m_8020_(1).m_41720_() == Items.f_42446_) {
                this.m_6836_(1, new ItemStack((ItemLike)Items.f_42447_));
            }
            if (ModList.get().isLoaded("pmmo")) {
                FurnaceHandler.handleSmelted((ItemStack)itemstack, (ItemStack)itemstack2, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)0);
                if (recipe instanceof SmokingRecipe) {
                    FurnaceHandler.handleSmelted((ItemStack)itemstack, (ItemStack)itemstack2, (Level)this.f_58857_, (BlockPos)this.f_58858_, (int)1);
                }
            }
            itemstack.m_41774_(1);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.furnaceBurnTime = tag.m_128451_("BurnTime");
        this.cookTime = tag.m_128451_("CookTime");
        this.totalCookTime = tag.m_128451_("CookTimeTotal");
        this.timer = 0;
        this.currentAugment = tag.m_128451_("Augment");
        this.jovial = tag.m_128451_("Jovial");
        this.recipesUsed = BlockIronFurnaceTileBase.getBurnTime(this.m_8020_(1));
        CompoundTag compoundnbt = tag.m_128469_("RecipesUsed");
        for (String s : compoundnbt.m_128431_()) {
            this.recipes.put((Object)new ResourceLocation(s), compoundnbt.m_128451_(s));
        }
        this.show_inventory_settings = tag.m_128451_("ShowInvSettings");
        this.furnaceSettings.read(tag);
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("BurnTime", this.furnaceBurnTime);
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("CookTimeTotal", this.totalCookTime);
        tag.m_128405_("Augment", this.currentAugment);
        tag.m_128405_("Jovial", this.jovial);
        this.furnaceSettings.write(tag);
        tag.m_128405_("ShowInvSettings", this.show_inventory_settings);
        CompoundTag compoundnbt = new CompoundTag();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.m_128405_(recipeId.toString(), craftedAmount.intValue()));
        tag.m_128365_("RecipesUsed", (Tag)compoundnbt);
    }

    protected static int getBurnTime(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        Item item = stack.m_41720_();
        int ret = stack.getBurnTime(RecipeType.f_44108_);
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? AbstractFurnaceBlockEntity.m_58423_().getOrDefault(item, 0) : ret), (RecipeType)RecipeType.f_44108_);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return BlockIronFurnaceTileBase.getBurnTime(stack) > 0 || stack.m_41720_() instanceof ItemHeater;
    }

    public static boolean isItemAugment(ItemStack stack) {
        return stack.m_41720_() instanceof ItemAugment;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.m_58901_() && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.invHandlers[0].cast();
            }
            if (facing == Direction.UP) {
                return this.invHandlers[1].cast();
            }
            if (facing == Direction.NORTH) {
                return this.invHandlers[2].cast();
            }
            if (facing == Direction.SOUTH) {
                return this.invHandlers[3].cast();
            }
            if (facing == Direction.WEST) {
                return this.invHandlers[4].cast();
            }
            return this.invHandlers[5].cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public int[] IgetSlotsForFace(Direction side) {
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 0) {
            return new int[0];
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 1) {
            return new int[]{0, 1};
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 2) {
            return new int[]{2};
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 3) {
            return new int[]{0, 1, 2};
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(side)) == 4) {
            return new int[]{1};
        }
        return new int[0];
    }

    @Override
    public boolean IcanExtractItem(int index, ItemStack stack, Direction direction) {
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 0) {
            return false;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 1) {
            return false;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 2) {
            return index == 2;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 3) {
            return index == 2;
        }
        if (this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.m_41720_() != Items.f_42446_) {
            return false;
        }
        return this.furnaceSettings.get(DirectionUtil.getId(direction)) == 4 && stack.m_41720_() == Items.f_42446_;
    }

    @Override
    public boolean IisItemValidForSlot(int index, ItemStack stack) {
        if (index == 2 || index == 3) {
            return false;
        }
        if (index == 0) {
            if (stack.m_41619_()) {
                return false;
            }
            return this.hasRecipe(stack);
        }
        if (index == 1) {
            ItemStack itemstack = this.m_8020_(1);
            return BlockIronFurnaceTileBase.getBurnTime(stack) > 0 || stack.m_41720_() == Items.f_42446_ && itemstack.m_41720_() != Items.f_42446_ || stack.m_41720_() instanceof ItemHeater;
        }
        return false;
    }

    public void setJovial(int value) {
        this.jovial = value;
    }

    public void checkXP(@Nullable Recipe<?> recipe) {
        if (!this.f_58857_.f_46443_) {
            boolean flag2 = false;
            if (this.recipes.size() > (Integer)Config.furnaceXPDropValue.get()) {
                this.grantStoredRecipeExperience(this.f_58857_, new Vector3d((double)(this.f_58858_.m_123341_() + this.rand.nextInt(2) - 1), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() + this.rand.nextInt(2) - 1)));
                this.recipes.clear();
            } else {
                for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                    if (!this.f_58857_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).isPresent() || entry.getIntValue() <= (Integer)Config.furnaceXPDropValue2.get()) continue;
                    if (!flag2) {
                        this.grantStoredRecipeExperience(this.f_58857_, new Vector3d((double)(this.f_58858_.m_123341_() + this.rand.nextInt(2) - 1), (double)this.f_58858_.m_123342_(), (double)(this.f_58858_.m_123343_() + this.rand.nextInt(2) - 1)));
                    }
                    flag2 = true;
                }
                if (flag2) {
                    this.recipes.clear();
                }
            }
        }
    }

    public void m_6029_(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation resourcelocation = recipe.m_6423_();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void unlockRecipes(Player player) {
        List<Recipe<?>> list = this.grantStoredRecipeExperience(player.f_19853_, new Vector3d(player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_));
        player.m_7281_(list);
        this.recipes.clear();
    }

    public List<Recipe<?>> grantStoredRecipeExperience(Level level, Vector3d worldPosition) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(h -> {
                list.add(h);
                BlockIronFurnaceTileBase.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), ((AbstractCookingRecipe)h).m_43750_());
            });
        }
        return list;
    }

    public static float frac(float p_226164_0_) {
        return p_226164_0_ - (float)Math.floor(p_226164_0_);
    }

    public static double frac(double p_181162_0_) {
        return p_181162_0_ - Math.floor(p_181162_0_);
    }

    public static int floor(float p_76141_0_) {
        int i = (int)p_76141_0_;
        return p_76141_0_ < (float)i ? i - 1 : i;
    }

    private static void splitAndSpawnExperience(Level level, Vector3d worldPosition, int craftedAmount, float experience) {
        int i = BlockIronFurnaceTileBase.floor((float)craftedAmount * experience);
        float f = BlockIronFurnaceTileBase.frac((float)craftedAmount * experience);
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            level.m_7967_((Entity)new ExperienceOrb(level, worldPosition.f_86214_, worldPosition.f_86215_, worldPosition.f_86216_, j));
        }
    }

    public void m_5809_(StackedContents helper) {
        for (ItemStack itemstack : this.inventory) {
            helper.m_36491_(itemstack);
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
    }

    public void placeConfig() {
        if (this.furnaceSettings != null) {
            this.furnaceSettings.set(0, 2);
            this.furnaceSettings.set(1, 1);
            for (Direction dir : Direction.values()) {
                if (dir == Direction.DOWN || dir == Direction.UP) continue;
                this.furnaceSettings.set(dir.ordinal(), 4);
            }
            this.f_58857_.markAndNotifyBlock(this.f_58858_, this.f_58857_.m_46745_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_).m_60734_().m_49966_(), this.f_58857_.m_8055_(this.f_58858_), 3, 3);
        }
    }
}

