/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util.helper;

import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ContainerHelper {
    public static int countItems(Container container, ItemStack stack, boolean exactNBT) {
        if (stack.m_41613_() > stack.m_41741_()) {
            for (int i = 0; i < stack.m_41613_(); ++i) {
                stack.m_41764_(1);
                ContainerHelper.countItems(container, stack, exactNBT);
            }
        }
        int count = 0;
        for (int slotId = 0; slotId < container.m_6643_(); ++slotId) {
            ItemStack stackInSlot = container.m_8020_(slotId);
            if (!stackInSlot.m_41656_(stack)) continue;
            if (exactNBT && stack.m_41782_()) {
                if (!stackInSlot.m_41782_() || !Objects.equals(stackInSlot.m_41783_(), stack.m_41783_())) continue;
                count += stackInSlot.m_41613_();
                continue;
            }
            count += stackInSlot.m_41613_();
        }
        return count;
    }

    public static void consumeItems(Container container, ItemStack stack, int amount, boolean exactNBT) {
        int amountLeft = amount;
        if (ContainerHelper.countItems(container, stack, exactNBT) >= amount) {
            for (int slotId = 0; slotId < container.m_6643_() && amountLeft > 0; ++slotId) {
                ItemStack stackInSlot = container.m_8020_(slotId);
                if (stackInSlot.m_41619_() || !stackInSlot.m_41656_(stack) || exactNBT && stack.m_41782_() && (!stackInSlot.m_41782_() || !Objects.equals(stackInSlot.m_41783_(), stack.m_41783_()))) continue;
                if (amountLeft >= stackInSlot.m_41613_()) {
                    amountLeft -= stackInSlot.m_41613_();
                    container.m_6836_(slotId, ItemStack.f_41583_);
                    continue;
                }
                ItemStack copy = stackInSlot.m_41777_();
                container.m_7407_(slotId, amountLeft);
                amountLeft -= copy.m_41613_();
            }
        }
    }

    public static boolean canInsertStack(Container container, ItemStack stack) {
        int amountLeft = stack.m_41613_();
        for (int slotId = 0; slotId < container.m_6643_(); ++slotId) {
            ItemStack stackInSlot = container.m_8020_(slotId);
            if (!container.m_7013_(slotId, stack)) continue;
            if (stackInSlot.m_41619_()) {
                amountLeft -= stack.m_41741_();
                continue;
            }
            if (!ItemStack.m_41746_((ItemStack)stackInSlot, (ItemStack)stack) || stack.m_41782_() && (!stackInSlot.m_41782_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)stackInSlot))) continue;
            int spaceLeftInStack = stack.m_41741_() - stackInSlot.m_41613_();
            amountLeft -= spaceLeftInStack;
        }
        return amountLeft <= 0;
    }

    public static void insertStack(Container container, ItemStack stack) {
        for (int slotId = 0; slotId < container.m_6643_(); ++slotId) {
            ItemStack stackInSlot = container.m_8020_(slotId);
            if (ItemStack.m_41746_((ItemStack)stackInSlot, (ItemStack)stack) && stackInSlot.m_41613_() + stack.m_41613_() <= stack.m_41741_()) {
                if (stack.m_41782_() && !ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)stack)) continue;
                ItemStack stack2 = stack.m_41777_();
                stack2.m_41764_(stackInSlot.m_41613_() + stack.m_41613_());
                container.m_6836_(slotId, stack2);
                break;
            }
            if (!stackInSlot.m_41619_()) continue;
            container.m_6836_(slotId, stack);
            break;
        }
    }

    public static void insertOverflowingStack(Container container, ItemStack stack) {
        if (stack.m_41613_() >= stack.m_41741_()) {
            int stackSize;
            for (int amountLeft = stack.m_41613_(); amountLeft > 0; amountLeft -= stackSize) {
                ItemStack partialStack = stack.m_41777_();
                stackSize = Math.min(amountLeft, stack.m_41741_());
                partialStack.m_41764_(stackSize);
                ContainerHelper.insertStack(container, partialStack);
            }
        } else {
            ContainerHelper.insertStack(container, stack);
        }
    }
}

