/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util.helper;

import com.tm.calemicore.util.Location;
import com.tm.calemicore.util.helper.MathHelper;
import com.tm.calemicore.util.helper.StringHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemHelper {
    public static MutableComponent countByStacks(int count) {
        int remainder = count % 64;
        TextComponent msg = new TextComponent(StringHelper.insertCommas(count));
        msg.m_130946_(" ");
        msg.m_7220_((Component)new TranslatableComponent("itemhelper.blocks"));
        if (count > 64) {
            msg.m_130946_(" (" + (int)Math.floor((float)count / 64.0f));
            msg.m_130946_(" ");
            msg.m_7220_((Component)new TranslatableComponent("itemhelper.stacks"));
            if (remainder > 0) {
                msg.m_130946_(" + " + remainder + " ");
                msg.m_7220_((Component)new TranslatableComponent("itemhelper.blocks"));
            }
            msg.m_130946_(")");
        }
        return msg;
    }

    public static void spawnOverflowingStackAtEntity(Level level, Entity entity, ItemStack stack) {
        ItemHelper.spawnOverflowingStack(level, (float)entity.m_20185_(), (float)entity.m_20186_() + 0.5f, (float)entity.m_20189_(), stack);
    }

    private static void spawnOverflowingStack(Level level, float x, float y, float z, ItemStack stack) {
        if (stack.m_41613_() > stack.m_41741_()) {
            ItemStack spawnStack;
            for (int amountLeft = stack.m_41613_(); amountLeft > 0; amountLeft -= spawnStack.m_41613_()) {
                spawnStack = stack.m_41777_();
                spawnStack.m_41764_(Math.min(amountLeft, stack.m_41741_()));
                ItemHelper.spawnStack(level, x, y, z, spawnStack);
            }
        } else {
            ItemHelper.spawnStack(level, x, y, z, stack);
        }
    }

    public static ItemEntity spawnStackAtLocation(Level level, Location location, ItemStack stack) {
        return ItemHelper.spawnStack(level, (float)location.x + 0.5f, (float)location.y + 0.5f, (float)location.z + 0.5f, stack);
    }

    public static ItemEntity spawnStackAtEntity(Level level, Entity entity, ItemStack stack) {
        return ItemHelper.spawnStack(level, (float)entity.m_20185_(), (float)entity.m_20186_() + 0.5f, (float)entity.m_20189_(), stack);
    }

    public static ItemEntity spawnStack(Level level, float x, float y, float z, ItemStack stack) {
        ItemEntity item = new ItemEntity(level, (double)x, (double)y, (double)z, stack);
        item.m_32061_();
        item.m_20334_((double)(-0.05f + MathHelper.random.nextFloat() * 0.1f), (double)(-0.05f + MathHelper.random.nextFloat() * 0.1f), (double)(-0.05f + MathHelper.random.nextFloat() * 0.1f));
        level.m_7967_((Entity)item);
        return item;
    }
}

