/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util.helper;

import com.tm.calemicore.util.Location;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RayTraceHelper {
    public static BlockTrace rayTraceBlock(Level level, Player player, int maxDistance) {
        Vec3 playerPosVec = new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        Vec3 playerLookVec = player.m_20154_();
        Direction playerLookDir = Direction.m_122366_((double)playerLookVec.f_82479_, (double)playerLookVec.f_82480_, (double)playerLookVec.f_82481_);
        BlockHitResult rayTrace = level.m_45547_(new ClipContext(playerPosVec, playerPosVec.m_82549_(playerLookVec.m_82490_((double)maxDistance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        UseOnContext itemUseContext = new UseOnContext(player, InteractionHand.MAIN_HAND, rayTrace);
        BlockPlaceContext blockUseContext = new BlockPlaceContext(itemUseContext);
        if (rayTrace.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = blockUseContext.m_8083_();
            Location locationOffset = new Location(level, pos);
            BlockPos difference = locationOffset.getBlockPos().m_141950_((Vec3i)itemUseContext.m_8083_());
            Direction blockSide = Direction.m_122372_((float)difference.m_123341_(), (float)difference.m_123342_(), (float)difference.m_123343_());
            Location locationReal = locationOffset.copy();
            locationReal.translate(blockSide.m_122424_(), 1);
            return new BlockTrace(locationReal, blockSide);
        }
        return null;
    }

    public static Entity rayTraceEntity(Level level, Player player, int maxDistance) {
        Entity entityHit = null;
        for (int i = 0; i < maxDistance; ++i) {
            Vec3 playerLookVec = player.m_20154_();
            Vec3 playerLookVecOffset = new Vec3(player.m_20185_() + playerLookVec.f_82479_ * (double)i, player.m_20186_() + playerLookVec.f_82480_ * (double)i, player.m_20189_() + playerLookVec.f_82481_ * (double)i);
            List entities = level.m_6249_((Entity)player, new AABB(playerLookVecOffset.m_82520_(-1.0, -1.0, -1.0), playerLookVecOffset.m_82520_(1.0, 1.0, 1.0)), entity -> entity instanceof LivingEntity);
            if (entities.isEmpty()) continue;
            entityHit = (Entity)entities.get(0);
            break;
        }
        return entityHit;
    }

    public record BlockTrace(Location hit, Direction hitSide) {
        public Location getHit() {
            return this.hit;
        }

        public Direction getHitSide() {
            return this.hitSide;
        }
    }
}

