/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tm.calemicore.main.CCReference;
import com.tm.calemicore.util.screen.ScreenRect;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ScreenHelper {
    private static final int TEXTURE_SIZE = 256;
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void drawRect(int u, int v, ScreenRect rect, int zLevel) {
        int maxX = rect.x + rect.width;
        int maxY = rect.y + rect.height;
        int maxU = u + rect.width;
        int maxV = v + rect.height;
        float pixel = 0.00390625f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69478_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)rect.x, (double)maxY, (double)zLevel).m_7421_((float)u * pixel, (float)maxV * pixel).m_5752_();
        buffer.m_5483_((double)maxX, (double)maxY, (double)zLevel).m_7421_((float)maxU * pixel, (float)maxV * pixel).m_5752_();
        buffer.m_5483_((double)maxX, (double)rect.y, (double)zLevel).m_7421_((float)maxU * pixel, (float)v * pixel).m_5752_();
        buffer.m_5483_((double)rect.x, (double)rect.y, (double)zLevel).m_7421_((float)u * pixel, (float)v * pixel).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
    }

    public static void drawExpandableRect(int u, int v, ScreenRect rect, int maxWidth, int maxHeight, int zLevel) {
        ScreenRect topLeft = new ScreenRect(rect.x, rect.y, Math.min(rect.width - 2, maxWidth), Math.min(rect.height - 2, maxHeight));
        ScreenHelper.drawRect(u, v, topLeft, zLevel);
        ScreenRect right = new ScreenRect(rect.x + rect.width - 2, rect.y, 2, Math.min(rect.height - 2, maxHeight));
        if (rect.width <= maxWidth) {
            ScreenHelper.drawRect(u + maxWidth - 2, v, right, zLevel);
        }
        ScreenRect bottom = new ScreenRect(rect.x, rect.y + rect.height - 2, Math.min(rect.width - 2, maxWidth), 2);
        if (rect.height <= maxHeight) {
            ScreenHelper.drawRect(u, v + maxHeight - 2, bottom, zLevel);
        }
        ScreenRect bottomRight = new ScreenRect(rect.x + rect.width - 2, rect.y + rect.height - 2, 2, 2);
        if (rect.width <= maxWidth && rect.height <= maxHeight) {
            ScreenHelper.drawRect(u + maxWidth - 2, v + maxHeight - 2, bottomRight, zLevel);
        }
    }

    public static void drawColoredRect(ScreenRect rect, int zLevel, int hexColor, float alpha) {
        float r = hexColor >> 16 & 0xFF;
        float g = hexColor >> 8 & 0xFF;
        float b = hexColor & 0xFF;
        float red = r * 100.0f / 255.0f / 100.0f;
        float green = g * 100.0f / 255.0f / 100.0f;
        float blue = b * 100.0f / 255.0f / 100.0f;
        int maxX = rect.x + rect.width;
        int maxY = rect.y + rect.height;
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)rect.x, (double)maxY, (double)zLevel).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_5483_((double)maxX, (double)maxY, (double)zLevel).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_5483_((double)maxX, (double)rect.y, (double)zLevel).m_85950_(red, green, blue, alpha).m_5752_();
        buffer.m_5483_((double)rect.x, (double)rect.y, (double)zLevel).m_85950_(red, green, blue, alpha).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawCenteredString(PoseStack poseStack, int x, int y, int zLevel, int hexColor, MutableComponent text) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)(50 + zLevel));
        ScreenHelper.mc.f_91062_.m_92889_(poseStack, (Component)text, (float)x - (float)(ScreenHelper.mc.f_91062_.m_92852_((FormattedText)text) / 2), (float)y, hexColor);
        poseStack.m_85849_();
    }

    public static void drawTextBox(PoseStack poseStack, int x, int y, int zLevel, boolean isStringCentered, int hexColor, MutableComponent ... text) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, (double)zLevel);
        int maxLength = ScreenHelper.mc.f_91062_.m_92852_((FormattedText)text[0]);
        ArrayList<MutableComponent> textToRender = new ArrayList<MutableComponent>(Arrays.asList(text));
        for (MutableComponent msg : textToRender) {
            if (ScreenHelper.mc.f_91062_.m_92852_((FormattedText)msg) <= maxLength) continue;
            maxLength = ScreenHelper.mc.f_91062_.m_92852_((FormattedText)msg);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)CCReference.GUI_TOOLTIP);
        ScreenRect rect = new ScreenRect(x + (isStringCentered ? -maxLength / 2 : 0), y, maxLength + 5, 13 + (textToRender.size() - 1) * 9);
        ScreenHelper.drawExpandableRect(0, 0, rect, 512, 512, zLevel);
        poseStack.m_85837_(0.0, 0.0, 100.0);
        for (int i = 0; i < textToRender.size(); ++i) {
            MutableComponent msg = (MutableComponent)textToRender.get(i);
            ScreenHelper.mc.f_91062_.m_92889_(poseStack, (Component)msg.m_130940_(ChatFormatting.WHITE), (float)(x + 3 + (isStringCentered ? -(ScreenHelper.mc.f_91062_.m_92895_(msg.getString()) / 2) : 0)), (float)(y + 3 + i * 9), hexColor);
        }
        poseStack.m_85837_(0.0, 0.0, 0.0);
        poseStack.m_85849_();
    }

    public static void drawHoveringTextBox(PoseStack poseStack, ScreenRect hoverRect, int zLevel, int mouseX, int mouseY, int hexColor, MutableComponent ... text) {
        if (hoverRect.contains(mouseX, mouseY)) {
            ScreenHelper.drawTextBox(poseStack, mouseX + 8, mouseY - 10, 50, false, hexColor, text);
        }
    }

    public static void drawItemStack(ItemRenderer itemRender, ItemStack stack, int x, int y) {
        itemRender.f_115093_ = -100.0f;
        itemRender.m_115123_(stack, x, y);
        itemRender.f_115093_ = 0.0f;
    }
}

