/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util.helper;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WorldGenHelper {
    public static final ArrayList<PlacedFeature> oresOverworld = new ArrayList();
    public static final ArrayList<PlacedFeature> oresNether = new ArrayList();
    public static final ArrayList<PlacedFeature> oresEnd = new ArrayList();

    public static void registerOre(String name, Block oreBlock, Block deepslateBlock, int veinSize, int veinsPerChunk, int minY, int maxY, ArrayList<PlacedFeature> oreList) {
        List<OreConfiguration.TargetBlockState> ORE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)oreBlock.m_49966_()), OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)deepslateBlock.m_49966_()));
        ConfiguredFeature ORE_FEATURE = FeatureUtils.m_195005_((String)name, (ConfiguredFeature)Feature.f_65731_.m_65815_((FeatureConfiguration)new OreConfiguration(ORE_TARGET_LIST, veinSize)));
        List<BiomeFilter> placementModifiers = List.of(CountPlacement.m_191628_((int)veinsPerChunk), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_());
        PlacedFeature ORE_PLACED = PlacementUtils.m_195368_((String)("ore_" + name), (PlacedFeature)ORE_FEATURE.m_190821_(placementModifiers));
        oreList.add(ORE_PLACED);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void generateOres(BiomeLoadingEvent event) {
        block4: {
            block5: {
                block3: {
                    BiomeGenerationSettingsBuilder generation = event.getGeneration();
                    if (event.getCategory().equals((Object)Biome.BiomeCategory.NETHER) || event.getCategory().equals((Object)Biome.BiomeCategory.THEEND)) break block3;
                    for (PlacedFeature ore : oresOverworld) {
                        if (ore == null) continue;
                        event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ore);
                    }
                    break block4;
                }
                if (!event.getCategory().equals((Object)Biome.BiomeCategory.NETHER)) break block5;
                for (PlacedFeature ore : oresNether) {
                    if (ore == null) continue;
                    event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ore);
                }
                break block4;
            }
            if (!event.getCategory().equals((Object)Biome.BiomeCategory.THEEND)) break block4;
            for (PlacedFeature ore : oresEnd) {
                if (ore == null) continue;
                event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(() -> ore);
            }
        }
    }
}

