/*
 * Decompiled with CFR 0.152.
 */
package com.tm.calemicore.util.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.tm.calemicore.util.render.RenderedItemStack;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;

public class RenderedFloatingItemStack
extends RenderedItemStack {
    private final float spinSpeed;
    private final float hoverSpeed;
    private final float hoverHeight;
    private long lastTime;
    private float spin;
    private float hover;

    public RenderedFloatingItemStack(float spinSpeed, float hoverSpeed, float hoverHeight) {
        this.spinSpeed = spinSpeed;
        this.hoverSpeed = hoverSpeed;
        this.hoverHeight = hoverHeight;
    }

    public RenderedFloatingItemStack() {
        this(1.0f, 1.0f, 1.0f);
    }

    public void updateSpinningAndFloating() {
        long targetTime = 10L;
        if (System.currentTimeMillis() - this.lastTime >= targetTime) {
            this.lastTime = System.currentTimeMillis();
            this.spin += this.spinSpeed;
            this.spin %= 360.0f;
            this.hover += 0.025f * this.hoverSpeed;
            this.hover = (float)((double)this.hover % (Math.PI * 2));
        }
    }

    public void applyTranslations(PoseStack poseStack) {
        if (!this.getStack().m_41619_()) {
            float blockYOffset = 0.0f;
            if (this.getStack().m_41720_() instanceof BlockItem) {
                blockYOffset = -0.125f;
            }
            poseStack.m_85837_(0.5, 0.5 + (double)blockYOffset + (double)(Mth.m_14031_((float)this.hover) / 5.0f * this.hoverHeight), 0.5);
        }
    }

    public void applyRotations(PoseStack poseStack) {
        if (!this.getStack().m_41619_()) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(this.spin));
        }
    }

    public void applyScale(PoseStack poseStack) {
        if (!this.getStack().m_41619_()) {
            float blockScale = 1.0f;
            if (this.getStack().m_41720_() instanceof BlockItem) {
                blockScale = 1.5f;
            }
            poseStack.m_85841_(blockScale, blockScale, blockScale);
        }
    }
}

