/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.notes.gui;

import com.chaosthedude.notes.Notes;
import com.chaosthedude.notes.config.ConfigHandler;
import com.chaosthedude.notes.gui.EditNoteScreen;
import com.chaosthedude.notes.gui.NotesButton;
import com.chaosthedude.notes.gui.NotesConfirmScreen;
import com.chaosthedude.notes.note.Note;
import com.chaosthedude.notes.util.RenderUtils;
import com.chaosthedude.notes.util.StringUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DisplayNoteScreen
extends Screen {
    private final Screen parentScreen;
    private NotesButton doneButton;
    private NotesButton pinButton;
    private NotesButton editButton;
    private NotesButton deleteButton;
    private NotesButton prevButton;
    private NotesButton nextButton;
    private Note note;
    private int page;
    private List<String> pages;

    public DisplayNoteScreen(Screen parentScreen, Note note) {
        super((Component)new TextComponent(note.getTitle()));
        this.parentScreen = parentScreen;
        this.note = note;
        this.page = 0;
        this.pages = new ArrayList<String>();
        this.pages.add("");
    }

    public void m_7856_() {
        this.setupButtons();
        this.setupPages();
    }

    public void m_96624_() {
        this.prevButton.f_93623_ = this.page > 0;
        this.nextButton.f_93623_ = this.page < this.pages.size() - 1;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        DisplayNoteScreen.m_93208_((PoseStack)stack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_96543_ / 2 + 60), (int)15, (int)-1);
        this.displayNote(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
    }

    public void displayNote(PoseStack stack) {
        RenderUtils.renderSplitString(stack, this.pages.get(this.page), 160, 40, this.f_96543_ - 200, 0xFFFFFF);
    }

    private void setupButtons() {
        this.editButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 40, 110, 20, (Component)new TranslatableComponent("notes.edit"), onPress -> this.f_96541_.m_91152_((Screen)new EditNoteScreen(this.parentScreen, this.note))));
        this.deleteButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 65, 110, 20, (Component)new TranslatableComponent("notes.delete"), onPress -> this.deleteNote()));
        this.pinButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, 90, 110, 20, (Component)(this.isPinned() ? new TranslatableComponent("notes.unpin") : new TranslatableComponent("notes.pin")), onPress -> {
            this.togglePin();
            if (this.isPinned()) {
                this.f_96541_.m_91152_(null);
            }
        }));
        this.doneButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(10, this.f_96544_ - 30, 110, 20, (Component)new TranslatableComponent("gui.done"), onPress -> this.f_96541_.m_91152_(this.parentScreen)));
        this.prevButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(130, this.f_96544_ - 30, 20, 20, (Component)new TranslatableComponent("<"), onPress -> {
            if (this.page > 0) {
                --this.page;
            }
        }));
        this.nextButton = (NotesButton)this.m_142416_((GuiEventListener)new NotesButton(this.f_96543_ - 30, this.f_96544_ - 30, 20, 20, (Component)new TranslatableComponent(">"), onPress -> {
            if (this.page < this.pages.size() - 1) {
                ++this.page;
            }
        }));
    }

    private void setupPages() {
        if (this.note != null) {
            List<String> lines = (Boolean)ConfigHandler.CLIENT.wrapNote.get() != false ? RenderUtils.trimStringToWidth(this.note.getFilteredText(), this.f_96543_ - 200) : StringUtils.wrapToWidth(this.note.getFilteredText(), this.f_96543_ - 200);
            this.pages = new ArrayList<String>();
            int lineCount = 0;
            Object page = "";
            for (String line : lines) {
                if (lineCount > 15) {
                    this.pages.add((String)page);
                    page = "";
                    lineCount = 0;
                }
                page = (String)page + line + "\n";
                ++lineCount;
            }
            if (!((String)page).isEmpty()) {
                this.pages.add((String)page);
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add("");
        }
    }

    private boolean isPinned() {
        return this.note.equals(Notes.pinnedNote);
    }

    private void togglePin() {
        if (this.isPinned()) {
            Notes.pinnedNote = null;
            this.pinButton.m_93666_((Component)new TranslatableComponent("notes.pin"));
        } else {
            Notes.pinnedNote = this.note;
            this.pinButton.m_93666_((Component)new TranslatableComponent("notes.unpin"));
        }
    }

    private void deleteNote() {
        this.f_96541_.m_91152_((Screen)new NotesConfirmScreen(result -> {
            if (result) {
                this.note.delete();
            }
            this.f_96541_.m_91152_(this.parentScreen);
        }, (Component)new TextComponent(I18n.m_118938_((String)"notes.confirmDelete", (Object[])new Object[0])), (Component)new TextComponent(this.note.getTitle())));
    }
}

