/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import java.util.Comparator;
import jeresources.api.conditionals.Conditional;
import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.CompatBase;
import jeresources.compatibility.minecraft.MobCompat;
import jeresources.compatibility.minecraft.RenderHooks;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LootTableHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.storage.loot.LootTables;

public class MinecraftCompat
extends CompatBase {
    @Override
    public void init(boolean worldGen) {
        this.registerVanillaMobs();
        this.registerDungeonLoot();
        if (worldGen) {
            this.registerOres();
        }
        this.registerVanillaPlants();
    }

    @Override
    protected void registerMob(MobEntry entry) {
        MobCompat.getInstance().setLightLevel(entry);
        MobCompat.getInstance().setExperience(entry);
        super.registerMob(entry);
    }

    private void registerVanillaMobs() {
        Level level = MinecraftCompat.getLevel();
        LootTables lootTables = LootTableHelper.getLootTables(level);
        LootTableHelper.getAllMobLootTables(level).entrySet().stream().map(entry -> new MobEntry((LivingEntity)entry.getValue(), lootTables.m_79217_((ResourceLocation)entry.getKey()))).sorted(Comparator.comparing(MobEntry::getMobName)).forEach(this::registerMob);
        this.registerMobRenderHook(Bat.class, RenderHooks.BAT);
        this.registerMobRenderHook(EnderDragon.class, RenderHooks.ENDER_DRAGON);
        this.registerMobRenderHook(ElderGuardian.class, RenderHooks.ELDER_GUARDIAN);
        this.registerMobRenderHook(Squid.class, RenderHooks.SQUID);
        this.registerMobRenderHook(Giant.class, RenderHooks.GIANT);
        this.registerMobRenderHook(Shulker.class, RenderHooks.SHULKER);
        this.registerMobRenderHook(AbstractSchoolingFish.class, RenderHooks.GROUP_FISH);
    }

    private void registerDungeonLoot() {
        Level level = MinecraftCompat.getLevel();
        LootTables lootTables = LootTableHelper.getLootTables(level);
        LootTableHelper.getAllChestLootTablesResourceLocations().stream().map(resourceLocation -> new DungeonEntry(resourceLocation.m_135815_(), lootTables.m_79217_(resourceLocation))).forEach(x$0 -> this.registerDungeonEntry((DungeonEntry)x$0));
    }

    private void registerOres() {
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49997_), (DistributionBase)new DistributionSquare(30, 16, 136, 256), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42413_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49997_), (DistributionBase)new DistributionTriangular(20, 16, 96, 96), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42413_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_152505_), (DistributionBase)new DistributionTriangular(16, 8, 46, 66), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151051_), 2, 20, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_152505_), (DistributionBase)new DistributionTriangular(16, 16, 46, 66), new Restriction(BiomeRestriction.DRIPSTONE_CAVES, DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151051_), 2, 20, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50059_), (DistributionBase)new DistributionSquare(4, 8, -64, 64), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42534_), 4, 36, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50059_), (DistributionBase)new DistributionTriangular(2, 8, 0, 32), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42534_), 4, 36, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49996_), (DistributionBase)new DistributionTriangular(90, 8, 232, 152), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151050_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49996_), (DistributionBase)new DistributionTriangular(10, 8, 16, 40), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151050_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49996_), (DistributionBase)new DistributionSquare(10, 8, -64, 72), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151050_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49995_), (DistributionBase)new DistributionSquare(1, 8, -64, -48), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151053_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49995_), (DistributionBase)new DistributionTriangular(4, 8, -16, 48), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151053_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49995_), (DistributionBase)new DistributionTriangular(50, 8, -16, 48), new Restriction(BiomeRestriction.BADLANDS, DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_151053_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50173_), (DistributionBase)new DistributionTriangular(8, 8, -64, 32), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42451_), 1, 32, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50173_), (DistributionBase)new DistributionSquare(4, 8, -64, 15), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42451_), 1, 32, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50089_), (DistributionBase)new DistributionTriangular(6, 6, -64, 64), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42415_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50264_), (DistributionBase)new DistributionTriangular(100, 4, 202, 218), new Restriction(DimensionRestriction.OVERWORLD), true, new LootDrop(new ItemStack((ItemLike)Items.f_42616_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50331_), (DistributionBase)new DistributionSquare(16, 16, 10, 128), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new ItemStack((ItemLike)Items.f_42692_), 1, 4, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_49998_), (DistributionBase)new DistributionSquare(8, 16, 15, 117), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new ItemStack((ItemLike)Items.f_42587_), 2, 24, Conditional.affectedByFortune)));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((ItemLike)Blocks.f_50722_), (DistributionBase)new DistributionTriangular(14, 9, 1.6E-4f), new Restriction(DimensionRestriction.NETHER), new LootDrop[0]));
    }

    private void registerVanillaPlants() {
        PlantDrop potato = new PlantDrop(new ItemStack((ItemLike)Items.f_42620_), 1, 4);
        PlantDrop poisonous = new PlantDrop(new ItemStack((ItemLike)Items.f_42675_), 0.02f);
        this.registerPlant(new PlantEntry((PotatoBlock)Blocks.f_50250_, potato, poisonous));
        PlantDrop carrot = new PlantDrop(new ItemStack((ItemLike)Items.f_42619_), 1, 4);
        this.registerPlant(new PlantEntry((CarrotBlock)Blocks.f_50249_, carrot));
        PlantDrop wheat = new PlantDrop(new ItemStack((ItemLike)Items.f_42405_), 1, 1);
        PlantDrop seeds = new PlantDrop(new ItemStack((ItemLike)Items.f_42404_), 0, 3);
        this.registerPlant(new PlantEntry((CropBlock)Blocks.f_50092_, wheat, seeds));
        PlantDrop melonSlice = new PlantDrop(new ItemStack((ItemLike)Items.f_42575_), 3, 7);
        this.registerPlant(new PlantEntry((StemBlock)Blocks.f_50190_, melonSlice));
        PlantDrop pumpkin = new PlantDrop(new ItemStack((ItemLike)Blocks.f_50133_), 1, 1);
        this.registerPlant(new PlantEntry((StemBlock)Blocks.f_50189_, pumpkin));
        PlantDrop beetroot = new PlantDrop(new ItemStack((ItemLike)Items.f_42732_), 1, 1);
        PlantDrop beetrootSeeds = new PlantDrop(new ItemStack((ItemLike)Items.f_42733_), 0, 3);
        this.registerPlant(new PlantEntry((BeetrootBlock)Blocks.f_50444_, beetroot, beetrootSeeds));
        PlantDrop netherWartDrop = new PlantDrop(new ItemStack((ItemLike)Items.f_42588_), 2, 4);
        PlantEntry netherWartEntry = new PlantEntry((NetherWartBlock)Blocks.f_50200_, netherWartDrop);
        netherWartEntry.setSoil(Blocks.f_50135_.m_49966_());
        this.registerPlant(netherWartEntry);
        PlantDrop sweetBerriesDrop = new PlantDrop(new ItemStack((ItemLike)Items.f_42780_), 1, 3);
        PlantEntry sweetBerriesEntry = new PlantEntry((SweetBerryBushBlock)Blocks.f_50685_, sweetBerriesDrop);
        sweetBerriesEntry.setSoil(Blocks.f_50440_.m_49966_());
        this.registerPlant(sweetBerriesEntry);
    }
}

