/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import java.util.HashMap;
import jeresources.api.conditionals.LightLevel;
import jeresources.compatibility.minecraft.MinecraftCompat;
import jeresources.entry.MobEntry;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class MobCompat {
    private static Level level = MinecraftCompat.getLevel();
    private final HashMap<Class, Tuple<Integer, Integer>> MOB_XP = new HashMap();
    private final HashMap<Class, LightLevel> LIGHT_LEVEL = new HashMap();
    private static MobCompat instance;

    public static MobCompat getInstance() {
        if (instance == null) {
            instance = new MobCompat();
            return instance;
        }
        return instance;
    }

    private MobCompat() {
        this.initMobXp();
        this.initLightLevel();
    }

    public void setLightLevel(MobEntry entry) {
        Class<?> entityClass = entry.getEntity().getClass();
        entry.setLightLevel(this.LIGHT_LEVEL.getOrDefault(entityClass, LightLevel.any));
    }

    public void setExperience(MobEntry entry) {
        Class<?> entityClass = entry.getEntity().getClass();
        Tuple<Integer, Integer> minMaxExp = this.MOB_XP.getOrDefault(entityClass, (Tuple<Integer, Integer>)new Tuple((Object)0, (Object)0));
        entry.setMinExp((Integer)minMaxExp.m_14418_());
        entry.setMaxExp((Integer)minMaxExp.m_14419_());
    }

    private void initMobXp() {
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            Entity entity = entityType.m_20615_(level);
            if (!(entity instanceof Mob)) continue;
            Class<?> entityClass = entity.getClass();
            Tuple exp = entity instanceof Animal || entity instanceof WaterAnimal ? new Tuple((Object)1, (Object)3) : (entity instanceof EnderDragon ? new Tuple((Object)500, (Object)12000) : (entity instanceof Slime || entity instanceof MagmaCube ? new Tuple((Object)1, (Object)4) : new Tuple((Object)((Mob)entity).f_21364_, (Object)((Mob)entity).f_21364_)));
            this.MOB_XP.put(entityClass, (Tuple<Integer, Integer>)exp);
        }
    }

    private void initLightLevel() {
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            Entity entity = entityType.m_20615_(level);
            if (!(entity instanceof Mob)) continue;
            Class<?> entityClass = entity.getClass();
            if (this.cannotSpawnNaturally(entity)) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.any);
                continue;
            }
            if (entity instanceof Blaze) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.blaze);
                continue;
            }
            if (entity instanceof Monster || entity instanceof Slime || entity instanceof Phantom) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.hostile);
                continue;
            }
            if (entity instanceof Bat) {
                this.LIGHT_LEVEL.put(entityClass, LightLevel.bat);
                continue;
            }
            this.LIGHT_LEVEL.put(entityClass, LightLevel.any);
        }
    }

    private boolean cannotSpawnNaturally(Entity entity) {
        return entity instanceof Vex || entity instanceof Guardian || entity instanceof PatrollingMonster && !(entity instanceof Witch);
    }
}

