/*
 * Decompiled with CFR 0.152.
 */
package jeresources.entry;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jeresources.api.drop.LootDrop;
import jeresources.api.util.LootFunctionHelper;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LootTableHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraftforge.items.ItemHandlerHelper;

public class DungeonEntry {
    private Set<LootDrop> drops = new TreeSet<LootDrop>();
    private String name;
    private int maxStacks;
    private int minStacks;

    public DungeonEntry(String name, LootTable lootTable) {
        this.name = name;
        float[] tmpMinStacks = new float[]{0.0f};
        float[] tmpMaxStacks = new float[]{0.0f};
        LootTables lootTables = LootTableHelper.getLootTables();
        this.handleTable(lootTable, lootTables, tmpMinStacks, tmpMaxStacks);
        this.minStacks = Mth.m_14143_((float)tmpMinStacks[0]);
        this.maxStacks = Mth.m_14143_((float)tmpMaxStacks[0]);
    }

    private void handleTable(LootTable lootTable, LootTables lootTables, float[] tmpMinStacks, float[] tmpMaxStacks) {
        LootTableHelper.getPools(lootTable).forEach(pool -> {
            tmpMinStacks[0] = tmpMinStacks[0] + (float)LootFunctionHelper.getMin(pool.getRolls());
            tmpMaxStacks[0] = tmpMaxStacks[0] + (float)(LootFunctionHelper.getMax(pool.getRolls()) + LootFunctionHelper.getMax(pool.getBonusRolls()));
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootPoolSingletonContainer).map(entry -> (LootPoolSingletonContainer)entry).mapToInt(entry -> entry.f_79675_).sum();
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).map(entry -> new LootDrop(entry.f_79564_, (float)entry.f_79675_ / totalWeight, entry.f_79677_)).forEach(this.drops::add);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootTableReference).map(entry -> (LootTableReference)entry).map(entry -> lootTables.m_79217_(entry.f_79754_)).forEach(table -> this.handleTable((LootTable)table, lootTables, tmpMinStacks, tmpMaxStacks));
        });
    }

    public boolean containsItem(ItemStack itemStack) {
        return this.drops.stream().anyMatch(drop -> drop.item.m_41656_(itemStack));
    }

    public String getName() {
        String name = DungeonRegistry.categoryToLocalKeyMap.get(this.name);
        return name == null ? this.name : name;
    }

    public List<ItemStack> getItemStacks() {
        return this.getItemStacks(null);
    }

    public List<ItemStack> getItemStacks(IFocus<ItemStack> focus) {
        return this.drops.stream().map(drop -> drop.item).filter(stack -> focus == null || ItemStack.m_41746_((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((ItemStack)focus.getValue()).m_41613_()), (ItemStack)((ItemStack)focus.getValue()))).collect(Collectors.toList());
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    public int getMinStacks() {
        return this.minStacks;
    }

    public LootDrop getChestDrop(ItemStack ingredient) {
        return this.drops.stream().filter(drop -> ItemStack.m_41746_((ItemStack)drop.item, (ItemStack)ingredient)).findFirst().orElse(null);
    }
}

