/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.dungeon;

import javax.annotation.Nonnull;
import jeresources.config.Settings;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.dungeon.DungeonWrapper;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class DungeonCategory
extends BlankJEIRecipeCategory<DungeonWrapper> {
    protected static final int Y_FIRST_ITEM = 44;
    protected static final int X_FIRST_ITEM = 6;
    protected static int SPACING_Y;
    protected static int SPACING_X;
    protected static int ITEMS_PER_PAGE;

    public static void reloadSettings() {
        ITEMS_PER_PAGE = Settings.ITEMS_PER_COLUMN * Settings.ITEMS_PER_ROW * 2;
        SPACING_X = 166 / (Settings.ITEMS_PER_ROW * 2);
        SPACING_Y = 80 / Settings.ITEMS_PER_COLUMN;
    }

    public DungeonCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 16, 0, 16, 16));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return JEIConfig.DUNGEON;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jer.dungeon.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.DUNGEON;
    }

    public Class<? extends DungeonWrapper> getRecipeClass() {
        return DungeonWrapper.class;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull DungeonWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int x = 6;
        int y = 44;
        for (int i = 0; i < Math.min(ITEMS_PER_PAGE, ingredients.getOutputs(VanillaTypes.ITEM).size()); ++i) {
            recipeLayout.getItemStacks().init(i, false, x, y);
            if ((x += SPACING_X) < 6 + SPACING_X * Settings.ITEMS_PER_ROW * 2) continue;
            x = 6;
            y += SPACING_Y;
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)recipeWrapper);
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        int slots = Math.min(recipeWrapper.amountOfItems((IFocus<ItemStack>)focus), ITEMS_PER_PAGE);
        for (int i = 0; i < slots; ++i) {
            recipeLayout.getItemStacks().set(i, recipeWrapper.getItems((IFocus<ItemStack>)focus, i, slots));
        }
        recipeWrapper.resetLid();
    }
}

