/*
 * Decompiled with CFR 0.152.
 */
package jeresources.jei.villager;

import javax.annotation.Nonnull;
import jeresources.collection.TradeList;
import jeresources.jei.BlankJEIRecipeCategory;
import jeresources.jei.JEIConfig;
import jeresources.jei.villager.VillagerWrapper;
import jeresources.reference.Resources;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class VillagerCategory
extends BlankJEIRecipeCategory<VillagerWrapper> {
    protected static final int X_FIRST_ITEM = 95;
    protected static final int X_ITEM_DISTANCE = 18;
    protected static final int X_ITEM_RESULT = 150;
    protected static final int Y_ITEM_DISTANCE = 22;

    public VillagerCategory() {
        super((IDrawable)JEIConfig.getJeiHelpers().getGuiHelper().createDrawable(Resources.Gui.Jei.TABS, 0, 0, 16, 16));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return JEIConfig.VILLAGER;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jer.villager.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return Resources.Gui.Jei.VILLAGER;
    }

    public Class<? extends VillagerWrapper> getRecipeClass() {
        return VillagerWrapper.class;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull VillagerWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int i;
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        recipeWrapper.setFocus((IFocus<ItemStack>)focus);
        if (recipeWrapper.hasPois()) {
            recipeLayout.getItemStacks().init(0, true, 49, 18);
            recipeLayout.getItemStacks().set(0, recipeWrapper.getPois());
        }
        int y = 22 * (6 - recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus).size()) / 2;
        for (i = 0; i < recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus).size(); ++i) {
            recipeLayout.getItemStacks().init(3 * i + 1, true, 95, y + i * 22);
            recipeLayout.getItemStacks().init(3 * i + 2, true, 113, y + i * 22);
            recipeLayout.getItemStacks().init(3 * i + 3, false, 150, y + i * 22);
        }
        i = 0;
        for (int level : recipeWrapper.getPossibleLevels((IFocus<ItemStack>)focus)) {
            TradeList tradeList = recipeWrapper.getTrades(level).getFocusedList((IFocus<ItemStack>)focus);
            recipeLayout.getItemStacks().set(3 * i + 1, tradeList.getCostAs());
            recipeLayout.getItemStacks().set(3 * i + 2, tradeList.getCostBs());
            recipeLayout.getItemStacks().set(3 * i + 3, tradeList.getResults());
            ++i;
        }
    }
}

