/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMateriallyTexturedBlock {
    @NotNull
    public Block getBlock();

    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents();

    @NotNull
    default public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedRecipe(){

            public void m_7917_(@NotNull JsonObject json) {
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(IMateriallyTexturedBlock.this.getBlock().getRegistryName());
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return ModRecipeSerializers.ARCHITECTS_CUTTER;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }});
    }

    @NotNull
    default public MaterialTextureData getRandomMaterials() {
        HashMap textureData = Maps.newHashMap();
        for (IMateriallyTexturedBlockComponent component : this.getComponents()) {
            List candidates = component.getValidSkins().m_6497_();
            if (candidates.isEmpty()) continue;
            Block texture = (Block)candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            textureData.put(component.getId(), texture);
        }
        return new MaterialTextureData(textureData);
    }
}

