/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.utils;

import com.ldtteam.domumornamentum.client.model.utils.BaseModelReader;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.util.Arrays;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class ModelUVAdapter
extends BaseModelReader {
    private final BakedQuad source;
    private final float minU;
    private final float uDelta;
    private final float minV;
    private final float vDelta;
    private final TextureAtlasSprite target;
    private final BakedQuadBuilder bakedQuadBuilder;

    @Override
    public void setQuadTint(int tint) {
        this.bakedQuadBuilder.setQuadTint(tint);
    }

    @Override
    public void setQuadOrientation(Direction orientation) {
        this.bakedQuadBuilder.setQuadOrientation(orientation);
    }

    @Override
    public void setApplyDiffuseLighting(boolean diffuse) {
        this.bakedQuadBuilder.setApplyDiffuseLighting(diffuse);
    }

    @Override
    public void setTexture(TextureAtlasSprite texture) {
        this.bakedQuadBuilder.setTexture(texture == this.source.m_173410_() ? this.target : texture);
    }

    public ModelUVAdapter(BakedQuad source, TextureAtlasSprite target) {
        this.source = source;
        this.minU = source.m_173410_().m_118409_();
        this.uDelta = source.m_173410_().m_118410_() - this.minU;
        this.minV = source.m_173410_().m_118411_();
        this.vDelta = source.m_173410_().m_118412_() - this.minV;
        this.target = target;
        this.bakedQuadBuilder = new BakedQuadBuilder();
        this.bakedQuadBuilder.setTexture(target);
        this.bakedQuadBuilder.setQuadTint(source.m_111305_());
        this.bakedQuadBuilder.setQuadOrientation(source.m_111306_());
        this.bakedQuadBuilder.setApplyDiffuseLighting(source.m_111307_());
    }

    public void put(int element, float ... data) {
        VertexFormat format = this.getVertexFormat();
        VertexFormatElement ele = (VertexFormatElement)format.m_86023_().get(element);
        if (ele.m_86048_() == VertexFormatElement.Usage.UV && ele.m_86049_() == 0) {
            float[] uv = Arrays.copyOf(data, data.length);
            float u = (uv[0] - this.minU) / this.uDelta;
            float v = (uv[1] - this.minV) / this.vDelta;
            float newU = this.target.m_118367_((double)(u * 16.0f));
            float newV = this.target.m_118393_((double)(v * 16.0f));
            float[] newUv = new float[4];
            newUv[0] = newU;
            newUv[1] = newV;
            data = Arrays.copyOf(newUv, newUv.length);
        }
        this.bakedQuadBuilder.put(element, data);
    }

    public BakedQuad build() {
        this.source.pipe((IVertexConsumer)this);
        return this.bakedQuadBuilder.build();
    }
}

