/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.shingle.slab;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.ldtteam.domumornamentum.block.types.ShingleSlabShapeType;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import org.jetbrains.annotations.NotNull;

public class ShingleSlabBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public ShingleSlabBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getShingleSlab());
    }

    private void createBlockstateFile(HashCache cache, ShingleSlabBlock shingleSlab) throws IOException {
        if (shingleSlab.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction facingValue : HorizontalDirectionalBlock.f_54117_.m_6908_()) {
            for (ShingleSlabShapeType shapeValue : ShingleSlabShapeType.values()) {
                String variantKey = "facing=" + facingValue.m_122433_() + ",shape=" + shapeValue.m_7912_();
                int y = this.getYFromFacing(facingValue);
                String modelLocation = "domum_ornamentum:block/shingle_slab/" + shapeValue.name().toLowerCase(Locale.ROOT);
                BlockstateModelJson model = new BlockstateModelJson(modelLocation, 0, y);
                BlockstateVariantJson variant = new BlockstateVariantJson(model);
                variants.put((CallSite)((Object)variantKey), variant);
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingleSlab.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Shingle Slabs BlockStates Provider";
    }

    private int getYFromFacing(Direction facing) {
        switch (facing) {
            default: {
                return 0;
            }
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: 
        }
        return 270;
    }
}

