/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.slab;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.NotNull;

public class SlabBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public SlabBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getSlab());
    }

    private void createBlockstateFile(HashCache cache, com.ldtteam.domumornamentum.block.vanilla.SlabBlock slabBlock) throws IOException {
        if (slabBlock.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        variants.put((CallSite)((Object)(SlabBlock.f_56353_.m_61708_() + "=" + SlabType.BOTTOM.toString().toLowerCase())), new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/slabs/slab_lower")));
        variants.put((CallSite)((Object)(SlabBlock.f_56353_.m_61708_() + "=" + SlabType.DOUBLE.toString().toLowerCase())), new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/slabs/slab_full")));
        variants.put((CallSite)((Object)(SlabBlock.f_56353_.m_61708_() + "=" + SlabType.TOP.toString().toLowerCase())), new BlockstateVariantJson(new BlockstateModelJson("domum_ornamentum:block/slabs/slab_upper")));
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(slabBlock.getRegistryName().m_135815_() + ".json");
        DataProvider.m_123920_((Gson)DataGeneratorConstants.GSON, (HashCache)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Slab BlockStates Provider";
    }
}

