/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.domumornamentum.IDomumOrnamentumApi;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockManager;
import com.ldtteam.domumornamentum.jei.JEIPlugin;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipe;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class ArchitectsCutterCategory
implements IRecipeCategory<ArchitectsCutterRecipe> {
    private final JEIPlugin plugin;
    private final IDrawable background;
    private final IDrawable thumb;
    private final IDrawable slot;
    private final IDrawable button;
    private final IDrawable icon;
    private final LoadingCache<ArchitectsCutterRecipe, DisplayData> cachedDisplayData;

    public ArchitectsCutterCategory(@NotNull IGuiHelper guiHelper, @NotNull JEIPlugin plugin) {
        this.plugin = plugin;
        ResourceLocation texture = new ResourceLocation("domum_ornamentum", "textures/gui/container/architectscutter.png");
        this.background = guiHelper.createDrawable(texture, 3, 12, 170, 60);
        this.thumb = guiHelper.createDrawable(texture, 176, 0, 12, 15);
        this.slot = guiHelper.createDrawable(texture, 16, 166, 18, 18);
        this.button = guiHelper.createDrawable(texture, 0, 166, 16, 18);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)IDomumOrnamentumApi.getInstance().getBlocks().getArchitectsCutter()));
        this.cachedDisplayData = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<ArchitectsCutterRecipe, DisplayData>(){

            public DisplayData load(@NotNull ArchitectsCutterRecipe key) {
                return new DisplayData(key);
            }
        });
    }

    @NotNull
    public ResourceLocation getUid() {
        return Objects.requireNonNull(ModRecipeSerializers.ARCHITECTS_CUTTER.getRegistryName());
    }

    @NotNull
    public Class<? extends ArchitectsCutterRecipe> getRecipeClass() {
        return ArchitectsCutterRecipe.class;
    }

    @NotNull
    public Component getTitle() {
        return new TranslatableComponent("domum_ornamentum.architectscutter");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@NotNull ArchitectsCutterRecipe recipe, @NotNull IIngredients ingredients) {
        Block generatedBlock = (Block)ForgeRegistries.BLOCKS.getValue(recipe.getBlockName());
        if (!(generatedBlock instanceof IMateriallyTexturedBlock)) {
            return;
        }
        IMateriallyTexturedBlock materiallyTexturedBlock = (IMateriallyTexturedBlock)generatedBlock;
        Collection<IMateriallyTexturedBlockComponent> components = materiallyTexturedBlock.getComponents();
        List inputs = components.stream().map(component -> component.getValidSkins().m_6497_().stream().map(ItemStack::new).collect(Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), list -> {
            Collections.shuffle(list);
            return list;
        }))).collect(Collectors.toList());
        ingredients.setInputLists(VanillaTypes.ITEM, inputs);
        List defaultInputs = components.stream().map(component -> new ItemStack((ItemLike)component.getDefault())).collect(Collectors.toList());
        DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        Container container = displayData.getIngredientContainer();
        for (int i = 0; i < defaultInputs.size(); ++i) {
            container.m_6836_(i, (ItemStack)defaultInputs.get(i));
        }
        ItemStack output = recipe.m_5874_(container);
        if (output.m_41619_()) {
            output = recipe.m_8043_();
            if (output.m_41619_()) {
                output = new ItemStack((ItemLike)generatedBlock);
            }
            output.m_41764_(Math.max(components.size(), recipe.getCount()));
        }
        displayData.setOutput(output);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
    }

    public void setRecipe(@NotNull IRecipeLayout recipeLayout, @NotNull ArchitectsCutterRecipe recipe, @NotNull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, false, 139, 20);
        for (int slot = 0; slot < IMateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount(); ++slot) {
            int x = 5 + (slot & 1) * 20;
            int y = 2 + (slot >> 1) * 20;
            itemStacks.init(1 + slot, true, x, y);
            itemStacks.setBackground(1 + slot, this.slot);
        }
        itemStacks.set(ingredients);
        DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        displayData.setItemStacks(itemStacks);
    }

    public void draw(@NotNull ArchitectsCutterRecipe recipe, @NotNull PoseStack stack, double mouseX, double mouseY) {
        DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
        this.thumb.draw(stack, 116, 3);
        this.button.draw(stack, 74, 21);
        this.plugin.getIngredientManager().getIngredientRenderer(VanillaTypes.ITEM).render(stack, 75, 22, (Object)displayData.getOutput());
        displayData.reassembleIfNeeded();
        Objects.requireNonNull(displayData.getItemStacks()).set(0, List.of(displayData.getOutput()));
    }

    private static class DisplayData {
        private final ArchitectsCutterRecipe recipe;
        @Nullable
        private IGuiItemStackGroup itemStacks;
        private ItemStack output = ItemStack.f_41583_;
        private final Container ingredientContainer = new SimpleContainer(IMateriallyTexturedBlockManager.getInstance().getMaxTexturableComponentCount());

        public DisplayData(@NotNull ArchitectsCutterRecipe recipe) {
            this.recipe = recipe;
        }

        @Nullable
        public IGuiItemStackGroup getItemStacks() {
            return this.itemStacks;
        }

        public void setItemStacks(@NotNull IGuiItemStackGroup itemStacks) {
            this.itemStacks = itemStacks;
        }

        @NotNull
        public Container getIngredientContainer() {
            return this.ingredientContainer;
        }

        @NotNull
        public ItemStack getOutput() {
            return this.output;
        }

        public void setOutput(@NotNull ItemStack output) {
            this.output = output;
        }

        public void reassembleIfNeeded() {
            int i;
            Map ingredients = this.itemStacks.getGuiIngredients();
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>(ingredients.size());
            for (i = 0; i < ingredients.size(); ++i) {
                IGuiIngredient ingredient = (IGuiIngredient)ingredients.get(i);
                if (!ingredient.isInput()) continue;
                inputs.add(Objects.requireNonNullElse((ItemStack)ingredient.getDisplayedIngredient(), ItemStack.f_41583_));
            }
            if (!this.containerMatches(inputs)) {
                for (i = 0; i < inputs.size(); ++i) {
                    this.ingredientContainer.m_6836_(i, (ItemStack)inputs.get(i));
                }
                this.output = this.recipe.m_5874_(this.ingredientContainer);
            }
        }

        private boolean containerMatches(@NotNull List<ItemStack> inputs) {
            for (int i = 0; i < this.ingredientContainer.m_6643_(); ++i) {
                if (ItemStack.m_150942_((ItemStack)(i < inputs.size() ? inputs.get(i) : ItemStack.f_41583_), (ItemStack)this.ingredientContainer.m_8020_(i))) continue;
                return false;
            }
            return true;
        }
    }
}

