/*
 * Decompiled with CFR 0.152.
 */
package me.dinnerbeef.compressium.generators;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import me.dinnerbeef.compressium.CompressiumType;
import net.minecraft.data.DataGenerator;
import net.minecraftforge.common.data.LanguageProvider;

public class CompressiumLanguageProvider
extends LanguageProvider {
    private final String locale;

    public CompressiumLanguageProvider(DataGenerator gen, String locale) {
        super(gen, "compressium", locale);
        this.locale = locale;
    }

    protected void addTranslations() {
        Map config = null;
        try {
            FileReader reader = new FileReader("config/languageValues.json");
            Gson gson = new Gson();
            JsonReader configFile = new JsonReader((Reader)reader);
            config = (Map)gson.fromJson(configFile, Map.class);
        }
        catch (FileNotFoundException reader) {
            // empty catch block
        }
        if (config != null) {
            Map localeMap = (Map)config.get(this.locale);
            this.add("itemGroup.compressium", (String)localeMap.get("itemGroup"));
            for (CompressiumType type : CompressiumType.VALUES) {
                for (int i = 0; i < 9; ++i) {
                    this.add(type.blocks.get(i), (String)localeMap.get(type.name) + " (" + (i + 1) + "x)");
                }
            }
        }
    }
}

