/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class ToolSwapperUpgradeContainer
extends UpgradeContainerBase<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeContainer> {
    private static final String DATA_SHOULD_SWAP_WEAPON = "shouldSwapWeapon";
    private static final String DATA_TOOL_SWAP_MODE = "toolSwapMode";
    private final FilterLogicContainer<FilterLogic> filterLogicContainer = new FilterLogicContainer<FilterLogic>(upgradeWrapper::getFilterLogic, this, this.slots::add);

    public ToolSwapperUpgradeContainer(Player player, int upgradeContainerId, ToolSwapperUpgradeWrapper upgradeWrapper, UpgradeContainerType<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_(DATA_SHOULD_SWAP_WEAPON)) {
            this.setSwapWeapon(data.m_128471_(DATA_SHOULD_SWAP_WEAPON));
        } else if (data.m_128441_(DATA_TOOL_SWAP_MODE)) {
            this.setToolSwapMode(ToolSwapMode.fromName(data.m_128461_(DATA_TOOL_SWAP_MODE)));
        } else {
            this.filterLogicContainer.handleMessage(data);
        }
    }

    public FilterLogicContainer<FilterLogic> getFilterLogicContainer() {
        return this.filterLogicContainer;
    }

    public void setSwapWeapon(boolean shouldSwapWeapon) {
        ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).setSwapWeapon(shouldSwapWeapon);
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundTag(), DATA_SHOULD_SWAP_WEAPON, shouldSwapWeapon));
    }

    public boolean shouldSwapWeapon() {
        return ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).shouldSwapWeapon();
    }

    public void setToolSwapMode(ToolSwapMode toolSwapMode) {
        ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).setToolSwapMode(toolSwapMode);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundTag(), DATA_TOOL_SWAP_MODE, toolSwapMode));
    }

    public ToolSwapMode getToolSwapMode() {
        return ((ToolSwapperUpgradeWrapper)this.upgradeWrapper).getToolSwapMode();
    }
}

