/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.network.TransferFullSlotMessage;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.ICraftingUIPart;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;

public abstract class StorageScreenBase<S extends StorageContainerMenuBase<?>>
extends AbstractContainerScreen<S> {
    public static final int ERROR_BACKGROUND_COLOR = -267386864;
    public static final int ERROR_BORDER_COLOR = ColorHelper.getColor(DyeColor.RED.m_41068_()) | 0xFF000000;
    private static final int DISABLED_SLOT_COLOR = -1072689136;
    private static final int UPGRADE_TOP_HEIGHT = 7;
    private static final int UPGRADE_SLOT_HEIGHT = 18;
    private static final int UPGRADE_SPACE_BETWEEN_SLOTS = 4;
    private static final int UPGRADE_BOTTOM_HEIGHT = 7;
    private static final int TOTAL_UPGRADE_GUI_HEIGHT = 252;
    public static final int UPGRADE_INVENTORY_OFFSET = 26;
    public static final int DISABLED_SLOT_X_POS = -1000;
    static final int SLOTS_Y_OFFSET = 17;
    static final int SLOTS_X_OFFSET = 7;
    public static final int ERROR_SLOT_COLOR = ColorHelper.getColor(DyeColor.RED.m_41068_()) | 0xAA000000;
    private static final int ERROR_TEXT_COLOR = ColorHelper.getColor(DyeColor.RED.m_41068_());
    private UpgradeSettingsTabControl settingsTabControl;
    private final int numberOfUpgradeSlots;
    @Nullable
    private Button sortButton = null;
    @Nullable
    private ToggleButton<SortBy> sortByButton = null;
    private final Set<ToggleButton<Boolean>> upgradeSwitches = new HashSet<ToggleButton<Boolean>>();
    private final Map<Integer, UpgradeInventoryPartBase<?>> inventoryParts = new LinkedHashMap();
    private static ICraftingUIPart craftingUIPart = ICraftingUIPart.NOOP;

    public static void setCraftingUIPart(ICraftingUIPart part) {
        craftingUIPart = part;
    }

    protected StorageScreenBase(S pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.f_97727_ = 114 + ((StorageContainerMenuBase)this.m_6262_()).getNumberOfRows() * 18;
        this.f_97726_ = ((StorageContainerMenuBase)this.m_6262_()).getStorageBackgroundProperties().getSlotsOnLine() * 18 + 14;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8 + ((StorageContainerMenuBase)this.m_6262_()).getStorageBackgroundProperties().getPlayerInventoryXOffset();
        this.numberOfUpgradeSlots = ((StorageContainerMenuBase)this.m_6262_()).getNumberOfUpgradeSlots();
        this.f_96546_ = true;
    }

    public ICraftingUIPart getCraftingUIAddition() {
        return craftingUIPart;
    }

    protected void m_7856_() {
        super.m_7856_();
        craftingUIPart.setStorageScreen(this);
        this.initUpgradeSettingsControl();
        this.initUpgradeInventoryParts();
        this.addUpgradeSwitches();
        ((StorageContainerMenuBase)this.m_6262_()).setUpgradeChangeListener(c -> {
            this.m_6702_().remove((Object)this.settingsTabControl);
            craftingUIPart.onCraftingSlotsHidden();
            this.initUpgradeSettingsControl();
            this.initUpgradeInventoryParts();
            this.addUpgradeSwitches();
        });
        this.addSortButtons();
    }

    private void initUpgradeInventoryParts() {
        this.inventoryParts.clear();
        if (((StorageContainerMenuBase)this.m_6262_()).getColumnsTaken() == 0) {
            return;
        }
        AtomicReference<Position> pos = new AtomicReference<Position>(new Position(7 + ((StorageContainerMenuBase)this.f_97732_).getSlotsOnLine() * 18, 17));
        int height = ((StorageContainerMenuBase)this.f_97732_).getNumberOfRows() * 18;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((StorageContainerMenuBase)this.m_6262_()).getUpgradeContainers().entrySet()) {
            UpgradeContainerBase<?, ?> container = entry.getValue();
            UpgradeGuiManager.getInventoryPart(entry.getKey(), container, pos.get(), height, this).ifPresent(part -> {
                this.inventoryParts.put((Integer)entry.getKey(), (UpgradeInventoryPartBase<?>)part);
                pos.set(new Position(((Position)pos.get()).x() + 36, ((Position)pos.get()).y()));
            });
        }
    }

    private void addUpgradeSwitches() {
        this.upgradeSwitches.clear();
        int switchTop = this.f_97736_ + this.getUpgradeTop() + 10;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.f_97732_).canDisableUpgrade(slot)) {
                int finalSlot = slot;
                ToggleButton<Boolean> upgradeSwitch = new ToggleButton<Boolean>(new Position(this.f_97735_ - 22, switchTop), ButtonDefinitions.UPGRADE_SWITCH, button -> ((StorageContainerMenuBase)this.m_6262_()).setUpgradeEnabled(finalSlot, !((StorageContainerMenuBase)this.m_6262_()).getUpgradeEnabled(finalSlot)), () -> ((StorageContainerMenuBase)this.m_6262_()).getUpgradeEnabled(finalSlot));
                this.m_7787_(upgradeSwitch);
                this.upgradeSwitches.add(upgradeSwitch);
            }
            switchTop += 22;
        }
    }

    private void addSortButtons() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        if (sortButtonsPosition == SortButtonsPosition.HIDDEN) {
            return;
        }
        Position pos = this.getSortButtonsPosition(sortButtonsPosition);
        this.sortButton = new Button(new Position(pos.x(), pos.y()), ButtonDefinitions.SORT, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.m_6262_()).sort();
                Minecraft.m_91087_().f_91074_.m_5661_((Component)new TextComponent("Sorted"), true);
            }
        });
        this.m_7787_(this.sortButton);
        this.sortByButton = new ToggleButton<SortBy>(new Position(pos.x() + 14, pos.y()), ButtonDefinitions.SORT_BY, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.m_6262_()).setSortBy(((StorageContainerMenuBase)this.m_6262_()).getSortBy().next());
            }
        }, () -> ((StorageContainerMenuBase)this.m_6262_()).getSortBy());
        this.m_7787_(this.sortByButton);
    }

    private Position getSortButtonsPosition(SortButtonsPosition sortButtonsPosition) {
        return switch (sortButtonsPosition) {
            case SortButtonsPosition.ABOVE_UPGRADES -> new Position(this.f_97735_ - 26 - 2, this.f_97736_ + this.getUpgradeTop() - 14);
            case SortButtonsPosition.BELOW_UPGRADES -> new Position(this.f_97735_ - 26 - 2, this.f_97736_ + this.getUpgradeTop() + this.getUpgradeHeightWithoutBottom() + 7 + 2);
            case SortButtonsPosition.BELOW_UPGRADE_TABS -> {
                if (this.settingsTabControl == null) {
                    yield new Position(0, 0);
                }
                yield new Position(this.settingsTabControl.getX() + 2, this.settingsTabControl.getY() + Math.max(0, this.settingsTabControl.getHeight() + 2));
            }
            case SortButtonsPosition.TITLE_LINE_RIGHT -> new Position(this.f_97735_ + this.f_97726_ - 34, this.f_97736_ + 4);
            default -> new Position(this.f_97735_ + this.f_97726_ - 34, this.f_97736_ + 4);
        };
    }

    private void initUpgradeSettingsControl() {
        this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.f_97735_ + this.f_97726_, this.f_97736_ + 4), this, this.getStorageSettingsTabTooltip());
        this.m_7787_(this.settingsTabControl);
    }

    protected abstract String getStorageSettingsTabTooltip();

    public int getUpgradeTop() {
        return this.f_97727_ - 94 - this.getUpgradeHeight();
    }

    public int getUpgradeHeight() {
        return this.getUpgradeHeightWithoutBottom() + 7;
    }

    protected int getUpgradeHeightWithoutBottom() {
        return 7 + this.numberOfUpgradeSlots * 18 + (this.numberOfUpgradeSlots - 1) * 4;
    }

    public Optional<Rect2i> getSortButtonsRectangle() {
        return this.sortButton == null || this.sortByButton == null ? Optional.empty() : Optional.of(new Rect2i(this.sortButton.getX(), this.sortButton.getY(), this.sortByButton.getX() + this.sortByButton.getWidth() - this.sortButton.getX(), this.sortByButton.getY() + this.sortByButton.getHeight() - this.sortButton.getY()));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ((StorageContainerMenuBase)this.f_97732_).detectSettingsChangeAndReload();
        this.m_7333_(matrixStack);
        this.settingsTabControl.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        matrixStack.m_85837_(0.0, 0.0, 200.0);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderTooltip((Screen)this, matrixStack, mouseX, mouseY);
        if (this.sortButton != null && this.sortByButton != null) {
            this.sortButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.sortByButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.upgradeSwitches.forEach(us -> us.m_6305_(matrixStack, mouseX, mouseY, partialTicks));
        this.renderErrorOverlay(matrixStack);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.renderUpgradeInventoryParts(matrixStack, mouseX, mouseY);
        this.renderUpgradeSlots(matrixStack, mouseX, mouseY);
        this.renderRealInventorySlots(matrixStack, mouseX, mouseY);
    }

    private void renderUpgradeInventoryParts(PoseStack matrixStack, int mouseX, int mouseY) {
        this.inventoryParts.values().forEach(ip -> ip.render(matrixStack, mouseX, mouseY));
    }

    private void renderRealInventorySlots(PoseStack matrixStack, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.size(); ++slotId) {
            Slot slot = ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.get(slotId);
            this.m_97799_(matrixStack, slot);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
        }
    }

    private void renderUpgradeSlots(PoseStack matrixStack, int mouseX, int mouseY) {
        for (int slotId = 0; slotId < ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.size(); ++slotId) {
            Slot slot = ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.get(slotId);
            if (slot.f_40220_ != -1000) {
                this.m_97799_(matrixStack, slot);
                if (!slot.m_6659_()) {
                    this.renderSlotOverlay(matrixStack, slot, -1072689136);
                }
            }
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.f_97734_ = slot;
            this.renderSlotOverlay(matrixStack, slot, this.getSlotColor(slotId));
        }
    }

    protected void m_97799_(PoseStack matrixStack, Slot slot) {
        int i = slot.f_40220_;
        int j = slot.f_40221_;
        ItemStack itemstack = slot.m_7993_();
        boolean flag = false;
        boolean rightClickDragging = slot == this.f_97706_ && !this.f_97711_.m_41619_() && !this.f_97710_;
        ItemStack itemstack1 = ((StorageContainerMenuBase)this.m_6262_()).m_142621_();
        String stackCountText = null;
        if (slot == this.f_97706_ && !this.f_97711_.m_41619_() && this.f_97710_ && !itemstack.m_41619_()) {
            itemstack = itemstack.m_41777_();
            itemstack.m_41764_(itemstack.m_41613_() / 2);
        } else if (this.f_97738_ && this.f_97737_.contains(slot) && !itemstack1.m_41619_()) {
            if (this.f_97737_.size() == 1) {
                return;
            }
            if (StorageContainerMenuBase.canItemQuickReplace(slot, itemstack1) && ((StorageContainerMenuBase)this.f_97732_).m_5622_(slot)) {
                itemstack = itemstack1.m_41777_();
                flag = true;
                AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)itemstack, (int)(slot.m_7993_().m_41619_() ? 0 : slot.m_7993_().m_41613_()));
                int slotLimit = slot.m_5866_(itemstack);
                if (itemstack.m_41613_() > slotLimit) {
                    stackCountText = ChatFormatting.YELLOW + CountAbbreviator.abbreviate(slotLimit);
                    itemstack.m_41764_(slotLimit);
                }
            } else {
                this.f_97737_.remove(slot);
                this.m_97818_();
            }
        }
        this.m_93250_(100);
        this.f_96542_.f_115093_ = 100.0f;
        if (itemstack.m_41619_() && slot.m_6659_()) {
            this.renderSlotBackground(matrixStack, slot, i, j);
        } else if (!rightClickDragging) {
            this.renderStack(matrixStack, i, j, itemstack, flag, stackCountText);
        }
        this.f_96542_.f_115093_ = 0.0f;
        this.m_93250_(0);
    }

    private void renderStack(PoseStack poseStack, int i, int j, ItemStack itemstack, boolean flag, @Nullable String stackCountText) {
        if (flag) {
            StorageScreenBase.m_93172_((PoseStack)poseStack, (int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
        }
        RenderSystem.m_69482_();
        this.f_96542_.m_115203_(itemstack, i, j);
        if (this.shouldUseSpecialCountRender(itemstack)) {
            this.f_96542_.m_115174_(this.f_96547_, itemstack, i, j, "");
            if (stackCountText == null) {
                stackCountText = CountAbbreviator.abbreviate(itemstack.m_41613_());
            }
            this.renderStackCount(stackCountText, i, j);
        } else {
            this.f_96542_.m_115174_(this.f_96547_, itemstack, i, j, stackCountText);
        }
    }

    private void renderSlotBackground(PoseStack poseStack, Slot slot, int i, int j) {
        Optional<ItemStack> memorizedStack = ((StorageContainerMenuBase)this.m_6262_()).getMemorizedStackInSlot(slot.f_40219_);
        if (memorizedStack.isPresent()) {
            this.f_96542_.m_115203_(memorizedStack.get(), i, j);
            this.drawMemorizedStackOverlay(poseStack, i, j);
        } else {
            Pair pair = slot.m_7543_();
            if (pair != null) {
                TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)this.f_96541_.m_91258_((ResourceLocation)pair.getFirst()).apply((ResourceLocation)pair.getSecond());
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
                StorageScreenBase.m_93200_((PoseStack)poseStack, (int)i, (int)j, (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)textureatlassprite);
            }
        }
    }

    private void drawMemorizedStackOverlay(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69465_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiHelper.GUI_CONTROLS);
        this.m_93228_(poseStack, x, y, 77, 0, 16, 16);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    private boolean shouldUseSpecialCountRender(ItemStack itemstack) {
        return itemstack.m_41613_() > 99;
    }

    private void renderSlotOverlay(PoseStack matrixStack, Slot slot, int slotColor) {
        this.renderSlotOverlay(matrixStack, slot, slotColor, 0, 16);
    }

    private void renderSlotOverlay(PoseStack matrixStack, Slot slot, int slotColor, int yOffset, int height) {
        this.renderOverlay(matrixStack, slotColor, slot.f_40220_, slot.f_40221_ + yOffset, 16, height);
    }

    public void renderOverlay(PoseStack matrixStack, int slotColor, int xPos, int yPos, int width, int height) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.m_93179_(matrixStack, xPos, yPos, xPos + width, yPos + height, slotColor, slotColor);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        this.drawInventoryBackground(matrixStack);
        this.drawUpgradeBackground(matrixStack);
    }

    protected void m_7025_(PoseStack poseStack, int x, int y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, -100.0);
        this.inventoryParts.values().forEach(part -> part.renderTooltip(this, poseStack, x, y));
        if (((StorageContainerMenuBase)this.m_6262_()).m_142621_().m_41619_() && this.f_97734_ != null) {
            if (this.f_97734_.m_6657_()) {
                this.m_6057_(poseStack, this.f_97734_.m_7993_(), x, y);
            } else {
                INameableEmptySlot emptySlot;
                Slot slot = this.f_97734_;
                if (slot instanceof INameableEmptySlot && (emptySlot = (INameableEmptySlot)slot).hasEmptyTooltip()) {
                    this.renderComponentTooltip(poseStack, Collections.singletonList(emptySlot.getEmptyTooltip()), x, y, this.f_96547_);
                }
            }
        }
        if (this.sortButton != null) {
            this.sortButton.renderTooltip((Screen)this, poseStack, x, y);
        }
        if (this.sortByButton != null) {
            this.sortByButton.renderTooltip((Screen)this, poseStack, x, y);
        }
        poseStack.m_85849_();
    }

    public List<Component> m_96555_(ItemStack itemStack) {
        List ret = super.m_96555_(itemStack);
        if (itemStack.m_41613_() > 999) {
            ret.add(new TranslatableComponent("gui.sophisticatedcore.tooltip.stack_count", new Object[]{new TextComponent(NumberFormat.getNumberInstance().format(itemStack.m_41613_())).m_130940_(ChatFormatting.DARK_AQUA)}).m_130940_(ChatFormatting.GRAY));
        }
        return ret;
    }

    private void drawInventoryBackground(PoseStack matrixStack) {
        StorageBackgroundProperties storageBackgroundProperties = ((StorageContainerMenuBase)this.m_6262_()).getStorageBackgroundProperties();
        StorageGuiHelper.renderStorageBackground(new Position((this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2), matrixStack, ((StorageContainerMenuBase)this.m_6262_()).getNumberOfStorageInventorySlots(), ((StorageContainerMenuBase)this.m_6262_()).getSlotsOnLine(), storageBackgroundProperties.getTextureName(), this.f_97726_, ((StorageContainerMenuBase)this.f_97732_).getNumberOfRows());
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.getGuiLeft(), (double)this.getGuiTop(), 0.0);
        for (int slotNumber = 0; slotNumber < ((StorageContainerMenuBase)this.f_97732_).getNumberOfStorageInventorySlots(); ++slotNumber) {
            List<Integer> colors = ((StorageContainerMenuBase)this.f_97732_).getSlotOverlayColors(slotNumber);
            if (colors.isEmpty()) continue;
            int stripeHeight = 16 / colors.size();
            int i = 0;
            for (int slotColor : colors) {
                int yOffset = i * stripeHeight;
                this.renderSlotOverlay(matrixStack, ((StorageContainerMenuBase)this.f_97732_).m_38853_(slotNumber), slotColor | 0x50000000, yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight);
                ++i;
            }
        }
        matrixStack.m_85849_();
    }

    private void drawUpgradeBackground(PoseStack matrixStack) {
        if (this.numberOfUpgradeSlots == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiHelper.GUI_CONTROLS);
        int firstHalfHeight = this.getUpgradeHeightWithoutBottom();
        StorageScreenBase.m_93133_((PoseStack)matrixStack, (int)(this.f_97735_ - 26), (int)(this.f_97736_ + this.getUpgradeTop()), (float)0.0f, (float)0.0f, (int)29, (int)firstHalfHeight, (int)256, (int)256);
        StorageScreenBase.m_93133_((PoseStack)matrixStack, (int)(this.f_97735_ - 26), (int)(this.f_97736_ + this.getUpgradeTop() + firstHalfHeight), (float)0.0f, (float)245.0f, (int)29, (int)7, (int)256, (int)256);
    }

    public UpgradeSettingsTabControl getUpgradeSettingsControl() {
        if (this.settingsTabControl == null) {
            this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.f_97735_ + this.f_97726_, this.f_97736_ + 4), this, this.getStorageSettingsTabTooltip());
        }
        return this.settingsTabControl;
    }

    @Nullable
    public Slot m_97744_(double mouseX, double mouseY) {
        Slot slot;
        int i;
        for (i = 0; i < ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.f_97732_).upgradeSlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        for (i = 0; i < ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.f_97732_).realInventorySlots.get(i);
            if (!this.m_97774_(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            return slot;
        }
        return super.m_97744_(mouseX, mouseY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (UpgradeInventoryPartBase<?> inventoryPart : this.inventoryParts.values()) {
            if (!inventoryPart.handleMouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        this.handleQuickMoveAll(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void handleQuickMoveAll(double mouseX, double mouseY, int button) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (this.f_97723_ && !((StorageContainerMenuBase)this.m_6262_()).m_142621_().m_41619_() && slot != null && button == 0 && ((StorageContainerMenuBase)this.f_97732_).m_5882_(ItemStack.f_41583_, slot) && StorageScreenBase.m_96638_() && !this.f_97724_.m_41619_()) {
            for (Slot slot2 : ((StorageContainerMenuBase)this.f_97732_).realInventorySlots) {
                this.tryQuickMoveSlot(button, slot, slot2);
            }
        }
    }

    private void tryQuickMoveSlot(int button, Slot slot, Slot slot2) {
        ItemStack slotItem;
        if (slot2.m_8010_((Player)this.f_96541_.f_91074_) && slot2.m_6657_() && slot2.isSameInventory(slot) && ItemStack.m_150942_((ItemStack)this.f_97724_, (ItemStack)(slotItem = slot2.m_7993_()))) {
            if (slotItem.m_41613_() > slotItem.m_41741_()) {
                SophisticatedCore.PACKET_HANDLER.sendToServer(new TransferFullSlotMessage(slot2.f_40219_));
            } else {
                this.m_6597_(slot2, slot2.f_40219_, button, ClickType.QUICK_MOVE);
            }
        }
    }

    protected void m_6597_(Slot slot, int slotNumber, int mouseButton, ClickType type) {
        if (type == ClickType.PICKUP_ALL && !((StorageContainerMenuBase)this.f_97732_).getSlotUpgradeContainer(slot).map(c -> c.allowsPickupAll(slot)).orElse(true).booleanValue()) {
            type = ClickType.PICKUP;
        }
        this.handleInventoryMouseClick(slotNumber, mouseButton, type);
    }

    private void handleInventoryMouseClick(int slotNumber, int mouseButton, ClickType type) {
        ItemStack itemstack;
        int lastChecked;
        ItemStack slotStack;
        ItemStack itemstack2;
        int i;
        StorageContainerMenuBase menu = (StorageContainerMenuBase)this.m_6262_();
        ArrayList realInventoryItems = new ArrayList(menu.realInventorySlots.size());
        menu.realInventorySlots.forEach(slot -> realInventoryItems.add(slot.m_7993_().m_41777_()));
        ArrayList upgradeItems = new ArrayList(menu.upgradeSlots.size());
        menu.upgradeSlots.forEach(slot -> upgradeItems.add(slot.m_7993_().m_41777_()));
        menu.m_150399_(slotNumber, mouseButton, type, (Player)this.f_96541_.f_91074_);
        Int2ObjectOpenHashMap changedSlotIndexes = new Int2ObjectOpenHashMap();
        int inventorySlotsToCheck = Math.min(realInventoryItems.size() - 36, menu.getInventorySlotsSize() - 36);
        for (i = 0; i < inventorySlotsToCheck; ++i) {
            ItemStack slotStack2;
            itemstack2 = (ItemStack)realInventoryItems.get(i);
            if (ItemStack.m_41728_((ItemStack)itemstack2, (ItemStack)(slotStack2 = menu.m_38853_(i).m_7993_()))) continue;
            changedSlotIndexes.put(i, (Object)slotStack2.m_41777_());
        }
        for (i = 0; i < 36; ++i) {
            int slotIndex;
            itemstack2 = (ItemStack)realInventoryItems.get(realInventoryItems.size() - 36 + i);
            if (ItemStack.m_41728_((ItemStack)itemstack2, (ItemStack)(slotStack = menu.m_38853_(slotIndex = menu.getInventorySlotsSize() - 36 + i).m_7993_()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack.m_41777_());
        }
        int upgradeSlotsToCheck = Math.min(menu.getUpgradeSlotsSize(), upgradeItems.size());
        for (lastChecked = 0; lastChecked < upgradeSlotsToCheck && ItemStack.m_41728_((ItemStack)(itemstack = (ItemStack)upgradeItems.get(lastChecked)), (ItemStack)(slotStack = menu.m_38853_(menu.getInventorySlotsSize() + lastChecked).m_7993_())); ++lastChecked) {
        }
        for (int i2 = upgradeSlotsToCheck - 1; i2 >= lastChecked; --i2) {
            int slotIndex;
            ItemStack slotStack3;
            ItemStack itemstack3 = (ItemStack)upgradeItems.get(i2);
            if (ItemStack.m_41728_((ItemStack)itemstack3, (ItemStack)(slotStack3 = menu.m_38853_(slotIndex = menu.getInventorySlotsSize() + i2).m_7993_()))) continue;
            changedSlotIndexes.put(slotIndex, (Object)slotStack3.m_41777_());
        }
        this.f_96541_.f_91074_.f_108617_.m_104955_((Packet)new ServerboundContainerClickPacket(menu.f_38840_, menu.m_182424_(), slotNumber, mouseButton, type, menu.m_142621_().m_41777_(), (Int2ObjectMap)changedSlotIndexes));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Slot slot = this.m_97744_(mouseX, mouseY);
        if (StorageScreenBase.m_96638_() && StorageScreenBase.m_96637_() && slot instanceof StorageInventorySlot && button == 0) {
            SophisticatedCore.PACKET_HANDLER.sendToServer(new TransferFullSlotMessage(slot.f_40219_));
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_7979_(mouseX, mouseY, button, dragX, dragY)) continue;
            return true;
        }
        Slot slot = this.m_97744_(mouseX, mouseY);
        ItemStack itemstack = ((StorageContainerMenuBase)this.m_6262_()).m_142621_();
        if (this.f_97738_ && slot != null && !itemstack.m_41619_() && (itemstack.m_41613_() > this.f_97737_.size() || this.f_97717_ == 2) && StorageContainerMenuBase.canItemQuickReplace(slot, itemstack) && slot.m_5857_(itemstack) && ((StorageContainerMenuBase)this.f_97732_).m_5622_(slot)) {
            this.f_97737_.add(slot);
            this.m_97818_();
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.hasClickedOutsideOfUpgradeSlots(mouseX, mouseY) && this.hasClickedOutsideOfUpgradeSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfUpgradeSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.m_110087_((int)mouseX, (int)mouseY));
    }

    private boolean hasClickedOutsideOfUpgradeSlots(double mouseX, double mouseY) {
        return this.getUpgradeSlotsRectangle().map(r -> r.m_110087_((int)mouseX, (int)mouseY)).orElse(false) == false;
    }

    public Optional<Rect2i> getUpgradeSlotsRectangle() {
        return this.numberOfUpgradeSlots == 0 ? Optional.empty() : Optional.of(new Rect2i(this.f_97735_ - 26, this.f_97736_ + this.getUpgradeTop(), 32, this.getUpgradeHeight()));
    }

    private void renderStackCount(String count, int x, int y) {
        PoseStack posestack = new PoseStack();
        posestack.m_85837_(0.0, 0.0, (double)(this.f_96542_.f_115093_ + 200.0f));
        float scale = Math.min(1.0f, 16.0f / (float)this.f_96547_.m_92895_(count));
        if (scale < 1.0f) {
            posestack.m_85841_(scale, scale, 1.0f);
        }
        MultiBufferSource.BufferSource renderBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.f_96547_.m_92811_(count, ((float)(x + 19 - 2) - (float)this.f_96547_.m_92895_(count) * scale) / scale, ((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale, 0xFFFFFF, true, posestack.m_85850_().m_85861_(), (MultiBufferSource)renderBuffer, false, 0, 0xF000F0);
        renderBuffer.m_109911_();
    }

    protected void m_97818_() {
        ItemStack cursorStack = ((StorageContainerMenuBase)this.m_6262_()).m_142621_();
        if (!cursorStack.m_41619_() && this.f_97738_) {
            if (this.f_97717_ == 2) {
                this.f_97720_ = cursorStack.m_41741_();
            } else {
                this.f_97720_ = cursorStack.m_41613_();
                for (Slot slot : this.f_97737_) {
                    ItemStack itemstack1 = cursorStack.m_41777_();
                    ItemStack slotStack = slot.m_7993_();
                    int slotStackCount = slotStack.m_41619_() ? 0 : slotStack.m_41613_();
                    AbstractContainerMenu.m_38922_((Set)this.f_97737_, (int)this.f_97717_, (ItemStack)itemstack1, (int)slotStackCount);
                    int j = slot.m_5866_(itemstack1);
                    if (itemstack1.m_41613_() > j) {
                        itemstack1.m_41764_(j);
                    }
                    this.f_97720_ -= itemstack1.m_41613_() - slotStackCount;
                }
            }
        }
    }

    private void renderErrorOverlay(PoseStack matrixStack) {
        ((StorageContainerMenuBase)this.f_97732_).getErrorUpgradeSlotChangeResult().ifPresent(upgradeSlotChangeResult -> upgradeSlotChangeResult.getErrorMessage().ifPresent(overlayErrorMessage -> {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)this.getGuiLeft(), (double)this.getGuiTop(), 0.0);
            upgradeSlotChangeResult.getErrorUpgradeSlots().forEach(slotIndex -> this.renderSlotOverlay(matrixStack, ((StorageContainerMenuBase)this.f_97732_).m_38853_(((StorageContainerMenuBase)this.f_97732_).getFirstUpgradeSlot() + slotIndex), ERROR_SLOT_COLOR));
            upgradeSlotChangeResult.getErrorInventorySlots().forEach(slotIndex -> {
                Slot slot = ((StorageContainerMenuBase)this.f_97732_).m_38853_((int)slotIndex);
                if (slot != null) {
                    this.renderSlotOverlay(matrixStack, slot, ERROR_SLOT_COLOR);
                }
            });
            upgradeSlotChangeResult.getErrorInventoryParts().forEach(partIndex -> {
                if (this.inventoryParts.size() > partIndex) {
                    this.inventoryParts.get(partIndex).renderErrorOverlay(matrixStack);
                }
            });
            matrixStack.m_85849_();
            this.renderErrorMessage(matrixStack, (Component)overlayErrorMessage);
        }));
    }

    private void renderErrorMessage(PoseStack matrixStack, Component overlayErrorMessage) {
        matrixStack.m_85836_();
        RenderSystem.m_69465_();
        matrixStack.m_85837_((double)((float)this.f_96543_ / 2.0f), (double)this.f_97736_ + (double)this.f_97731_ + 4.0, 300.0);
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        int tooltipWidth = this.f_96547_.m_92852_((FormattedText)overlayErrorMessage);
        ArrayList<Object> wrappedTextLines = new ArrayList<Object>();
        int maxLineWidth = 260;
        if (tooltipWidth > maxLineWidth) {
            int wrappedTooltipWidth = 0;
            List wrappedLine = this.f_96547_.m_92865_().m_92414_((FormattedText)overlayErrorMessage, maxLineWidth, Style.f_131099_);
            for (FormattedText line : wrappedLine) {
                int lineWidth = this.f_96547_.m_92852_(line);
                if (lineWidth > wrappedTooltipWidth) {
                    wrappedTooltipWidth = lineWidth;
                }
                wrappedTextLines.add(line);
            }
            tooltipWidth = wrappedTooltipWidth;
        } else {
            wrappedTextLines.add(overlayErrorMessage);
        }
        int tooltipHeight = 8;
        if (wrappedTextLines.size() > 1) {
            tooltipHeight += 2 + (wrappedTextLines.size() - 1) * 10;
        }
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        float leftX = (float)(-tooltipWidth) / 2.0f;
        GuiHelper.renderTooltipBackground(matrix4f, tooltipWidth, (int)leftX, 0, tooltipHeight, -267386864, ERROR_BORDER_COLOR, ERROR_BORDER_COLOR);
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85837_(0.0, 0.0, 400.0);
        GuiHelper.writeTooltipLines(wrappedTextLines, fontrenderer, leftX, 0, matrix4f, renderTypeBuffer, ERROR_TEXT_COLOR);
        renderTypeBuffer.m_109911_();
        matrixStack.m_85849_();
    }
}

